/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.laf.StyleConstants;
import com.alee.laf.label.WebLabel;
import com.alee.managers.language.LanguageMethods;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;

public class WebStepLabel
extends WebLabel
implements ShapeProvider,
LanguageMethods {
    private Color topBgColor = StyleConstants.topBgColor;
    private Color bottomBgColor = StyleConstants.bottomBgColor;
    private Color selectedBgColor = StyleConstants.selectedBgColor;
    private Color borderColor = StyleConstants.darkBorderColor;
    private Color disabledBorderColor = StyleConstants.disabledBorderColor;
    private final Stroke stroke = new BasicStroke(2.5f, 1, 1, 1.0f);
    private boolean selected = false;

    public WebStepLabel() {
        this.setupSettings();
    }

    public WebStepLabel(Icon icon) {
        super(icon);
        this.setupSettings();
    }

    public WebStepLabel(Icon icon, int n) {
        super(icon, n);
        this.setupSettings();
    }

    public WebStepLabel(String string) {
        super(string);
        this.setupSettings();
    }

    public WebStepLabel(String string, int n) {
        super(string, n);
        this.setupSettings();
    }

    public WebStepLabel(String string, Icon icon, int n) {
        super(string, icon, n);
        this.setupSettings();
    }

    protected void setupSettings() {
        this.setOpaque(false);
        this.setDrawShade(true);
        this.setForeground(Color.DARK_GRAY);
        this.setShadeColor(Color.LIGHT_GRAY);
        this.setMargin(8);
        this.setHorizontalAlignment(0);
        SwingUtils.setBoldFont(this);
        SwingUtils.setFontSize(this, 20);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.repaint();
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        this.disabledBorderColor = color;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    @Override
    public Shape provideShape() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = Math.min(n, n2);
        return new RoundRectangle2D.Double(n / 2 - n3 / 2 + 1, n2 / 2 - n3 / 2 + 1, n3 - 3, n3 - 3, this.getWidth() - 4, this.getHeight() - 4);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = Math.min(n, n2);
        if (this.getBackground() != null) {
            if (this.selected) {
                graphics2D.setPaint(this.selectedBgColor);
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.topBgColor, 0.0f, this.getHeight(), this.bottomBgColor));
            }
            graphics2D.fillRoundRect(n / 2 - n3 / 2 + 1, n2 / 2 - n3 / 2 + 1, n3 - 2, n3 - 2, this.getWidth() - 4, this.getHeight() - 4);
        }
        if (this.getBorderColor() != null) {
            graphics2D.setStroke(this.stroke);
            graphics2D.setPaint(this.isEnabled() ? this.borderColor : this.disabledBorderColor);
            graphics2D.drawRoundRect(n / 2 - n3 / 2 + 1, n2 / 2 - n3 / 2 + 1, n3 - 3, n3 - 3, this.getWidth() - 4, this.getHeight() - 4);
        }
        LafUtils.restoreAntialias(graphics2D, object);
        super.paintComponent(graphics);
    }

    @Override
    public Dimension getPreferredSize() {
        int n;
        Dimension dimension = super.getPreferredSize();
        dimension.width = n = Math.max(dimension.width, dimension.height);
        dimension.height = n;
        return dimension;
    }
}

