/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingConstants;

public class AlignLayout
implements LayoutManager,
SwingConstants {
    public static final String SEPARATOR = ",";
    public static final List<Integer> horizontals = Arrays.asList(2, 0, 4);
    public static final List<Integer> verticals = Arrays.asList(1, 0, 3);
    private Map<Component, String> constraints = new HashMap<Component, String>();
    private int hgap = 0;
    private int vgap = 0;
    private boolean hfill = false;
    private boolean vfill = false;

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public boolean isHfill() {
        return this.hfill;
    }

    public void setHfill(boolean bl) {
        this.hfill = bl;
    }

    public boolean isVfill() {
        return this.vfill;
    }

    public void setVfill(boolean bl) {
        this.vfill = bl;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string != null && !string.trim().equals("")) {
            try {
                int n;
                int n2 = this.getHalign(string);
                if (!horizontals.contains(n2)) {
                    this.illegalArgument();
                }
                if (!verticals.contains(n = this.getValign(string))) {
                    this.illegalArgument();
                }
            }
            catch (Throwable throwable) {
                this.illegalArgument();
            }
        } else {
            string = "0,0";
        }
        this.constraints.put(component, string);
    }

    private void illegalArgument() {
        throw new IllegalArgumentException("Cannot add to layout: please specify proper alignment constraints");
    }

    private int getHalign(String string) {
        return Integer.parseInt(string.substring(0, string.indexOf(SEPARATOR)));
    }

    private int getValign(String string) {
        return Integer.parseInt(string.substring(string.indexOf(SEPARATOR) + SEPARATOR.length()));
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        Cloneable cloneable;
        if (container.getComponentCount() > 1) {
            cloneable = new HashMap();
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (int n : horizontals) {
                for (int n2 : verticals) {
                    int n3;
                    Dimension dimension2 = this.getSideSize(container, n, n2);
                    if (dimension2 == null) continue;
                    if (!this.hfill) {
                        n3 = cloneable.containsKey(n) ? (Integer)cloneable.get(n) : 0;
                        cloneable.put(n, Math.max(n3, dimension2.width));
                    }
                    if (this.vfill) continue;
                    n3 = cloneable.containsKey(n2) ? (Integer)cloneable.get(n2) : 0;
                    hashMap.put(n2, Math.max(n3, dimension2.height));
                }
            }
            dimension = new Dimension(0, 0);
            if (this.hfill) {
                dimension.width = SwingUtils.maxWidth(container.getComponents());
            } else {
                for (Integer n : cloneable.values()) {
                    dimension.width = dimension.width + (dimension.width > 0 ? this.hgap + n : n);
                }
            }
            if (this.vfill) {
                dimension.height = SwingUtils.maxHeight(container.getComponents());
            } else {
                for (Integer n : hashMap.values()) {
                    dimension.height = dimension.height + (dimension.height > 0 ? this.vgap + n : n);
                }
            }
        } else {
            dimension = container.getComponentCount() == 1 ? container.getComponent(0).getPreferredSize() : new Dimension(0, 0);
        }
        cloneable = container.getInsets();
        dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
        dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
        return dimension;
    }

    private Dimension getSideSize(Container container, int n, int n2) {
        Dimension dimension = new Dimension(0, 0);
        for (Component component : container.getComponents()) {
            String string = this.constraints.get(component);
            if (this.getHalign(string) != n || this.getValign(string) != n2) continue;
            dimension = SwingUtils.max(dimension, component.getPreferredSize());
        }
        return dimension.width > 0 || dimension.height > 0 ? dimension : null;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        for (Component component : container.getComponents()) {
            String string = this.constraints.get(component);
            int n = this.getHalign(string);
            int n2 = this.getValign(string);
            Dimension dimension = component.getPreferredSize();
            int n3 = 0;
            if (this.hfill) {
                n3 = insets.left;
            } else {
                switch (n) {
                    case 2: {
                        n3 = insets.left;
                        break;
                    }
                    case 0: {
                        n3 = container.getWidth() / 2 - dimension.width / 2;
                        break;
                    }
                    case 4: {
                        n3 = container.getWidth() - dimension.width - insets.right;
                    }
                }
            }
            int n4 = 0;
            if (this.vfill) {
                n4 = insets.top;
            } else {
                switch (n) {
                    case 1: {
                        n4 = insets.top;
                        break;
                    }
                    case 0: {
                        n4 = container.getHeight() / 2 - dimension.height / 2;
                        break;
                    }
                    case 3: {
                        n4 = container.getHeight() - dimension.height - insets.bottom;
                    }
                }
            }
            component.setBounds(n3, n4, this.hfill ? container.getWidth() - insets.left - insets.right : dimension.width, this.vfill ? container.getHeight() - insets.top - insets.bottom : dimension.height);
        }
    }
}

