/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizontalOverflowLayout
implements LayoutManager {
    private int overflow;

    public HorizontalOverflowLayout(int n) {
        this.overflow = n;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public void setOverflow(int n) {
        this.overflow = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    private Dimension getLayoutSize(Container container, boolean bl) {
        int n = container.getComponentCount();
        Dimension dimension = new Dimension(0, 0);
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
            dimension.height = Math.max(dimension2.height, dimension.height);
            dimension.width += dimension2.width;
            if (i == 0) continue;
            dimension.width -= this.overflow;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension = this.preferredLayoutSize(container);
        Dimension dimension2 = new Dimension(dimension.width, container.getSize().height);
        boolean bl = dimension.width < dimension2.width;
        Insets insets = container.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = Math.max(dimension2.height, dimension.height) - insets.top - insets.bottom;
        int n4 = dimension2.width - dimension.width;
        int n5 = container.getComponentCount();
        for (int i = 0; i < n5; ++i) {
            int n6;
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            int n7 = n6 = bl ? component.getMinimumSize().width : component.getPreferredSize().width;
            if (n4 > 0) {
                n6 += n6 * n4 / dimension.width;
            }
            component.setBounds(n, n2, n6, n3);
            n += n6 - this.overflow;
        }
    }
}

