/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.OverlayData;
import com.alee.extended.layout.OverlayLocation;
import com.alee.extended.panel.WebOverlay;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingConstants;

public class OverlayLayout
implements LayoutManager,
SwingConstants {
    public static final String COMPONENT = "COMPONENT";
    public static final String OVERLAY = "OVERLAY";
    private Map<Component, String> constraints = new HashMap<Component, String>();
    private Insets componentMargin = null;
    private Insets overlayMargin = null;

    public Insets getComponentMargin() {
        return this.componentMargin;
    }

    public void setComponentMargin(int n) {
        this.setComponentMargin(n, n, n, n);
    }

    public void setComponentMargin(int n, int n2, int n3, int n4) {
        this.setComponentMargin(new Insets(n, n2, n3, n4));
    }

    public void setComponentMargin(Insets insets) {
        this.componentMargin = insets;
    }

    public Insets getOverlayMargin() {
        return this.overlayMargin;
    }

    public void setOverlayMargin(int n) {
        this.setOverlayMargin(n, n, n, n);
    }

    public void setOverlayMargin(int n, int n2, int n3, int n4) {
        this.setOverlayMargin(new Insets(n, n2, n3, n4));
    }

    public void setOverlayMargin(Insets insets) {
        this.overlayMargin = insets;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string == null || !string.equals(COMPONENT) && !string.equals(OVERLAY)) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be 'COMPONENT' or 'OVERLAY' string");
        }
        this.constraints.put(component, string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Insets insets2 = this.getActualComponentInsets(container);
        for (Component component : container.getComponents()) {
            Insets insets3;
            String string = this.constraints.get(component);
            if (string == null) continue;
            int n = container.getWidth();
            int n2 = container.getHeight();
            if (string.equals(COMPONENT)) {
                component.setBounds(insets.left + insets2.left, insets.top + insets2.top, n - insets.left - insets.right - insets2.left - insets2.right, n2 - insets.top - insets.bottom - insets2.top - insets2.bottom);
                continue;
            }
            if (!string.equals(OVERLAY)) continue;
            WebOverlay webOverlay = (WebOverlay)container;
            OverlayData overlayData = webOverlay.getOverlayData(component);
            Insets insets4 = insets3 = this.overlayMargin != null ? this.overlayMargin : new Insets(0, 0, 0, 0);
            if (overlayData.getLocation().equals((Object)OverlayLocation.fill)) {
                component.setBounds(insets.left + insets3.left, insets.top + insets3.top, n - insets.left - insets3.left - insets.right - insets3.right, n2 - insets.top - insets3.top - insets.bottom - insets3.bottom);
                continue;
            }
            if (overlayData.getLocation().equals((Object)OverlayLocation.align)) {
                Dimension dimension = component.getPreferredSize();
                int n3 = this.getActualHalign(component, overlayData);
                int n4 = n3 == 2 || n3 == -1 ? insets.left + insets3.left : (n3 == 4 ? n - insets.right - insets3.right - dimension.width : n / 2 - dimension.width / 2);
                int n5 = overlayData.getValign();
                int n6 = n5 == 1 || n5 == -1 ? insets.top + insets3.top : (n5 == 3 ? n2 - insets.bottom - insets3.bottom - dimension.height : n2 / 2 - dimension.height / 2);
                component.setBounds(n4, n6, n3 == -1 ? n - insets.left - insets3.left - insets.right - insets3.right : dimension.width, n5 == -1 ? n2 - insets.top - insets3.top - insets.bottom - insets3.bottom : dimension.height);
                continue;
            }
            component.setBounds(overlayData.getRectangleProvider().provide());
        }
    }

    private int getActualHalign(Component component, OverlayData overlayData) {
        boolean bl = component.getComponentOrientation().isLeftToRight();
        if (overlayData.getHalign() == 10) {
            return bl ? 2 : 4;
        }
        if (overlayData.getHalign() == 11) {
            return bl ? 4 : 2;
        }
        return overlayData.getHalign();
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Insets insets2 = this.getActualComponentInsets(container);
        Dimension dimension = new Dimension();
        for (Component component : container.getComponents()) {
            String string = this.constraints.get(component);
            if (string == null || !string.equals(COMPONENT)) continue;
            Dimension dimension2 = component.getPreferredSize();
            dimension = SwingUtils.max(dimension, new Dimension(insets.left + insets2.left + dimension2.width + insets2.right + insets.right, insets.top + insets2.top + dimension2.height + insets2.bottom + insets.bottom));
        }
        return dimension;
    }

    private Insets getActualComponentInsets(Container container) {
        return this.componentMargin != null ? (container.getComponentOrientation().isLeftToRight() ? this.componentMargin : SwingUtils.toRTL(this.componentMargin)) : new Insets(0, 0, 0, 0);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }
}

