/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.list.CheckBoxListModel;
import com.alee.extended.list.WebCheckBoxListCellEditor;
import com.alee.extended.list.WebCheckBoxListCellRenderer;
import com.alee.extended.list.WebCheckBoxListElement;
import com.alee.extended.list.WebCheckBoxListStyle;
import com.alee.laf.checkbox.WebCheckBoxStyle;
import com.alee.laf.checkbox.WebCheckBoxUI;
import com.alee.laf.list.WebList;
import com.alee.laf.list.editor.ListCellEditor;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.swing.Timer;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class WebCheckBoxList
extends WebList {
    private boolean checkOnIconOnly = WebCheckBoxListStyle.checkOnIconOnly;

    public WebCheckBoxList() {
        this(new CheckBoxListModel());
    }

    public WebCheckBoxList(CheckBoxListModel checkBoxListModel) {
        this.setModel(checkBoxListModel);
        this.setCellRenderer(new WebCheckBoxListCellRenderer());
        this.addMouseListener(new CheckBoxListMouseAdapter());
        this.addKeyListener(new CheckBoxListKeyAdapter());
    }

    public WebCheckBoxListCellRenderer getWebCheckBoxListCellRenderer() {
        return (WebCheckBoxListCellRenderer)this.getCellRenderer();
    }

    public CheckBoxListModel getCheckBoxListModel() {
        return (CheckBoxListModel)this.getModel();
    }

    @Override
    protected ListCellEditor createDefaultCellEditor() {
        return new WebCheckBoxListCellEditor();
    }

    public boolean isCheckBoxSelected(int n) {
        return this.getCheckBoxListModel().isCheckBoxSelected(n);
    }

    public void invertCheckBoxSelection(int n) {
        this.getCheckBoxListModel().invertCheckBoxSelection(n);
        this.performAnimation(n);
    }

    public void setCheckBoxSelected(int n, boolean bl) {
        if (this.getCheckBoxListModel().setCheckBoxSelected(n, bl)) {
            this.performAnimation(n);
        }
    }

    private void performAnimation(final int n) {
        if (WebCheckBoxStyle.animated) {
            final Timer timer = new Timer("WebCheckBoxList.animator", (long)WebCheckBoxUI.updateDelay);
            timer.addActionListener(new ActionListener(){
                private int left = 6;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.left > 0) {
                        WebCheckBoxList.this.repaint(WebCheckBoxList.this.getCellBounds(n, n));
                        --this.left;
                    } else {
                        timer.stop();
                    }
                }
            });
            timer.start();
        } else {
            this.repaint(this.getCellBounds(n, n));
        }
    }

    public boolean isCheckOnIconOnly() {
        return this.checkOnIconOnly;
    }

    public void setCheckOnIconOnly(boolean bl) {
        this.checkOnIconOnly = bl;
    }

    private class CheckBoxListKeyAdapter
    extends KeyAdapter {
        private CheckBoxListKeyAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (Hotkey.SPACE.isTriggered(keyEvent) && WebCheckBoxList.this.getSelectedIndex() != -1 && WebCheckBoxList.this.isEnabled()) {
                for (int n : WebCheckBoxList.this.getSelectedIndices()) {
                    WebCheckBoxList.this.invertCheckBoxSelection(n);
                }
            }
        }
    }

    private class CheckBoxListMouseAdapter
    extends MouseAdapter {
        private CheckBoxListMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = WebCheckBoxList.this.getUI().locationToIndex(WebCheckBoxList.this, mouseEvent.getPoint());
            if (n != -1 && WebCheckBoxList.this.isEnabled()) {
                if (WebCheckBoxList.this.checkOnIconOnly) {
                    WebCheckBoxListCellRenderer webCheckBoxListCellRenderer = WebCheckBoxList.this.getWebCheckBoxListCellRenderer();
                    WebCheckBoxListElement webCheckBoxListElement = webCheckBoxListCellRenderer.getElement(WebCheckBoxList.this.getCheckBoxListModel().get(n));
                    Rectangle rectangle = WebCheckBoxList.this.getWebUI().getCellBounds(WebCheckBoxList.this, n, n);
                    Rectangle rectangle2 = webCheckBoxListElement.getWebUI().getIconRect();
                    rectangle2.x += rectangle.x;
                    rectangle2.y += rectangle.y;
                    if (rectangle2.contains(mouseEvent.getPoint())) {
                        WebCheckBoxList.this.invertCheckBoxSelection(n);
                    }
                } else {
                    WebCheckBoxList.this.invertCheckBoxSelection(n);
                }
            }
        }
    }
}

