/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.DefaultPainter;
import com.alee.extended.painter.TextureType;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class TexturePainter<E extends JComponent>
extends DefaultPainter<E> {
    private TexturePaint paint = null;
    private TextureType textureType = null;

    public TexturePainter(ImageIcon imageIcon) {
        this(imageIcon.getImage());
    }

    public TexturePainter(Image image) {
        this(ImageUtils.getBufferedImage(image));
    }

    public TexturePainter(BufferedImage bufferedImage) {
        this.updatePainter(bufferedImage);
    }

    public TexturePainter(TextureType textureType) {
        this.setTextureType(textureType);
    }

    public TextureType getTextureType() {
        return this.textureType;
    }

    public void setTextureType(TextureType textureType) {
        this.textureType = textureType;
        this.updatePainter(textureType == null ? null : ImageUtils.getBufferedImage(TexturePainter.class.getResource("icons/textures/" + (Object)((Object)textureType) + ".png")));
    }

    public BufferedImage getImage() {
        return this.paint != null ? this.paint.getImage() : null;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.updatePainter(bufferedImage);
    }

    private void updatePainter(BufferedImage bufferedImage) {
        this.paint = bufferedImage != null ? new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight())) : null;
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle, E e) {
        if (this.paint != null) {
            Rectangle rectangle2 = ((JComponent)e).getVisibleRect().intersection(rectangle);
            if (rectangle2.width > 0 && rectangle2.height > 0) {
                Object object = LafUtils.setupImageQuality(graphics2D);
                graphics2D.setPaint(this.paint);
                graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                LafUtils.restoreImageQuality(graphics2D, object);
            }
        }
    }
}

