/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.laf.panel.WebPanel;
import com.alee.utils.LafUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class ResizablePanel
extends WebPanel {
    public static final int SIZER = 12;
    private int widthChange = 0;
    private int heightChange = 0;
    private int resizeCorner = -1;
    private boolean resizing = false;
    private int startX = -1;
    private int startY = -1;
    private Insets innerSpacing = new Insets(12, 12, 12, 12);

    public ResizablePanel() {
        this((Component)null);
    }

    public ResizablePanel(Component component) {
        this.setOpaque(false);
        this.updateSpacing();
        if (component != null) {
            this.setLayout(new BorderLayout());
            this.add(component, (Object)"Center");
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            private void updateResizeType(MouseEvent mouseEvent) {
                if (new Rectangle(0, 0, 12, 12).contains(mouseEvent.getPoint())) {
                    ResizablePanel.this.resizeCorner = 8;
                    ResizablePanel.this.setCursor(Cursor.getPredefinedCursor(6));
                } else if (new Rectangle(ResizablePanel.this.getWidth() / 2 - 6, 0, 12, 12).contains(mouseEvent.getPoint())) {
                    ResizablePanel.this.resizeCorner = 1;
                    ResizablePanel.this.setCursor(Cursor.getPredefinedCursor(8));
                } else if (new Rectangle(ResizablePanel.this.getWidth() - 12, 0, 12, 12).contains(mouseEvent.getPoint())) {
                    ResizablePanel.this.resizeCorner = 2;
                    ResizablePanel.this.setCursor(Cursor.getPredefinedCursor(7));
                } else if (new Rectangle(0, ResizablePanel.this.getHeight() / 2 - 6, 12, 12).contains(mouseEvent.getPoint())) {
                    ResizablePanel.this.resizeCorner = 7;
                    ResizablePanel.this.setCursor(Cursor.getPredefinedCursor(10));
                } else if (new Rectangle(ResizablePanel.this.getWidth() - 12, ResizablePanel.this.getHeight() / 2 - 6, 12, 12).contains(mouseEvent.getPoint())) {
                    ResizablePanel.this.resizeCorner = 3;
                    ResizablePanel.this.setCursor(Cursor.getPredefinedCursor(11));
                } else if (new Rectangle(0, ResizablePanel.this.getHeight() - 12, 12, 12).contains(mouseEvent.getPoint())) {
                    ResizablePanel.this.resizeCorner = 6;
                    ResizablePanel.this.setCursor(Cursor.getPredefinedCursor(4));
                } else if (new Rectangle(ResizablePanel.this.getWidth() / 2 - 6, ResizablePanel.this.getHeight() - 12, 12, 12).contains(mouseEvent.getPoint())) {
                    ResizablePanel.this.resizeCorner = 5;
                    ResizablePanel.this.setCursor(Cursor.getPredefinedCursor(9));
                } else if (new Rectangle(ResizablePanel.this.getWidth() - 12, ResizablePanel.this.getHeight() - 12, 12, 12).contains(mouseEvent.getPoint())) {
                    ResizablePanel.this.resizeCorner = 4;
                    ResizablePanel.this.setCursor(Cursor.getPredefinedCursor(5));
                } else {
                    ResizablePanel.this.resizeCorner = -1;
                    ResizablePanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.updateResizeType(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.updateResizeType(mouseEvent);
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && ResizablePanel.this.resizeCorner != -1) {
                    ResizablePanel.this.resizing = true;
                }
                ResizablePanel.this.startX = mouseEvent.getXOnScreen();
                ResizablePanel.this.startY = mouseEvent.getYOnScreen();
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (ResizablePanel.this.resizing && ResizablePanel.this.startX != -1 && ResizablePanel.this.startY != -1) {
                    ResizablePanel.this.widthChange += (ResizablePanel.this.startX - mouseEvent.getXOnScreen()) * 2 * (ResizablePanel.this.resizeCorner == 1 || ResizablePanel.this.resizeCorner == 5 ? 0 : (ResizablePanel.this.resizeCorner == 8 || ResizablePanel.this.resizeCorner == 7 || ResizablePanel.this.resizeCorner == 6 ? 1 : -1));
                    ResizablePanel.this.widthChange = Math.max(ResizablePanel.this.widthChange, 0);
                    ResizablePanel.this.heightChange += (ResizablePanel.this.startY - mouseEvent.getYOnScreen()) * 2 * (ResizablePanel.this.resizeCorner == 7 || ResizablePanel.this.resizeCorner == 3 ? 0 : (ResizablePanel.this.resizeCorner == 8 || ResizablePanel.this.resizeCorner == 1 || ResizablePanel.this.resizeCorner == 2 ? 1 : -1));
                    ResizablePanel.this.heightChange = Math.max(ResizablePanel.this.heightChange, 0);
                    ResizablePanel.this.revalidate();
                }
                ResizablePanel.this.startX = mouseEvent.getXOnScreen();
                ResizablePanel.this.startY = mouseEvent.getYOnScreen();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    ResizablePanel.this.resizing = false;
                }
                this.updateResizeType(mouseEvent);
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    private void updateSpacing() {
        this.setMargin(this.innerSpacing.top, this.innerSpacing.left, this.innerSpacing.bottom, this.innerSpacing.right);
    }

    public Insets getInnerSpacing() {
        return this.innerSpacing;
    }

    public void setInnerSpacing(int n) {
        this.setInnerSpacing(new Insets(n, n, n, n));
    }

    public void setInnerSpacing(Insets insets) {
        this.innerSpacing = insets;
        this.updateSpacing();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        LafUtils.drawWebIconedSelection((Graphics2D)graphics, new Rectangle(6, 6, this.getWidth() - 13, this.getHeight() - 13), true, true, true);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += this.widthChange;
        dimension.height += this.heightChange;
        return dimension;
    }

    public void reset() {
        this.widthChange = 0;
        this.heightChange = 0;
        this.revalidate();
    }
}

