/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.layout.AccordionLayout;
import com.alee.extended.panel.AccordionStyle;
import com.alee.extended.panel.CollapsiblePaneAdapter;
import com.alee.extended.panel.CollapsiblePaneListener;
import com.alee.extended.panel.WebAccordionStyle;
import com.alee.extended.panel.WebCollapsiblePane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.panel.WebPanelStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.DataProvider;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;

public class WebAccordion
extends WebPanel
implements SwingConstants {
    private boolean animate = WebAccordionStyle.animate;
    private AccordionStyle accordionStyle = WebAccordionStyle.accordionStyle;
    private int orientation = WebAccordionStyle.orientation;
    private ImageIcon expandIcon = WebAccordionStyle.expandIcon;
    private ImageIcon collapseIcon = WebAccordionStyle.collapseIcon;
    private boolean fillSpace = WebAccordionStyle.fillSpace;
    private boolean multiplySelectionAllowed = WebAccordionStyle.multiplySelectionAllowed;
    private int gap = WebAccordionStyle.gap;
    private AccordionLayout accordionLayout;
    private List<WebCollapsiblePane> panes = new ArrayList<WebCollapsiblePane>();
    private List<CollapsiblePaneListener> listeners = new ArrayList<CollapsiblePaneListener>();

    public WebAccordion() {
        this.initializeDefaultSettings(WebAccordionStyle.accordionStyle);
    }

    public WebAccordion(AccordionStyle accordionStyle) {
        this.initializeDefaultSettings(accordionStyle);
    }

    protected void initializeDefaultSettings(AccordionStyle accordionStyle) {
        this.setDrawFocus(true);
        this.setWebColored(false);
        this.setLayout(new AccordionLayout(this));
        this.setAccordionStyle(accordionStyle);
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean bl) {
        this.animate = bl;
        this.updatePanesAnimation();
    }

    private void updatePanesAnimation() {
        for (WebCollapsiblePane webCollapsiblePane : this.panes) {
            webCollapsiblePane.setAnimate(this.animate);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.updatePanesBorderStyling();
    }

    public ImageIcon getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(ImageIcon imageIcon) {
        this.expandIcon = imageIcon;
        this.updatePaneIcons();
    }

    public ImageIcon getCollapseIcon() {
        return this.collapseIcon;
    }

    public void setCollapseIcon(ImageIcon imageIcon) {
        this.collapseIcon = imageIcon;
        this.updatePaneIcons();
    }

    private void updatePaneIcons() {
        for (WebCollapsiblePane webCollapsiblePane : this.panes) {
            webCollapsiblePane.setExpandIcon(this.expandIcon);
            webCollapsiblePane.setCollapseIcon(this.collapseIcon);
        }
    }

    public AccordionStyle getAccordionStyle() {
        return this.accordionStyle;
    }

    public void setAccordionStyle(AccordionStyle accordionStyle) {
        this.accordionStyle = accordionStyle;
        this.updatePanesBorderStyling();
    }

    public boolean isFillSpace() {
        return this.fillSpace;
    }

    public void setFillSpace(boolean bl) {
        this.fillSpace = bl;
        this.revalidate();
    }

    public boolean isMultiplySelectionAllowed() {
        return this.multiplySelectionAllowed;
    }

    public void setMultiplySelectionAllowed(boolean bl) {
        this.multiplySelectionAllowed = bl;
        this.updateExpandState(-1);
    }

    private void updateExpandState(int n) {
        if (!this.multiplySelectionAllowed) {
            for (int i = 0; i < this.panes.size(); ++i) {
                WebCollapsiblePane webCollapsiblePane = this.panes.get(i);
                if (n == -1 && webCollapsiblePane.isExpanded()) {
                    n = i;
                }
                if (n == -1 || i == n || !webCollapsiblePane.isExpanded()) continue;
                webCollapsiblePane.setExpanded(false);
            }
        }
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        this.gap = n;
        this.revalidate();
    }

    public WebCollapsiblePane addPane(String string, Component component) {
        return this.addPane(this.panes.size(), string, component);
    }

    public WebCollapsiblePane addPane(int n, String string, Component component) {
        return this.addPane(n, new WebCollapsiblePane(string, component));
    }

    public WebCollapsiblePane addPane(Icon icon, String string, Component component) {
        return this.addPane(this.panes.size(), icon, string, component);
    }

    public WebCollapsiblePane addPane(int n, Icon icon, String string, Component component) {
        return this.addPane(n, new WebCollapsiblePane(icon, string, component));
    }

    public WebCollapsiblePane addPane(Component component, Component component2) {
        return this.addPane(this.panes.size(), component, component2);
    }

    public WebCollapsiblePane addPane(int n, Component component, Component component2) {
        WebCollapsiblePane webCollapsiblePane = new WebCollapsiblePane("", component2);
        webCollapsiblePane.setTitleComponent(component);
        return this.addPane(n, webCollapsiblePane);
    }

    private WebCollapsiblePane addPane(int n, final WebCollapsiblePane webCollapsiblePane) {
        webCollapsiblePane.setAnimate(this.animate);
        webCollapsiblePane.setExpandIcon(this.expandIcon);
        webCollapsiblePane.setCollapseIcon(this.collapseIcon);
        if (!this.multiplySelectionAllowed && this.isAnySelected()) {
            webCollapsiblePane.setExpanded(false, false);
        }
        webCollapsiblePane.setStateChangeHandler(new DataProvider<Boolean>(){

            @Override
            public Boolean provide() {
                return !WebAccordion.this.fillSpace || !webCollapsiblePane.isExpanded() || WebAccordion.this.getSelectionCount() > 1;
            }
        });
        CollapsiblePaneAdapter collapsiblePaneAdapter = new CollapsiblePaneAdapter(){

            @Override
            public void expanding(WebCollapsiblePane webCollapsiblePane) {
                WebAccordion.this.updateExpandState(WebAccordion.this.panes.indexOf(webCollapsiblePane));
            }
        };
        webCollapsiblePane.addCollapsiblePaneListener(collapsiblePaneAdapter);
        this.listeners.add(collapsiblePaneAdapter);
        this.add(n, webCollapsiblePane);
        this.panes.add(n, webCollapsiblePane);
        this.updatePanesBorderStyling();
        return webCollapsiblePane;
    }

    public void removePane(int n) {
        this.removePane(this.panes.get(n));
    }

    private void removePane(WebCollapsiblePane webCollapsiblePane) {
        int n = this.panes.indexOf(webCollapsiblePane);
        webCollapsiblePane.setStateChangeHandler(null);
        webCollapsiblePane.removeCollapsiblePaneListener(this.listeners.get(n));
        this.listeners.remove(n);
        this.remove(webCollapsiblePane);
        this.panes.remove(n);
        this.updatePanesBorderStyling();
    }

    public List<WebCollapsiblePane> getPanes() {
        return CollectionUtils.copy(this.panes);
    }

    public List<WebCollapsiblePane> getActualPanesList() {
        return this.panes;
    }

    public WebCollapsiblePane getPane(int n) {
        return this.panes.get(n);
    }

    private void updatePanesBorderStyling() {
        boolean bl = this.accordionStyle.equals((Object)AccordionStyle.united);
        boolean bl2 = this.accordionStyle.equals((Object)AccordionStyle.separated);
        boolean bl3 = this.orientation == 0;
        this.setUndecorated(!bl);
        for (int i = 0; i < this.panes.size(); ++i) {
            WebCollapsiblePane webCollapsiblePane = this.panes.get(i);
            webCollapsiblePane.setTitlePanePostion(bl3 ? 2 : 1);
            if (bl2) {
                webCollapsiblePane.setShadeWidth(WebPanelStyle.shadeWidth);
                webCollapsiblePane.setDrawSides(bl2, bl2, bl2, bl2);
                continue;
            }
            webCollapsiblePane.setShadeWidth(0);
            webCollapsiblePane.setDrawSides(!bl3 && i > 0, bl3 && i > 0, false, false);
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isAnySelected() {
        for (WebCollapsiblePane webCollapsiblePane : this.panes) {
            if (!webCollapsiblePane.isExpanded()) continue;
            return true;
        }
        return false;
    }

    public int getFirstSelectedIndex() {
        for (WebCollapsiblePane webCollapsiblePane : this.panes) {
            if (!webCollapsiblePane.isExpanded()) continue;
            return this.panes.indexOf(webCollapsiblePane);
        }
        return -1;
    }

    public int getSelectionCount() {
        int n = 0;
        for (WebCollapsiblePane webCollapsiblePane : this.panes) {
            if (!webCollapsiblePane.isExpanded()) continue;
            ++n;
        }
        return n;
    }

    public Icon getIconAt(int n) {
        return this.panes.get(n).getIcon();
    }

    public void setIconAt(int n, Icon icon) {
        this.panes.get(n).setIcon(icon);
    }

    public String getTitleAt(int n) {
        return this.panes.get(n).getTitle();
    }

    public void setTitleAt(int n, String string) {
        this.panes.get(n).setTitle(string);
    }

    public Component getTitleComponentAt(int n) {
        return this.panes.get(n).getTitleComponent();
    }

    public void setTitleComponentAt(int n, Component component) {
        this.panes.get(n).setTitleComponent(component);
    }

    public Component getContentAt(int n) {
        return this.panes.get(n).getContent();
    }

    public void setContentAt(int n, Component component) {
        this.panes.get(n).setContent(component);
    }

    public Insets getContentMarginAt(int n) {
        return this.panes.get(n).getContentMargin();
    }

    public void setContentMarginAt(int n, Insets insets) {
        this.panes.get(n).setContentMargin(insets);
    }

    public void setContentMarginAt(int n, int n2, int n3, int n4, int n5) {
        this.setContentMarginAt(n, new Insets(n2, n3, n4, n5));
    }

    public void setContentMarginAt(int n, int n2) {
        this.setContentMarginAt(n, n2, n2, n2, n2);
    }
}

