/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.statusbar;

import com.alee.extended.statusbar.WebStatusLabel;
import com.alee.utils.SwingUtils;
import java.awt.AWTEvent;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class WebCursorTracker
extends WebStatusLabel {
    public static final ImageIcon CURSOR_ICON = new ImageIcon(WebCursorTracker.class.getResource("icons/cursor.png"));
    private AWTEventListener listener = null;

    public WebCursorTracker() {
        this.setIcon(CURSOR_ICON);
        this.listener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    if (aWTEvent.getID() == 504) {
                        Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
                        WebCursorTracker.this.updatePosition(mouseEvent);
                    } else if (aWTEvent.getID() == 505) {
                        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                        Toolkit.getDefaultToolkit().addAWTEventListener(WebCursorTracker.this.listener, 16L);
                        WebCursorTracker.this.updatePosition(mouseEvent);
                    } else if (aWTEvent.getID() == 503 || aWTEvent.getID() == 506) {
                        WebCursorTracker.this.updatePosition(mouseEvent);
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 16L);
    }

    private void updatePosition(final MouseEvent mouseEvent) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (mouseEvent != null && mouseEvent.getComponent() != null && SwingUtils.getWindowAncestor(mouseEvent.getComponent()) != null) {
                    Point point = SwingUtils.getWindowAncestor(mouseEvent.getComponent()).getLocation();
                    Point point2 = MouseInfo.getPointerInfo().getLocation();
                    WebCursorTracker.this.setText("x:" + (point2.x - point.x) + " y:" + (point2.y - point.y));
                } else {
                    WebCursorTracker.this.setText("Outside of area");
                }
            }
        });
    }
}

