/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.progressbar.WebProgressBar;
import com.alee.laf.rootpane.WebDialog;
import com.alee.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;

public class WebProgressDialog
extends WebDialog {
    private int preferredWidth = 0;
    private boolean shownOnce = false;
    private WebPanel container;
    private WebLabel titleText;
    private Component middleComponent = null;
    private WebProgressBar progressBar;

    public WebProgressDialog(String string) {
        this((Window)null, string);
    }

    public WebProgressDialog(Window window, String string) {
        super(window, string);
        this.setLayout(new BorderLayout());
        this.container = new WebPanel(new BorderLayout(5, 5));
        this.container.setMargin(10, 10, 10, 10);
        this.container.setOpaque(false);
        this.add((Component)this.container, "Center");
        this.titleText = new WebLabel(" ", 0){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 0;
                return dimension;
            }
        };
        this.titleText.setDrawShade(true);
        this.container.add((Component)this.titleText, (Object)"North");
        this.progressBar = new WebProgressBar(0, 0, 100){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (WebProgressDialog.this.preferredWidth > 0) {
                    dimension.width = WebProgressDialog.this.preferredWidth;
                }
                return dimension;
            }
        };
        this.progressBar.setStringPainted(true);
        this.container.add((Component)this.progressBar, (Object)"South");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setModal(false);
        this.updateBounds();
        this.setLocationRelativeTo(window);
    }

    public void setText(final String string) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.titleText.setText(string);
            }
        });
    }

    public String getText() {
        return this.titleText.getText();
    }

    public void setProgressText(final String string) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setString(string);
            }
        });
    }

    public String getProgressText() {
        return this.progressBar.getString();
    }

    public void setShowProgressText(final boolean bl) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setStringPainted(bl);
                WebProgressDialog.this.updateBounds();
            }
        });
    }

    public boolean isShowProgressText() {
        return this.progressBar.isStringPainted();
    }

    public void setIndeterminate(final boolean bl) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setIndeterminate(bl);
            }
        });
    }

    public boolean isIndeterminate() {
        return this.progressBar.isIndeterminate();
    }

    public void setMinimum(final int n) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setMinimum(n);
            }
        });
    }

    public int getMinimum() {
        return this.progressBar.getMinimum();
    }

    public void setMaximum(final int n) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setMaximum(n);
            }
        });
    }

    public int getMaximum() {
        return this.progressBar.getMaximum();
    }

    public void setProgress(final int n) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setValue(n);
            }
        });
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
        this.updateBounds();
    }

    public int getProgress() {
        return this.progressBar.getValue();
    }

    public WebLabel getTitleLabel() {
        return this.titleText;
    }

    public Component getMiddleComponent() {
        return this.middleComponent;
    }

    public void setMiddleComponent(Component component) {
        if (this.middleComponent != null) {
            this.container.remove(component);
        }
        this.middleComponent = component;
        this.container.add(component, (Object)"Center");
        this.container.revalidate();
        this.updateBounds();
    }

    public WebProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setShowProgressBar(boolean bl) {
        if (bl) {
            if (this.progressBar.getParent() != this.container) {
                this.container.add((Component)this.progressBar, (Object)"South");
                this.container.revalidate();
                this.updateBounds();
            }
        } else if (this.progressBar.getParent() == this.container) {
            this.container.remove(this.progressBar);
            this.container.revalidate();
            this.updateBounds();
        }
    }

    private void updateBounds() {
        this.pack();
        if (!this.shownOnce) {
            this.setLocationRelativeTo(this.getOwner());
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.shownOnce = true;
        }
        super.setVisible(bl);
    }
}

