/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class WindowResizeAdapter
extends MouseAdapter
implements SwingConstants {
    private boolean resizing = false;
    private int prevX = -1;
    private int prevY = -1;
    private int resizeSide = 0;

    public static void install(Component component, int n) {
        WindowResizeAdapter windowResizeAdapter = new WindowResizeAdapter(n);
        component.addMouseListener(windowResizeAdapter);
        component.addMouseMotionListener(windowResizeAdapter);
    }

    public WindowResizeAdapter(int n) {
        this.resizeSide = n;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.resizing = true;
        }
        this.prevX = mouseEvent.getXOnScreen();
        this.prevY = mouseEvent.getYOnScreen();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.prevX != -1 && this.prevY != -1 && this.resizing) {
            boolean bl;
            Dimension dimension;
            Window window = SwingUtils.getWindowAncestor(mouseEvent.getComponent());
            Rectangle rectangle = window.getBounds();
            if (window instanceof JDialog) {
                dimension = ((JDialog)window).getRootPane().getMinimumSize();
                bl = ((JDialog)window).isUndecorated();
            } else if (window instanceof JFrame) {
                dimension = ((JFrame)window).getRootPane().getMinimumSize();
                bl = ((JFrame)window).isUndecorated();
            } else if (window instanceof JWindow) {
                dimension = ((JWindow)window).getRootPane().getMinimumSize();
                bl = ((JFrame)window).isUndecorated();
            } else {
                dimension = window.getMinimumSize();
                bl = true;
            }
            int n = mouseEvent.getXOnScreen() - this.prevX;
            int n2 = mouseEvent.getYOnScreen() - this.prevY;
            if (bl) {
                if (this.resizeSide == 8 || this.resizeSide == 7 || this.resizeSide == 6) {
                    if (rectangle.width - n < dimension.width) {
                        n = 0;
                    }
                } else if ((this.resizeSide == 2 || this.resizeSide == 3 || this.resizeSide == 4) && rectangle.width + n < dimension.width) {
                    n = 0;
                }
                if (this.resizeSide == 8 || this.resizeSide == 1 || this.resizeSide == 2) {
                    if (rectangle.height - n2 < dimension.height) {
                        n2 = 0;
                    }
                } else if ((this.resizeSide == 6 || this.resizeSide == 5 || this.resizeSide == 4) && rectangle.height + n2 < dimension.height) {
                    n2 = 0;
                }
            }
            if (n != 0 || n2 != 0) {
                if (this.resizeSide == 8) {
                    window.setBounds(rectangle.x + n, rectangle.y + n2, rectangle.width - n, rectangle.height - n2);
                } else if (this.resizeSide == 1) {
                    window.setBounds(rectangle.x, rectangle.y + n2, rectangle.width, rectangle.height - n2);
                } else if (this.resizeSide == 2) {
                    window.setBounds(rectangle.x, rectangle.y + n2, rectangle.width + n, rectangle.height - n2);
                } else if (this.resizeSide == 7) {
                    window.setBounds(rectangle.x + n, rectangle.y, rectangle.width - n, rectangle.height);
                } else if (this.resizeSide == 3) {
                    window.setBounds(rectangle.x, rectangle.y, rectangle.width + n, rectangle.height);
                } else if (this.resizeSide == 6) {
                    window.setBounds(rectangle.x + n, rectangle.y, rectangle.width - n, rectangle.height + n2);
                } else if (this.resizeSide == 5) {
                    window.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height + n2);
                } else if (this.resizeSide == 4) {
                    window.setBounds(rectangle.x, rectangle.y, rectangle.width + n, rectangle.height + n2);
                }
                this.prevX = mouseEvent.getXOnScreen();
                this.prevY = mouseEvent.getYOnScreen();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.resizing = false;
    }
}

