/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.extended.painter.DefaultPainter;
import com.alee.laf.StyleConstants;
import com.alee.laf.combobox.WebComboBoxElement;
import com.alee.utils.LafUtils;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;

public class WebComboBoxElementPainter
extends DefaultPainter<WebComboBoxElement> {
    @Override
    public Insets getMargin(WebComboBoxElement webComboBoxElement) {
        return webComboBoxElement.getIndex() != -1 ? new Insets(webComboBoxElement.getIndex() == 0 ? 2 : 3, 2, webComboBoxElement.getIndex() + 1 == webComboBoxElement.getTotalElements() ? 2 : 3, 2) : new Insets(2, 2, 2, 2);
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle, WebComboBoxElement webComboBoxElement) {
        if (webComboBoxElement.getIndex() == -1) {
            this.paintBoxBackground(graphics2D, webComboBoxElement);
        } else if (webComboBoxElement.isSelected()) {
            this.paintSelectedBackground(graphics2D, webComboBoxElement);
        } else {
            this.paintDeselectedBackground(graphics2D, webComboBoxElement);
        }
    }

    protected void paintBoxBackground(Graphics2D graphics2D, WebComboBoxElement webComboBoxElement) {
    }

    protected void paintSelectedBackground(Graphics2D graphics2D, WebComboBoxElement webComboBoxElement) {
        graphics2D.setPaint(LafUtils.getWebGradientPaint(0, 0, 0, webComboBoxElement.getHeight()));
        graphics2D.fillRect(0, 0, webComboBoxElement.getWidth(), webComboBoxElement.getHeight());
        graphics2D.setPaint(webComboBoxElement.isEnabled() ? StyleConstants.darkBorderColor : StyleConstants.disabledBorderColor);
        if (webComboBoxElement.getIndex() != 0) {
            graphics2D.drawLine(0, 0, webComboBoxElement.getWidth() - 1, 0);
        }
        if (webComboBoxElement.getIndex() < webComboBoxElement.getTotalElements() - 1) {
            graphics2D.drawLine(0, webComboBoxElement.getHeight() - 1, webComboBoxElement.getWidth() - 1, webComboBoxElement.getHeight() - 1);
        }
    }

    protected void paintDeselectedBackground(Graphics2D graphics2D, WebComboBoxElement webComboBoxElement) {
    }
}

