/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.laf.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.menu.MenuItemLayoutHelper;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.FocusType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class WebMenuUI
extends BasicMenuUI {
    private static final Point iconLocation = new Point(6, 5);
    private boolean mouseover = false;
    private MouseAdapter mouseAdapter = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebMenuUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.menuItem);
        this.menuItem.setOpaque(false);
        this.menuItem.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        this.menuItem.setBackground(StyleConstants.menuSelectionColor);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WebMenuUI.this.mouseover = true;
                WebMenuUI.this.menuItem.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WebMenuUI.this.mouseover = false;
                WebMenuUI.this.menuItem.repaint();
            }
        };
        this.menuItem.addMouseListener(this.mouseAdapter);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.menuItem.removeMouseListener(this.mouseAdapter);
        super.uninstallUI(jComponent);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        MenuItemLayoutHelper menuItemLayoutHelper = new MenuItemLayoutHelper(jMenuItem, icon, icon2, MenuItemLayoutHelper.createMaxRect(), n, this.getAccelerationDelimeter(), jMenuItem.getComponentOrientation().isLeftToRight(), jMenuItem.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        Dimension dimension = new Dimension();
        dimension.width = menuItemLayoutHelper.getLeadingGap();
        MenuItemLayoutHelper.addMaxWidth(menuItemLayoutHelper.getCheckSize(), menuItemLayoutHelper.getAfterCheckIconGap(), dimension);
        if (!menuItemLayoutHelper.isTopLevelMenu() && menuItemLayoutHelper.getMinTextOffset() > 0 && dimension.width < menuItemLayoutHelper.getMinTextOffset()) {
            dimension.width = menuItemLayoutHelper.getMinTextOffset();
        }
        MenuItemLayoutHelper.addMaxWidth(menuItemLayoutHelper.getLabelSize(), menuItemLayoutHelper.getGap(), dimension);
        MenuItemLayoutHelper.addMaxWidth(menuItemLayoutHelper.getAccSize(), menuItemLayoutHelper.getGap(), dimension);
        MenuItemLayoutHelper.addMaxWidth(menuItemLayoutHelper.getArrowSize(), menuItemLayoutHelper.getGap(), dimension);
        dimension.height = MenuItemLayoutHelper.max(menuItemLayoutHelper.getCheckSize().getHeight(), menuItemLayoutHelper.getLabelSize().getHeight(), menuItemLayoutHelper.getAccSize().getHeight(), menuItemLayoutHelper.getArrowSize().getHeight());
        Insets insets = menuItemLayoutHelper.getMenuItem().getInsets();
        if (insets != null) {
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    @Override
    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        Font font = graphics.getFont();
        Color color3 = graphics.getColor();
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        graphics.setFont(jMenuItem.getFont());
        Rectangle rectangle = new Rectangle(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        this.applyInsets(rectangle, jMenuItem.getInsets());
        MenuItemLayoutHelper menuItemLayoutHelper = new MenuItemLayoutHelper(jMenuItem, icon, icon2, rectangle, n, this.getAccelerationDelimeter(), jMenuItem.getComponentOrientation().isLeftToRight(), jMenuItem.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        MenuItemLayoutHelper.LayoutResult layoutResult = menuItemLayoutHelper.layoutMenuItem();
        this.paintBackground(graphics, jMenuItem, menuItemLayoutHelper);
        this.paintCheckIcon(graphics, menuItemLayoutHelper);
        this.paintIcon(graphics, menuItemLayoutHelper);
        this.paintArrowIcon(graphics, menuItemLayoutHelper, layoutResult);
        Map map = SwingUtils.setupTextAntialias(graphics, (Component)jComponent);
        this.paintText(graphics, menuItemLayoutHelper, layoutResult);
        this.paintAccText(graphics, menuItemLayoutHelper, layoutResult);
        SwingUtils.restoreTextAntialias(graphics, map);
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, MenuItemLayoutHelper menuItemLayoutHelper) {
        if (jMenuItem.isEnabled()) {
            ButtonModel buttonModel = jMenuItem.getModel();
            if (this.mouseover || buttonModel.isArmed() || buttonModel.isSelected()) {
                boolean bl = menuItemLayoutHelper.getMenuItemParent() instanceof JPopupMenu;
                int n = bl ? 0 : StyleConstants.shadeWidth;
                LafUtils.drawWebStyle((Graphics2D)graphics, (JComponent)jMenuItem, StyleConstants.shadeColor, n, StyleConstants.smallRound, jMenuItem.isEnabled(), !buttonModel.isSelected() || bl, buttonModel.isSelected() ? StyleConstants.averageBorderColor : StyleConstants.borderColor);
                if (jMenuItem.isEnabled() && bl) {
                    LafUtils.drawWebFocus((Graphics2D)graphics, jMenuItem, FocusType.fieldFocus, n, StyleConstants.smallRound, null, true, StyleConstants.darkBorderColor);
                }
            }
        }
    }

    protected void applyInsets(Rectangle rectangle, Insets insets) {
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.right + rectangle.x;
            rectangle.height -= insets.bottom + rectangle.y;
        }
    }

    protected String getAccelerationDelimeter() {
        String string = UIManager.getString("MenuItem.acceleratorDelimiter");
        return string != null ? string : "+";
    }

    protected void paintIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper) {
        if (menuItemLayoutHelper.getIcon() != null) {
            Icon icon;
            ButtonModel buttonModel = menuItemLayoutHelper.getMenuItem().getModel();
            if (!buttonModel.isEnabled()) {
                icon = menuItemLayoutHelper.getMenuItem().getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = menuItemLayoutHelper.getMenuItem().getPressedIcon();
                if (icon == null) {
                    icon = menuItemLayoutHelper.getMenuItem().getIcon();
                }
            } else {
                icon = menuItemLayoutHelper.getMenuItem().getIcon();
            }
            if (icon != null) {
                icon.paintIcon(menuItemLayoutHelper.getMenuItem(), graphics, WebMenuUI.iconLocation.x, WebMenuUI.iconLocation.y);
            }
        }
    }

    protected void paintCheckIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper) {
        if (menuItemLayoutHelper.useCheckAndArrow() && menuItemLayoutHelper.getCheckIcon() != null) {
            menuItemLayoutHelper.getCheckIcon().paintIcon(menuItemLayoutHelper.getMenuItem(), graphics, WebMenuUI.iconLocation.x, WebMenuUI.iconLocation.y);
        }
    }

    protected void paintArrowIcon(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (menuItemLayoutHelper.useCheckAndArrow() && menuItemLayoutHelper.getArrowIcon() != null) {
            menuItemLayoutHelper.getArrowIcon().paintIcon(menuItemLayoutHelper.getMenuItem(), graphics, layoutResult.getArrowRect().x, layoutResult.getArrowRect().y);
        }
    }

    protected void paintText(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (!menuItemLayoutHelper.getText().equals("")) {
            Rectangle rectangle = layoutResult.getTextRect();
            Font font = this.menuItem.getFont();
            FontRenderContext fontRenderContext = this.menuItem.getFontMetrics(font).getFontRenderContext();
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, this.menuItem.getText());
            Rectangle rectangle2 = glyphVector.getVisualBounds().getBounds();
            rectangle.y = this.menuItem.getHeight() / 2 - rectangle2.height / 2;
            rectangle.height = rectangle2.height;
            if (menuItemLayoutHelper.getMenuItemParent() instanceof JPopupMenu) {
                rectangle.x -= menuItemLayoutHelper.getMenuItem().getIconTextGap() * 2 - 1;
            }
            if (menuItemLayoutHelper.getHtmlView() != null) {
                menuItemLayoutHelper.getHtmlView().paint(graphics, rectangle);
            } else {
                this.paintText(graphics, menuItemLayoutHelper.getMenuItem(), rectangle, menuItemLayoutHelper.getText());
            }
        }
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        int n;
        int n2 = n = WebLookAndFeel.isMnemonicHidden() ? -1 : jMenuItem.getDisplayedMnemonicIndex();
        if (!jMenuItem.isEnabled()) {
            graphics.setColor(UIManager.getColor("MenuItem.disabledForeground"));
        } else {
            graphics.setColor(jMenuItem.getForeground());
        }
        SwingUtils.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + rectangle.height);
    }

    protected void paintAccText(Graphics graphics, MenuItemLayoutHelper menuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (!menuItemLayoutHelper.getAccText().equals("")) {
            ButtonModel buttonModel = menuItemLayoutHelper.getMenuItem().getModel();
            graphics.setFont(menuItemLayoutHelper.getAccFontMetrics().getFont());
            graphics.setColor(buttonModel.isEnabled() ? StyleConstants.infoTextColor : StyleConstants.disabledInfoTextColor);
            Rectangle rectangle = layoutResult.getAccRect();
            rectangle.x = menuItemLayoutHelper.getMenuItem().getWidth() - 7 - menuItemLayoutHelper.getAccFontMetrics().stringWidth(menuItemLayoutHelper.getAccText());
            SwingUtils.drawString(menuItemLayoutHelper.getMenuItem(), graphics, menuItemLayoutHelper.getAccText(), rectangle.x, menuItemLayoutHelper.getMenuItem().getHeight() / 2 + menuItemLayoutHelper.getAccFontMetrics().getAscent() / 2 - 1);
        }
    }
}

