/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.panel;

import com.alee.extended.painter.Painter;
import com.alee.laf.StyleConstants;
import com.alee.laf.panel.WebPanelStyle;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class WebPanelUI
extends BasicPanelUI
implements ShapeProvider,
FocusTracker {
    private boolean undecorated = WebPanelStyle.undecorated;
    private boolean drawFocus = WebPanelStyle.drawFocus;
    private int round = WebPanelStyle.round;
    private int shadeWidth = WebPanelStyle.shadeWidth;
    private Insets margin = WebPanelStyle.margin;
    private boolean drawBackground = WebPanelStyle.drawBackground;
    private boolean webColored = WebPanelStyle.webColored;
    private Painter painter = WebPanelStyle.painter;
    private ShapeProvider clipProvider = WebPanelStyle.clipProvider;
    private boolean drawTop = WebPanelStyle.drawTop;
    private boolean drawLeft = WebPanelStyle.drawLeft;
    private boolean drawBottom = WebPanelStyle.drawBottom;
    private boolean drawRight = WebPanelStyle.drawRight;
    private JPanel panel = null;
    private PropertyChangeListener propertyChangeListener;
    private boolean focused = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebPanelUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.panel = (JPanel)jComponent;
        SwingUtils.setOrientation(this.panel);
        this.panel.setOpaque(true);
        this.panel.setBackground(WebPanelStyle.backgroundColor);
        this.updateBorder();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebPanelUI.this.updateBorder();
            }
        };
        this.panel.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
        FocusManager.registerFocusTracker(this);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.panel.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        FocusManager.unregisterFocusTracker(this);
        super.uninstallUI(jComponent);
    }

    @Override
    public Shape provideShape() {
        if (this.painter != null || this.undecorated) {
            return SwingUtils.size(this.panel);
        }
        return this.getPanelShape(this.panel, true);
    }

    @Override
    public boolean isTrackingEnabled() {
        return !this.undecorated && this.drawFocus;
    }

    @Override
    public Component getTrackedComponent() {
        return this.panel;
    }

    @Override
    public boolean isUniteWithChilds() {
        return true;
    }

    @Override
    public boolean isListenGlobalChange() {
        return false;
    }

    @Override
    public void focusChanged(boolean bl) {
        this.focused = bl;
        this.panel.repaint();
    }

    private void updateBorder() {
        if (this.panel != null) {
            boolean bl = this.panel.getComponentOrientation().isLeftToRight();
            Insets insets = new Insets(this.margin.top, bl ? this.margin.left : this.margin.right, this.margin.bottom, bl ? this.margin.right : this.margin.left);
            if (this.painter != null) {
                Insets insets2 = this.painter.getMargin(this.panel);
                insets.top += insets2.top;
                insets.bottom += insets2.bottom;
                insets.left = insets.left + (bl ? insets2.left : insets2.right);
                insets.right = insets.right + (bl ? insets2.right : insets2.left);
            } else if (!this.undecorated) {
                boolean bl2 = bl ? this.drawLeft : this.drawRight;
                boolean bl3 = bl ? this.drawRight : this.drawLeft;
                insets.top = insets.top + (this.drawTop ? this.shadeWidth + 1 : 0);
                insets.left = insets.left + (bl2 ? this.shadeWidth + 1 : 0);
                insets.bottom = insets.bottom + (this.drawBottom ? this.shadeWidth + 1 : 0);
                insets.right = insets.right + (bl3 ? this.shadeWidth + 1 : 0);
            }
            this.panel.setBorder(LafUtils.createWebBorder(insets));
        }
    }

    private void updateOpacity() {
        if (this.painter != null) {
            this.panel.setOpaque(this.painter.isOpaque(this.panel));
        }
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean bl) {
        this.undecorated = bl;
        this.updateBorder();
        if (this.painter == null && !bl) {
            this.panel.setOpaque(false);
        }
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean bl) {
        this.drawFocus = bl;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
        this.updateBorder();
        this.updateOpacity();
    }

    public ShapeProvider getClipProvider() {
        return this.clipProvider;
    }

    public void setClipProvider(ShapeProvider shapeProvider) {
        this.clipProvider = shapeProvider;
    }

    public int getRound() {
        if (this.undecorated) {
            return 0;
        }
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public int getShadeWidth() {
        if (this.undecorated) {
            return 0;
        }
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateBorder();
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean bl) {
        this.drawBackground = bl;
    }

    public boolean isWebColored() {
        return this.webColored;
    }

    public void setWebColored(boolean bl) {
        this.webColored = bl;
    }

    public boolean isDrawBottom() {
        return this.drawBottom;
    }

    public void setDrawBottom(boolean bl) {
        this.drawBottom = bl;
        this.updateBorder();
    }

    public boolean isDrawLeft() {
        return this.drawLeft;
    }

    public void setDrawLeft(boolean bl) {
        this.drawLeft = bl;
        this.updateBorder();
    }

    public boolean isDrawRight() {
        return this.drawRight;
    }

    public void setDrawRight(boolean bl) {
        this.drawRight = bl;
        this.updateBorder();
    }

    public boolean isDrawTop() {
        return this.drawTop;
    }

    public void setDrawTop(boolean bl) {
        this.drawTop = bl;
        this.updateBorder();
    }

    public void setDrawSides(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.drawTop = bl;
        this.drawLeft = bl2;
        this.drawBottom = bl3;
        this.drawRight = bl4;
        this.updateBorder();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        LafUtils.setupSystemTextHints(graphics);
        Shape shape = this.clipProvider != null ? this.clipProvider.provideShape() : null;
        Shape shape2 = null;
        if (shape != null) {
            shape2 = LafUtils.intersectClip((Graphics2D)graphics, shape);
        }
        if (this.painter != null) {
            this.painter.paint((Graphics2D)graphics, SwingUtils.size(jComponent), jComponent);
        } else if (!this.undecorated) {
            boolean bl;
            boolean bl2 = bl = this.drawTop || this.drawRight || this.drawBottom || this.drawLeft;
            if (bl || this.drawBackground) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Object object = LafUtils.setupAntialias(graphics2D);
                Shape shape3 = this.getPanelShape(jComponent, false);
                if (bl && jComponent.isEnabled()) {
                    LafUtils.drawShade(graphics2D, shape3, this.drawFocus && this.focused ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth);
                }
                if (this.drawBackground) {
                    Shape shape4 = this.getPanelShape(jComponent, true);
                    if (this.webColored) {
                        Rectangle rectangle = shape4.getBounds();
                        graphics2D.setPaint(LafUtils.getWebGradientPaint(0, rectangle.y, 0, rectangle.y + rectangle.height));
                    } else {
                        graphics2D.setPaint(jComponent.getBackground());
                    }
                    graphics2D.fill(shape4);
                }
                if (bl) {
                    graphics2D.setPaint(jComponent.isEnabled() ? StyleConstants.darkBorderColor : StyleConstants.disabledBorderColor);
                    graphics2D.draw(shape3);
                }
                LafUtils.restoreAntialias(graphics2D, object);
            }
        }
        if (shape != null) {
            LafUtils.restoreClip(graphics, shape2);
        }
    }

    private Shape getPanelShape(JComponent jComponent, boolean bl) {
        boolean bl2 = jComponent.getComponentOrientation().isLeftToRight();
        boolean bl3 = bl2 ? this.drawLeft : this.drawRight;
        boolean bl4 = bl2 ? this.drawRight : this.drawLeft;
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        if (bl) {
            Point[] pointArray = new Point[4];
            boolean[] blArray = new boolean[4];
            pointArray[0] = this.p(bl3 ? this.shadeWidth : 0, this.drawTop ? this.shadeWidth : 0);
            blArray[0] = bl3 && this.drawTop;
            pointArray[1] = this.p(bl4 ? n - this.shadeWidth : n, this.drawTop ? this.shadeWidth : 0);
            blArray[1] = bl4 && this.drawTop;
            pointArray[2] = this.p(bl4 ? n - this.shadeWidth : n, this.drawBottom ? n2 - this.shadeWidth : n2);
            blArray[2] = bl4 && this.drawBottom;
            pointArray[3] = this.p(bl3 ? this.shadeWidth : 0, this.drawBottom ? n2 - this.shadeWidth : n2);
            blArray[3] = bl3 && this.drawBottom;
            return LafUtils.createRoundedShape(this.round > 0 ? this.round + 1 : 0, pointArray, blArray);
        }
        GeneralPath generalPath = new GeneralPath(0);
        boolean bl5 = false;
        boolean bl6 = false;
        if (this.drawTop) {
            generalPath.moveTo(bl3 ? (float)(this.shadeWidth + this.round) : 0.0f, this.shadeWidth);
            if (bl4) {
                generalPath.lineTo(n - this.shadeWidth - this.round - 1, this.shadeWidth);
                generalPath.quadTo(n - this.shadeWidth - 1, this.shadeWidth, n - this.shadeWidth - 1, this.shadeWidth + this.round);
            } else {
                generalPath.lineTo(n - 1, this.shadeWidth);
            }
            bl5 = true;
        }
        if (bl4) {
            if (!bl5) {
                generalPath.moveTo(n - this.shadeWidth - 1, this.drawTop ? (float)(this.shadeWidth + this.round) : 0.0f);
                bl6 = true;
            }
            if (this.drawBottom) {
                generalPath.lineTo(n - this.shadeWidth - 1, n2 - this.shadeWidth - this.round - 1);
                generalPath.quadTo(n - this.shadeWidth - 1, n2 - this.shadeWidth - 1, n - this.shadeWidth - this.round - 1, n2 - this.shadeWidth - 1);
            } else {
                generalPath.lineTo(n - this.shadeWidth - 1, n2 - 1);
            }
            bl5 = true;
        } else {
            bl5 = false;
        }
        if (this.drawBottom) {
            if (!bl5) {
                generalPath.moveTo(bl4 ? (float)(n - this.shadeWidth - this.round - 1) : (float)(n - 1), n2 - this.shadeWidth - 1);
                bl6 = true;
            }
            if (bl3) {
                generalPath.lineTo(this.shadeWidth + this.round, n2 - this.shadeWidth - 1);
                generalPath.quadTo(this.shadeWidth, n2 - this.shadeWidth - 1, this.shadeWidth, n2 - this.shadeWidth - this.round - 1);
            } else {
                generalPath.lineTo(0.0f, n2 - this.shadeWidth - 1);
            }
            bl5 = true;
        } else {
            bl5 = false;
        }
        if (bl3) {
            if (!bl5) {
                generalPath.moveTo(this.shadeWidth, this.drawBottom ? (float)(n2 - this.shadeWidth - this.round - 1) : (float)(n2 - 1));
                bl6 = true;
            }
            if (this.drawTop) {
                generalPath.lineTo(this.shadeWidth, this.shadeWidth + this.round);
                generalPath.quadTo(this.shadeWidth, this.shadeWidth, this.shadeWidth + this.round, this.shadeWidth);
                if (!bl6) {
                    generalPath.closePath();
                }
            } else {
                generalPath.lineTo(this.shadeWidth, 0.0f);
            }
        }
        return generalPath;
    }

    private Point p(int n, int n2) {
        return new Point(n, n2);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }
}

