/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.extended.panel.WebButtonGroup;
import com.alee.extended.window.ComponentMoveAdapter;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebResizeCorner;
import com.alee.laf.rootpane.WebRootPaneLayout;
import com.alee.laf.rootpane.WebRootPaneStyle;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class WebRootPaneUI
extends BasicRootPaneUI
implements SwingConstants {
    public static ImageIcon minimizeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/minimize.png"));
    public static ImageIcon minimizeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/minimize_active.png"));
    public static ImageIcon maximizeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/maximize.png"));
    public static ImageIcon maximizeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/maximize_active.png"));
    public static ImageIcon restoreIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/restore.png"));
    public static ImageIcon restoreActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/restore_active.png"));
    public static ImageIcon closeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/close.png"));
    public static ImageIcon closeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/close_active.png"));
    private Color topBg = WebRootPaneStyle.topBg;
    private Color middleBg = WebRootPaneStyle.middleBg;
    private Color borderColor = WebRootPaneStyle.borderColor;
    private Color innerBorderColor = WebRootPaneStyle.innerBorderColor;
    private int shadeWidth = WebRootPaneStyle.shadeWidth;
    private int inactiveShadeWidth = WebRootPaneStyle.inactiveShadeWidth;
    private int round = WebRootPaneStyle.round;
    private Insets margin = WebRootPaneStyle.margin;
    private boolean drawWatermark = WebRootPaneStyle.drawWatermark;
    private ImageIcon watermark = WebRootPaneStyle.watermark;
    private boolean showTitleComponent = WebRootPaneStyle.showTitleComponent;
    private boolean showMenuBar = WebRootPaneStyle.showMenuBar;
    private boolean showWindowButtons = WebRootPaneStyle.showWindowButtons;
    private boolean showMinimizeButton = WebRootPaneStyle.showMinimizeButton;
    private boolean showMaximizeButton = WebRootPaneStyle.showMaximizeButton;
    private boolean showCloseButton = WebRootPaneStyle.showCloseButton;
    private boolean groupButtons = WebRootPaneStyle.groupButtons;
    private boolean attachButtons = WebRootPaneStyle.attachButtons;
    private boolean showResizeCorner = WebRootPaneStyle.showResizeCorner;
    private boolean styled = false;
    private JRootPane root;
    private Window window;
    private Frame frame;
    private Dialog dialog;
    private int state;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private WindowFocusListener windowFocusListener;
    private PropertyChangeListener titleChangeListener;
    private WindowStateListener windowStateListener;
    private JComponent titleComponent;
    private WebButtonGroup windowButtons;
    private WebResizeCorner resizeCorner;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebRootPaneUI();
    }

    public Color getTopBg() {
        return this.topBg;
    }

    public void setTopBg(Color color) {
        this.topBg = color;
        this.root.repaint();
    }

    public Color getMiddleBg() {
        return this.middleBg;
    }

    public void setMiddleBg(Color color) {
        this.middleBg = color;
        this.root.repaint();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.root.repaint();
    }

    public Color getInnerBorderColor() {
        return this.innerBorderColor;
    }

    public void setInnerBorderColor(Color color) {
        this.innerBorderColor = color;
        this.root.repaint();
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        int n2 = n - this.shadeWidth;
        this.shadeWidth = n;
        if (this.styled && this.window != null) {
            Rectangle rectangle = this.window.getBounds();
            this.window.setBounds(rectangle.x - n2, rectangle.y - n2, rectangle.width + n2 * 2, rectangle.height + n2 * 2);
            this.installBorder();
            this.root.revalidate();
            this.root.repaint();
        }
    }

    public int getInactiveShadeWidth() {
        return this.inactiveShadeWidth;
    }

    public void setInactiveShadeWidth(int n) {
        this.inactiveShadeWidth = n;
        if (this.styled) {
            this.installBorder();
            this.root.revalidate();
            this.root.repaint();
        }
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
        if (this.styled) {
            this.updateWindowButtonsStyle();
            this.root.revalidate();
            this.root.repaint();
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        if (this.styled) {
            this.installBorder();
            this.root.revalidate();
            this.root.repaint();
        }
    }

    public boolean isDrawWatermark() {
        return this.drawWatermark;
    }

    public void setDrawWatermark(boolean bl) {
        this.drawWatermark = bl;
        if (this.styled) {
            this.root.repaint();
        }
    }

    public ImageIcon getWatermark() {
        if (this.watermark == null && this.drawWatermark) {
            this.watermark = new ImageIcon(WebRootPaneUI.class.getResource("icons/watermark.png"));
        }
        return this.watermark;
    }

    public void setWatermark(ImageIcon imageIcon) {
        this.watermark = imageIcon;
    }

    public JComponent getTitleComponent() {
        return this.titleComponent;
    }

    public void setTitleComponent(JComponent jComponent) {
        this.titleComponent = jComponent;
        this.root.revalidate();
    }

    public WebButtonGroup getWindowButtons() {
        return this.windowButtons;
    }

    public WebResizeCorner getResizeCorner() {
        return this.resizeCorner;
    }

    public boolean isShowResizeCorner() {
        return this.showResizeCorner;
    }

    public void setShowResizeCorner(boolean bl) {
        this.showResizeCorner = bl;
        this.root.revalidate();
    }

    public boolean isShowTitleComponent() {
        return this.showTitleComponent;
    }

    public void setShowTitleComponent(boolean bl) {
        this.showTitleComponent = bl;
        this.root.revalidate();
    }

    public boolean isShowWindowButtons() {
        return this.showWindowButtons;
    }

    public void setShowWindowButtons(boolean bl) {
        this.showWindowButtons = bl;
        this.root.revalidate();
    }

    public boolean isShowMinimizeButton() {
        return this.showMinimizeButton;
    }

    public void setShowMinimizeButton(boolean bl) {
        this.showMinimizeButton = bl;
        this.updateButtons();
        this.root.revalidate();
    }

    public boolean isShowMaximizeButton() {
        return this.showMaximizeButton;
    }

    public void setShowMaximizeButton(boolean bl) {
        this.showMaximizeButton = bl;
        this.updateButtons();
        this.root.revalidate();
    }

    public boolean isShowCloseButton() {
        return this.showCloseButton;
    }

    public void setShowCloseButton(boolean bl) {
        this.showCloseButton = bl;
        this.updateButtons();
        this.root.revalidate();
    }

    public boolean isGroupButtons() {
        return this.groupButtons;
    }

    public void setGroupButtons(boolean bl) {
        this.groupButtons = bl;
        this.updateButtons();
        this.root.revalidate();
        this.root.repaint();
    }

    public boolean isAttachButtons() {
        return this.attachButtons;
    }

    public void setAttachButtons(boolean bl) {
        this.attachButtons = bl;
        this.updateButtons();
        this.root.revalidate();
        this.root.repaint();
    }

    public boolean isShowMenuBar() {
        return this.showMenuBar;
    }

    public void setShowMenuBar(boolean bl) {
        this.showMenuBar = bl;
        this.root.revalidate();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.root = (JRootPane)jComponent;
        SwingUtils.setOrientation(this.root);
        this.root.setBackground(StyleConstants.backgroundColor);
        this.installWindowDecorations();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallWindowDecorations();
        this.layoutManager = null;
        this.root = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string.equals("windowDecorationStyle")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            int n = jRootPane.getWindowDecorationStyle();
            this.uninstallWindowDecorations();
            if (n != 0) {
                this.installWindowDecorations();
            }
        }
    }

    private void installWindowDecorations() {
        if (this.root.getWindowDecorationStyle() != 0) {
            this.window = this.root != null ? SwingUtils.getWindowAncestor(this.root) : null;
            this.frame = this.window instanceof Frame ? (Frame)this.window : null;
            this.dialog = this.window instanceof Dialog ? (Dialog)this.window : null;
            this.installProperties();
            this.installListeners();
            this.installTransparency();
            this.installBorder();
            this.installLayout();
            this.installDecorationComponents();
            this.installSystemSpecificSettings();
            this.styled = true;
        }
    }

    private void uninstallWindowDecorations() {
        if (this.styled) {
            this.uninstallProperties();
            this.uninstallListeners();
            this.uninstallTransparency();
            this.uninstallBorder();
            this.uninstallLayout();
            this.uninstallDecorationComponents();
            this.uninstallSystemSpecificSettings();
            this.window = null;
            this.frame = null;
            this.dialog = null;
            this.styled = false;
        }
    }

    protected void installProperties() {
        if (this.isFrame()) {
            this.frame.setMaximizedBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        }
    }

    protected void uninstallProperties() {
        if (this.isFrame()) {
            this.frame.setMaximizedBounds(null);
        }
    }

    protected void installListeners() {
        this.windowFocusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                WebRootPaneUI.this.root.repaint();
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                WebRootPaneUI.this.root.repaint();
            }
        };
        this.window.addWindowFocusListener(this.windowFocusListener);
        this.titleChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebRootPaneUI.this.titleComponent.revalidate();
                WebRootPaneUI.this.titleComponent.repaint();
            }
        };
        this.window.addPropertyChangeListener("title", this.titleChangeListener);
        if (this.isFrame()) {
            this.state = this.frame.getState();
            this.windowStateListener = new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent windowEvent) {
                    WebRootPaneUI.this.state = windowEvent.getNewState();
                    WebRootPaneUI.this.installBorder();
                }
            };
            this.window.addWindowStateListener(this.windowStateListener);
        }
    }

    protected void uninstallListeners() {
        this.window.removeWindowFocusListener(this.windowFocusListener);
        this.window.removePropertyChangeListener(this.titleChangeListener);
    }

    protected void installTransparency() {
        if (SwingUtils.isWindowTransparencyAllowed()) {
            this.root.setOpaque(false);
            SwingUtils.setWindowOpaque(this.window, false);
        }
    }

    protected void uninstallTransparency() {
        if (SwingUtils.isWindowTransparencyAllowed()) {
            this.root.setOpaque(true);
            SwingUtils.setWindowOpaque(this.window, true);
        }
    }

    protected void installBorder() {
        if (!this.isFrameMaximized()) {
            this.root.setBorder(BorderFactory.createEmptyBorder(this.shadeWidth + 1 + this.margin.top, this.shadeWidth + 1 + this.margin.left, this.shadeWidth + 1 + this.margin.bottom, this.shadeWidth + 1 + this.margin.right));
        } else {
            this.root.setBorder(BorderFactory.createEmptyBorder(1 + this.margin.top, 1 + this.margin.left, 1 + this.margin.bottom, 1 + this.margin.right));
        }
    }

    protected void uninstallBorder() {
        this.root.setBorder(null);
    }

    protected void installLayout() {
        if (this.layoutManager == null) {
            this.layoutManager = new WebRootPaneLayout();
        }
        this.savedOldLayout = this.root.getLayout();
        this.root.setLayout(this.layoutManager);
    }

    protected void uninstallLayout() {
        if (this.savedOldLayout != null) {
            this.root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    protected void installDecorationComponents() {
        this.titleComponent = this.createDefaultTitleComponent();
        this.root.add(this.titleComponent);
        this.updateButtons();
        this.resizeCorner = new WebResizeCorner();
        this.root.add(this.resizeCorner);
    }

    protected JComponent createDefaultTitleComponent() {
        WebLabel webLabel = new WebLabel(){

            @Override
            public Icon getIcon() {
                return WebRootPaneUI.this.getWindowIcon();
            }
        };
        final TitleLabel titleLabel = new TitleLabel();
        titleLabel.setDrawShade(true);
        titleLabel.setHorizontalAlignment(0);
        titleLabel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                titleLabel.setHorizontalAlignment(titleLabel.getRequiredSize().width > titleLabel.getWidth() ? 10 : 0);
            }
        });
        SwingUtils.setFontSize(titleLabel, 13);
        ComponentMoveAdapter componentMoveAdapter = new ComponentMoveAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (WebRootPaneUI.this.isFrame() && SwingUtils.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    if (WebRootPaneUI.this.isFrameMaximized()) {
                        WebRootPaneUI.this.restore();
                    } else {
                        WebRootPaneUI.this.maximize();
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.dragging && WebRootPaneUI.this.isFrameMaximized()) {
                    this.initialPoint = new Point(this.initialPoint.x + WebRootPaneUI.this.shadeWidth, this.initialPoint.y + WebRootPaneUI.this.shadeWidth);
                    WebRootPaneUI.this.restore();
                }
                super.mouseDragged(mouseEvent);
            }
        };
        titleLabel.addMouseListener(componentMoveAdapter);
        titleLabel.addMouseMotionListener(componentMoveAdapter);
        WebPanel webPanel = new WebPanel(new BorderLayout(5, 0));
        webPanel.setOpaque(false);
        webPanel.setMargin(4, 5, 4, 10);
        webPanel.add((Component)webLabel, (Object)"Before");
        webPanel.add((Component)titleLabel, (Object)"Center");
        return webPanel;
    }

    protected void updateButtons() {
        WebButton webButton;
        if (this.windowButtons != null) {
            this.root.remove(this.windowButtons);
        }
        boolean bl = this.isFrame();
        JComponent[] jComponentArray = new JComponent[3];
        if (this.showMinimizeButton && bl) {
            webButton = new WebButton(minimizeIcon);
            webButton.setName("minimize");
            webButton.setRolloverIcon(minimizeActiveIcon);
            webButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebRootPaneUI.this.iconify();
                }
            });
            jComponentArray[0] = webButton;
        }
        if (this.showMaximizeButton && this.isResizable() && bl) {
            webButton = new WebButton((Icon)maximizeIcon){

                @Override
                public Icon getIcon() {
                    return WebRootPaneUI.this.isFrameMaximized() ? restoreIcon : maximizeIcon;
                }

                @Override
                public Icon getRolloverIcon() {
                    return WebRootPaneUI.this.isFrameMaximized() ? restoreActiveIcon : maximizeActiveIcon;
                }
            };
            webButton.setName("maximize");
            webButton.setRolloverIcon(maximizeActiveIcon);
            webButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (WebRootPaneUI.this.isFrame()) {
                        if (WebRootPaneUI.this.isFrameMaximized()) {
                            WebRootPaneUI.this.restore();
                        } else {
                            WebRootPaneUI.this.maximize();
                        }
                    }
                }
            });
            jComponentArray[1] = webButton;
        }
        if (this.showCloseButton) {
            webButton = new WebButton(closeIcon);
            webButton.setName("close");
            webButton.setRolloverIcon(closeActiveIcon);
            webButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebRootPaneUI.this.close();
                }
            });
            jComponentArray[2] = webButton;
        }
        this.windowButtons = new WebButtonGroup(jComponentArray){

            @Override
            public void updateButtons() {
                if (WebRootPaneUI.this.groupButtons) {
                    super.updateButtons();
                }
            }
        };
        this.updateWindowButtonsStyle();
        this.root.add(this.windowButtons);
    }

    protected void updateWindowButtonsStyle() {
        if (this.windowButtons != null) {
            this.windowButtons.setButtonsDrawFocus(false);
            this.windowButtons.setButtonsShadeWidth(WebRootPaneStyle.buttonsShadeWidth);
            this.windowButtons.setButtonsRound(this.round);
            this.windowButtons.setButtonsMargin(WebRootPaneStyle.buttonsMargin);
            if (this.attachButtons) {
                this.windowButtons.setButtonsDrawTop(false);
                this.windowButtons.setButtonsDrawRight(this.round > 0);
            }
        }
    }

    protected void uninstallDecorationComponents() {
        if (this.titleComponent != null) {
            this.root.remove(this.titleComponent);
            this.titleComponent = null;
        }
        if (this.resizeCorner != null) {
            this.root.remove(this.resizeCorner);
            this.resizeCorner = null;
        }
    }

    private void installSystemSpecificSettings() {
    }

    private void uninstallSystemSpecificSettings() {
    }

    protected String getWindowTitle() {
        if (this.isDialog()) {
            return this.dialog.getTitle();
        }
        if (this.isFrame()) {
            return this.frame.getTitle();
        }
        return null;
    }

    protected ImageIcon getWindowIcon() {
        List<Image> list;
        List<Image> list2 = list = this.window != null ? this.window.getIconImages() : null;
        if (list != null && list.size() > 1) {
            int n = 0;
            int n2 = Math.abs(list.get(n).getWidth(null) - 16);
            for (int i = 1; i < list.size() && n2 != 0; ++i) {
                int n3 = Math.abs(list.get(i).getWidth(null) - 16);
                if (n3 >= n2) continue;
                n = i;
                n2 = n3;
            }
            return this.generateProperIcon(list.get(n));
        }
        if (list != null && list.size() == 1) {
            return this.generateProperIcon(list.get(0));
        }
        return new ImageIcon();
    }

    private ImageIcon generateProperIcon(Image image) {
        if (image.getWidth(null) <= 16) {
            return new ImageIcon(image);
        }
        return ImageUtils.createPreviewIcon(image, 16);
    }

    protected void close() {
        if (this.window != null) {
            this.window.dispatchEvent(new WindowEvent(this.window, 201));
        }
    }

    protected void iconify() {
        if (this.frame != null) {
            this.frame.setExtendedState(1);
        }
    }

    protected void maximize() {
        if (this.frame != null) {
            this.frame.setExtendedState(6);
        }
    }

    protected void restore() {
        if (this.frame != null) {
            this.frame.setExtendedState(0);
        }
    }

    protected boolean isResizable() {
        if (this.isDialog()) {
            return this.dialog.isResizable();
        }
        if (this.isFrame()) {
            return this.frame.isResizable();
        }
        return false;
    }

    protected boolean isFrame() {
        return this.frame != null;
    }

    protected boolean isFrameMaximized() {
        return this.isFrame() && this.state == 6;
    }

    protected boolean isDialog() {
        return this.dialog != null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.styled) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = LafUtils.setupAntialias(graphics2D);
            boolean bl = this.isFrameMaximized();
            if (bl) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.topBg, 0.0f, 30.0f, this.middleBg));
                graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                graphics2D.setPaint(this.borderColor);
                graphics2D.drawRect(0, 0, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
                graphics2D.setPaint(this.innerBorderColor);
                graphics2D.drawRect(1, 1, jComponent.getWidth() - 3, jComponent.getHeight() - 3);
                if (this.drawWatermark) {
                    Shape shape = LafUtils.intersectClip(graphics2D, this.getWatermarkClip(jComponent));
                    graphics2D.drawImage(this.getWatermark().getImage(), 2, 2, null);
                    LafUtils.restoreClip(graphics2D, shape);
                }
            } else {
                if (this.shadeWidth > 0) {
                    int n = this.isActive(jComponent) ? 0 : this.shadeWidth - this.inactiveShadeWidth;
                    this.getShadeIcon(jComponent).paintIcon(graphics2D, n, n, jComponent.getWidth() - n * 2, jComponent.getHeight() - n * 2);
                }
                graphics2D.setPaint(new GradientPaint(0.0f, this.shadeWidth, this.topBg, 0.0f, this.shadeWidth + 30, this.middleBg));
                graphics2D.fillRoundRect(this.shadeWidth, this.shadeWidth, jComponent.getWidth() - this.shadeWidth * 2, jComponent.getHeight() - this.shadeWidth * 2, this.round * 2, this.round * 2);
                graphics2D.setPaint(this.borderColor);
                graphics2D.drawRoundRect(this.shadeWidth, this.shadeWidth, jComponent.getWidth() - this.shadeWidth * 2 - 1, jComponent.getHeight() - this.shadeWidth * 2 - 1, this.round * 2 - 2, this.round * 2 - 2);
                graphics2D.setPaint(this.innerBorderColor);
                graphics2D.drawRoundRect(this.shadeWidth + 1, this.shadeWidth + 1, jComponent.getWidth() - this.shadeWidth * 2 - 3, jComponent.getHeight() - this.shadeWidth * 2 - 3, this.round * 2 - 4, this.round * 2 - 4);
                if (this.drawWatermark) {
                    Shape shape = LafUtils.intersectClip(graphics2D, this.getWatermarkClip(jComponent));
                    graphics2D.drawImage(this.getWatermark().getImage(), this.shadeWidth + 2, this.shadeWidth + 2, null);
                    LafUtils.restoreClip(graphics2D, shape);
                }
            }
            LafUtils.restoreAntialias(graphics2D, object);
        }
    }

    private RoundRectangle2D.Double getWatermarkClip(JComponent jComponent) {
        return new RoundRectangle2D.Double(this.shadeWidth + 2, this.shadeWidth + 2, jComponent.getWidth() - this.shadeWidth * 2 - 3, jComponent.getHeight() - this.shadeWidth * 2 - 3, this.round * 2 - 4, this.round * 2 - 4);
    }

    protected NinePatchIcon getShadeIcon(JComponent jComponent) {
        if (this.shadeWidth > 0) {
            return NinePatchUtils.getShadeIcon(this.getShadeWidth(jComponent), this.round, 0.8f);
        }
        return null;
    }

    private int getShadeWidth(JComponent jComponent) {
        return this.isActive(jComponent) ? this.shadeWidth : this.inactiveShadeWidth;
    }

    private boolean isActive(JComponent jComponent) {
        return SwingUtils.getWindowAncestor(jComponent).isFocused();
    }

    private class TitleLabel
    extends WebLabel {
        private TitleLabel() {
        }

        @Override
        public String getText() {
            return WebRootPaneUI.this.getWindowTitle();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = Math.min(dimension.width, 100);
            return dimension;
        }

        public Dimension getRequiredSize() {
            return super.getPreferredSize();
        }
    }
}

