/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.laf.scroll.WebScrollBarStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WebScrollBarUI
extends BasicScrollBarUI {
    public static final int LENGTH = 13;
    private Color scrollBg = WebScrollBarStyle.scrollBg;
    private Color scrollBorder = WebScrollBarStyle.scrollBorder;
    private Color scrollBarBorder = WebScrollBarStyle.scrollBarBorder;
    private Color scrollGradientLeft = WebScrollBarStyle.scrollGradientLeft;
    private Color scrollGradientRight = WebScrollBarStyle.scrollGradientRight;
    private Color scrollSelGradientLeft = WebScrollBarStyle.scrollSelGradientLeft;
    private Color scrollSelGradientRight = WebScrollBarStyle.scrollSelGradientRight;
    private int round = WebScrollBarStyle.rounding;
    private boolean drawBorder = WebScrollBarStyle.drawBorder;
    private MouseAdapter mouseAdapter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebScrollBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.scrollbar);
        this.scrollbar.setUnitIncrement(4);
        this.scrollbar.setUnitIncrement(16);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                WebScrollBarUI.this.scrollbar.repaint();
            }
        };
        this.scrollbar.addMouseListener(this.mouseAdapter);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.scrollbar.removeMouseListener(this.mouseAdapter);
        super.uninstallUI(jComponent);
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
        this.scrollbar.setOpaque(bl);
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public Color getScrollBg() {
        return this.scrollBg;
    }

    public void setScrollBg(Color color) {
        this.scrollBg = color;
    }

    public Color getScrollBorder() {
        return this.scrollBorder;
    }

    public void setScrollBorder(Color color) {
        this.scrollBorder = color;
    }

    public Color getScrollBarBorder() {
        return this.scrollBarBorder;
    }

    public void setScrollBarBorder(Color color) {
        this.scrollBarBorder = color;
    }

    public Color getScrollGradientLeft() {
        return this.scrollGradientLeft;
    }

    public void setScrollGradientLeft(Color color) {
        this.scrollGradientLeft = color;
    }

    public Color getScrollGradientRight() {
        return this.scrollGradientRight;
    }

    public void setScrollGradientRight(Color color) {
        this.scrollGradientRight = color;
    }

    public Color getScrollSelGradientLeft() {
        return this.scrollSelGradientLeft;
    }

    public void setScrollSelGradientLeft(Color color) {
        this.scrollSelGradientLeft = color;
    }

    public Color getScrollSelGradientRight() {
        return this.scrollSelGradientRight;
    }

    public void setScrollSelGradientRight(Color color) {
        this.scrollSelGradientRight = color;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Object object = LafUtils.disableAntialias(graphics);
        super.paint(graphics, jComponent);
        LafUtils.restoreAntialias(graphics, object);
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (this.drawBorder) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.scrollBg);
            graphics2D.fillRect(0, 0, this.scrollbar.getWidth(), this.scrollbar.getHeight());
            if (this.scrollbar.getOrientation() == 1) {
                int n = this.scrollbar.getComponentOrientation().isLeftToRight() ? 0 : this.scrollbar.getWidth() - 1;
                graphics2D.setColor(this.scrollBorder);
                graphics2D.drawLine(n, 0, n, this.scrollbar.getHeight() - 1);
            } else {
                graphics2D.setColor(this.scrollBorder);
                graphics2D.drawLine(0, 0, this.scrollbar.getWidth(), 0);
            }
        }
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        Color color;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color2 = this.isDragging ? this.scrollSelGradientLeft : this.scrollGradientLeft;
        Color color3 = color = this.isDragging ? this.scrollSelGradientRight : this.scrollGradientRight;
        if (this.scrollbar.getOrientation() == 1) {
            boolean bl = this.scrollbar.getComponentOrientation().isLeftToRight();
            Color color4 = bl ? color2 : color;
            Color color5 = bl ? color : color2;
            int n = bl ? 2 : 1;
            graphics2D.setPaint(new GradientPaint(3.0f, 0.0f, color4, this.scrollbar.getWidth() - 4, 0.0f, color5));
            graphics2D.fillRoundRect(this.thumbRect.x + n, this.thumbRect.y + 1, this.thumbRect.width - 4, this.thumbRect.height - 3, this.round, this.round);
            graphics2D.setPaint(this.scrollBarBorder);
            graphics2D.drawRoundRect(this.thumbRect.x + n, this.thumbRect.y + 1, this.thumbRect.width - 4, this.thumbRect.height - 3, this.round, this.round);
        } else {
            graphics2D.setPaint(new GradientPaint(0.0f, this.thumbRect.y + 2, color2, 0.0f, this.thumbRect.y + 2 + this.thumbRect.height - 4, color));
            graphics2D.fillRoundRect(this.thumbRect.x + 1, this.thumbRect.y + 2, this.thumbRect.width - 3, this.thumbRect.height - 4, this.round, this.round);
            graphics2D.setPaint(this.scrollBarBorder);
            graphics2D.drawRoundRect(this.thumbRect.x + 1, this.thumbRect.y + 2, this.thumbRect.width - 3, this.thumbRect.height - 4, this.round, this.round);
        }
    }

    @Override
    protected void installComponents() {
        this.incrButton = new JButton();
        this.incrButton.setPreferredSize(new Dimension(0, 0));
        this.decrButton = new JButton();
        this.decrButton.setPreferredSize(new Dimension(0, 0));
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        return this.scrollbar.getOrientation() == 1 ? new Dimension(13, dimension.height) : new Dimension(dimension.width, 13);
    }
}

