/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.scroll.WebScrollBar;
import com.alee.laf.scroll.WebScrollBarStyle;
import com.alee.laf.scroll.WebScrollPaneUI;
import com.alee.utils.ReflectUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JScrollPane;

public class WebScrollPane
extends JScrollPane
implements ShapeProvider {
    private int preferredWidth = -1;
    private int minimumWidth = -1;
    private int preferredHeight = -1;
    private int minimumHeight = -1;

    public WebScrollPane(Component component) {
        this(component, true);
    }

    public WebScrollPane(Component component, boolean bl) {
        this(component, bl, WebScrollBarStyle.drawBorder);
    }

    public WebScrollPane(Component component, boolean bl, boolean bl2) {
        super(component);
        this.setDrawBorder(bl);
        this.getWebHorizontalScrollBar().setDrawBorder(bl2);
        this.getWebVerticalScrollBar().setDrawBorder(bl2);
        if (!bl2) {
            this.setCorner("LOWER_RIGHT_CORNER", null);
        }
    }

    @Override
    public WebScrollBar createVerticalScrollBar() {
        return new WebScrollBar(1);
    }

    @Override
    public WebScrollBar createHorizontalScrollBar() {
        return new WebScrollBar(0);
    }

    public WebScrollBar getWebVerticalScrollBar() {
        return (WebScrollBar)super.getVerticalScrollBar();
    }

    public WebScrollBar getWebHorizontalScrollBar() {
        return (WebScrollBar)super.getHorizontalScrollBar();
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int n) {
        this.minimumWidth = n;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredHeight(int n) {
        this.preferredHeight = n;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(int n) {
        this.minimumHeight = n;
    }

    public boolean isDrawBorder() {
        return this.getWebUI().isDrawBorder();
    }

    public void setDrawBorder(boolean bl) {
        this.getWebUI().setDrawBorder(bl);
    }

    public int getRound() {
        return this.getWebUI().getRound();
    }

    public void setRound(int n) {
        this.getWebUI().setRound(n);
    }

    public int getShadeWidth() {
        return this.getWebUI().getShadeWidth();
    }

    public void setShadeWidth(int n) {
        this.getWebUI().setShadeWidth(n);
    }

    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(Insets insets) {
        this.getWebUI().setMargin(insets);
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.setMargin(new Insets(n, n2, n3, n4));
    }

    public void setMargin(int n) {
        this.setMargin(n, n, n, n);
    }

    public boolean isDrawFocus() {
        return this.getWebUI().isDrawFocus();
    }

    public void setDrawFocus(boolean bl) {
        this.getWebUI().setDrawFocus(bl);
    }

    public boolean isDrawBackground() {
        return this.getWebUI().isDrawBackground();
    }

    public void setDrawBackground(boolean bl) {
        this.getWebUI().setDrawBackground(bl);
    }

    public Color getBorderColor() {
        return this.getWebUI().getBorderColor();
    }

    public void setBorderColor(Color color) {
        this.getWebUI().setBorderColor(color);
    }

    public Color getDarkBorder() {
        return this.getWebUI().getDarkBorder();
    }

    public void setDarkBorder(Color color) {
        this.getWebUI().setDarkBorder(color);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    public WebScrollPaneUI getWebUI() {
        return (WebScrollPaneUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebScrollPaneUI)) {
            try {
                this.setUI((WebScrollPaneUI)ReflectUtils.createInstance(WebLookAndFeel.scrollPaneUI, new Object[0]));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setUI(new WebScrollPaneUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.preferredWidth != -1) {
            dimension.width = this.preferredWidth;
        } else if (this.minimumWidth != -1) {
            dimension.width = Math.max(this.minimumWidth, dimension.width);
        }
        if (this.preferredHeight != -1) {
            dimension.height = this.preferredHeight;
        } else if (this.minimumHeight != -1) {
            dimension.height = Math.max(this.minimumHeight, dimension.height);
        }
        return dimension;
    }
}

