/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tooltip;

import com.alee.laf.tooltip.WebTooltipStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class WebToolTipUI
extends BasicToolTipUI
implements ShapeProvider {
    private JComponent tooltip = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebToolTipUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.tooltip = jComponent;
        SwingUtils.setOrientation(this.tooltip);
        this.tooltip.setOpaque(false);
        this.tooltip.setBackground(WebTooltipStyle.backgroundColor);
        this.tooltip.setForeground(WebTooltipStyle.textColor);
        this.updateBorder(this.tooltip);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.tooltip = null;
        super.uninstallUI(jComponent);
    }

    @Override
    public Shape provideShape() {
        return new RoundRectangle2D.Double(0.0, 0.0, this.tooltip.getWidth(), this.tooltip.getHeight(), WebTooltipStyle.round * 2, WebTooltipStyle.round * 2);
    }

    private void updateBorder(JComponent jComponent) {
        jComponent.setBorder(LafUtils.createWebBorder(WebTooltipStyle.contentMargin));
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        Composite composite = LafUtils.setupAlphaComposite(graphics2D, WebTooltipStyle.trasparency);
        graphics2D.setPaint(jComponent.getBackground());
        graphics2D.fillRoundRect(0, 0, jComponent.getWidth(), jComponent.getHeight(), WebTooltipStyle.round * 2, WebTooltipStyle.round * 2);
        LafUtils.restoreComposite(graphics2D, composite);
        LafUtils.restoreAntialias(graphics2D, object);
        super.paint(graphics, jComponent);
    }
}

