/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.StyleConstants;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.laf.tree.WebTreeCellEditor;
import com.alee.laf.tree.WebTreeCellRenderer;
import com.alee.laf.tree.WebTreeStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WebTreeUI
extends BasicTreeUI {
    public static ImageIcon EXPAND_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/expand.png"));
    public static ImageIcon COLLAPSE_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/collapse.png"));
    public static ImageIcon DISABLED_EXPAND_ICON = ImageUtils.createDisabledCopy(EXPAND_ICON);
    public static ImageIcon DISABLED_COLLAPSE_ICON = ImageUtils.createDisabledCopy(COLLAPSE_ICON);
    public static ImageIcon ROOT_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/root.png"));
    public static ImageIcon CLOSED_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/closed.png"));
    public static ImageIcon OPEN_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/open.png"));
    public static ImageIcon LEAF_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/leaf.png"));
    public static ImageIcon DISABLED_ROOT_ICON = ImageUtils.createDisabledCopy(ROOT_ICON);
    public static ImageIcon DISABLED_CLOSED_ICON = ImageUtils.createDisabledCopy(CLOSED_ICON);
    public static ImageIcon DISABLED_OPEN_ICON = ImageUtils.createDisabledCopy(OPEN_ICON);
    public static ImageIcon DISABLED_LEAF_ICON = ImageUtils.createDisabledCopy(LEAF_ICON);
    private boolean highlightRolloverNode = WebTreeStyle.highlightRolloverNode;
    private boolean paintLines = WebTreeStyle.paintLines;
    private Color linesColor = WebTreeStyle.linesColor;
    private TreeSelectionStyle selectionStyle = WebTreeStyle.selectionStyle;
    private int selectionRound = WebTreeStyle.selectionRound;
    private int selectionShadeWidth = WebTreeStyle.selectionShadeWidth;
    private boolean selectorEnabled = WebTreeStyle.selectorEnabled;
    private Color selectorColor = WebTreeStyle.selectorColor;
    private Color selectorBorderColor = WebTreeStyle.selectorBorderColor;
    private int selectorRound = WebTreeStyle.selectorRound;
    private BasicStroke selectorStroke = WebTreeStyle.selectorStroke;
    private PropertyChangeListener propertyChangeListener;
    private TreeSelectionListener treeSelectionListener;
    private TreeExpansionListener treeExpansionListener;
    private MouseAdapter mouseAdapter;
    private int rolloverRow = -1;
    private List<Integer> initialSelection = new ArrayList<Integer>();
    private List<Integer> lastSelection = null;
    private Point selectionStart = null;
    private Point selectionPrevEnd = null;
    private Point selectionEnd = null;
    private boolean ltr = true;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebTreeUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.ltr = this.tree.getComponentOrientation().isLeftToRight();
        SwingUtils.setOrientation(this.tree);
        this.tree.setRowHeight(-1);
        this.tree.setVisibleRowCount(10);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebTreeUI.this.ltr = WebTreeUI.this.tree.getComponentOrientation().isLeftToRight();
            }
        };
        this.tree.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                WebTreeUI.this.repaintSelection();
            }
        };
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.treeExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                WebTreeUI.this.repaintSelection();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                WebTreeUI.this.repaintSelection();
            }
        };
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && WebTreeUI.this.getRowForPoint(mouseEvent.getPoint(), false) == -1) {
                    TreePath treePath;
                    if (WebTreeUI.this.isSelectorAvailable()) {
                        TreePath treePath2 = WebTreeUI.this.getClosestPathForLocation(WebTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY());
                        if (!WebTreeUI.this.isLocationInExpandControl(treePath2, mouseEvent.getX(), mouseEvent.getY())) {
                            WebTreeUI.this.selectionStart = mouseEvent.getPoint();
                            WebTreeUI.this.selectionPrevEnd = WebTreeUI.this.selectionStart;
                            WebTreeUI.this.selectionEnd = WebTreeUI.this.selectionStart;
                            WebTreeUI.this.initialSelection = this.getSelectionRowsList();
                            this.validateSelection(mouseEvent);
                            this.repaintSelector();
                        }
                    } else if (WebTreeUI.this.isFullLineSelection() && !WebTreeUI.this.isLocationInExpandControl(treePath = WebTreeUI.this.getClosestPathForLocation(WebTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getX(), mouseEvent.getY()) && WebTreeUI.this.tree.getSelectionModel().getSelectionMode() == 1) {
                        WebTreeUI.this.tree.setSelectionRow(WebTreeUI.this.getRowForPoint(mouseEvent.getPoint(), true));
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (WebTreeUI.this.isSelectorAvailable() && WebTreeUI.this.selectionStart != null) {
                    WebTreeUI.this.selectionPrevEnd = WebTreeUI.this.selectionEnd;
                    WebTreeUI.this.selectionEnd = mouseEvent.getPoint();
                    this.validateSelection(mouseEvent);
                    this.repaintSelector();
                    if (!WebTreeUI.this.tree.getVisibleRect().contains(mouseEvent.getPoint())) {
                        WebTreeUI.this.tree.scrollRectToVisible(new Rectangle(mouseEvent.getPoint(), new Dimension(0, 0)));
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (WebTreeUI.this.isSelectorAvailable() && WebTreeUI.this.selectionStart != null) {
                    Rectangle rectangle = GeometryUtils.getContainingRect(WebTreeUI.this.selectionStart, WebTreeUI.this.selectionEnd);
                    WebTreeUI.this.selectionStart = null;
                    WebTreeUI.this.selectionPrevEnd = null;
                    WebTreeUI.this.selectionEnd = null;
                    this.repaintSelector(rectangle);
                }
            }

            private void validateSelection(MouseEvent mouseEvent) {
                Rectangle rectangle = GeometryUtils.getContainingRect(WebTreeUI.this.selectionStart, WebTreeUI.this.selectionEnd);
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                if (SwingUtils.isShift(mouseEvent)) {
                    for (int i = 0; i < WebTreeUI.this.tree.getRowCount(); ++i) {
                        if (!WebTreeUI.this.getRowBounds(i).intersects(rectangle) || WebTreeUI.this.initialSelection.contains(i)) continue;
                        arrayList.add(i);
                    }
                    Iterator iterator = WebTreeUI.this.initialSelection.iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        arrayList.add(n);
                    }
                } else if (SwingUtils.isCtrl(mouseEvent)) {
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    for (int i = 0; i < WebTreeUI.this.tree.getRowCount(); ++i) {
                        if (!WebTreeUI.this.getRowBounds(i).intersects(rectangle)) continue;
                        if (WebTreeUI.this.initialSelection.contains(i)) {
                            arrayList2.add(i);
                            continue;
                        }
                        arrayList.add(i);
                    }
                    Iterator iterator = WebTreeUI.this.initialSelection.iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        if (arrayList2.contains(n)) continue;
                        arrayList.add(n);
                    }
                } else {
                    for (int i = 0; i < WebTreeUI.this.tree.getRowCount(); ++i) {
                        if (!WebTreeUI.this.getRowBounds(i).intersects(rectangle)) continue;
                        arrayList.add(i);
                    }
                }
                if (!CollectionUtils.areEqual(this.getSelectionRowsList(), arrayList)) {
                    if (arrayList.size() > 0) {
                        WebTreeUI.this.tree.setSelectionRows(CollectionUtils.toArray(arrayList));
                    } else {
                        WebTreeUI.this.tree.clearSelection();
                    }
                }
            }

            private List<Integer> getSelectionRowsList() {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int[] nArray = WebTreeUI.this.tree.getSelectionRows();
                if (nArray != null) {
                    for (int n : nArray) {
                        arrayList.add(n);
                    }
                }
                return arrayList;
            }

            private void repaintSelector() {
                WebTreeUI.this.tree.repaint();
            }

            private void repaintSelector(Rectangle rectangle) {
                WebTreeUI.this.tree.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.updateMouseover(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.clearMouseover();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.updateMouseover(mouseEvent);
            }

            private void updateMouseover(MouseEvent mouseEvent) {
                if (WebTreeUI.this.tree.isEnabled() && WebTreeUI.this.highlightRolloverNode) {
                    int n = WebTreeUI.this.getRowForPoint(mouseEvent.getPoint());
                    if (WebTreeUI.this.rolloverRow != n) {
                        int n2 = WebTreeUI.this.rolloverRow;
                        WebTreeUI.this.rolloverRow = n;
                        this.updateRow(n);
                        this.updateRow(n2);
                    }
                } else {
                    this.clearMouseover();
                }
            }

            private void clearMouseover() {
                int n = WebTreeUI.this.rolloverRow;
                WebTreeUI.this.rolloverRow = -1;
                this.updateRow(n);
            }

            private void updateRow(int n) {
                Rectangle rectangle;
                if (n != -1 && (rectangle = WebTreeUI.this.getFullRowBounds(n)) != null) {
                    WebTreeUI.this.tree.repaint(rectangle);
                }
            }
        };
        this.tree.addMouseListener(this.mouseAdapter);
        this.tree.addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.tree.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        this.tree.removeMouseListener(this.mouseAdapter);
        this.tree.removeMouseMotionListener(this.mouseAdapter);
        super.uninstallUI(jComponent);
    }

    public boolean isHighlightRolloverNode() {
        return this.highlightRolloverNode;
    }

    public void setHighlightRolloverNode(boolean bl) {
        this.highlightRolloverNode = bl;
    }

    public boolean isPaintLines() {
        return this.paintLines;
    }

    public void setPaintLines(boolean bl) {
        this.paintLines = bl;
    }

    public Color getLinesColor() {
        return this.linesColor;
    }

    public void setLinesColor(Color color) {
        this.linesColor = color;
    }

    public TreeSelectionStyle getSelectionStyle() {
        return this.selectionStyle;
    }

    public void setSelectionStyle(TreeSelectionStyle treeSelectionStyle) {
        this.selectionStyle = treeSelectionStyle;
    }

    public int getSelectionRound() {
        return this.selectionRound;
    }

    public void setSelectionRound(int n) {
        this.selectionRound = n;
    }

    public int getSelectionShadeWidth() {
        return this.selectionShadeWidth;
    }

    public void setSelectionShadeWidth(int n) {
        this.selectionShadeWidth = n;
    }

    public boolean isSelectorEnabled() {
        return this.selectorEnabled;
    }

    public void setSelectorEnabled(boolean bl) {
        this.selectorEnabled = bl;
    }

    public Color getSelectorColor() {
        return this.selectorColor;
    }

    public void setSelectorColor(Color color) {
        this.selectorColor = color;
    }

    public Color getSelectorBorderColor() {
        return this.selectorBorderColor;
    }

    public void setSelectorBorderColor(Color color) {
        this.selectorBorderColor = color;
    }

    public int getSelectorRound() {
        return this.selectorRound;
    }

    public void setSelectorRound(int n) {
        this.selectorRound = n;
    }

    public BasicStroke getSelectorStroke() {
        return this.selectorStroke;
    }

    public void setSelectorStroke(BasicStroke basicStroke) {
        this.selectorStroke = basicStroke;
    }

    public boolean isSelectorAvailable() {
        return this.isSelectorEnabled() && this.tree != null && this.tree.isEnabled() && this.tree.getSelectionModel().getSelectionMode() != 1;
    }

    public int getRowForPoint(Point point) {
        return this.getRowForPoint(point, this.isFullLineSelection());
    }

    public boolean isFullLineSelection() {
        return this.selectionStyle.equals((Object)TreeSelectionStyle.line);
    }

    public int getRowForPoint(Point point, boolean bl) {
        if (this.tree != null) {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                Rectangle rectangle = this.getRowBounds(i, bl);
                if (!rectangle.contains(point)) continue;
                return i;
            }
        }
        return -1;
    }

    public Rectangle getRowBounds(int n) {
        return this.getRowBounds(n, this.isFullLineSelection());
    }

    public Rectangle getRowBounds(int n, boolean bl) {
        return bl ? this.getFullRowBounds(n) : this.tree.getRowBounds(n);
    }

    public Rectangle getFullRowBounds(int n) {
        Rectangle rectangle = this.tree.getRowBounds(n);
        if (rectangle != null) {
            rectangle.x = 0;
            rectangle.width = this.tree.getWidth();
        }
        return rectangle;
    }

    @Override
    protected TreeCellEditor createDefaultCellEditor() {
        return new WebTreeCellEditor();
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new WebTreeCellRenderer();
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (!this.paintLines) {
            return;
        }
        int n2 = treePath.getPathCount() - 1;
        if ((n2 == 0 || n2 == 1 && !this.isRootVisible()) && !this.getShowsRootHandles()) {
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y;
        int n6 = rectangle.y + rectangle.height;
        int n7 = rectangle2.y + rectangle2.height / 2;
        if (this.ltr) {
            int n8 = rectangle2.x - this.getRightChildIndent();
            int n9 = rectangle2.x - this.getHorizontalLegBuffer();
            if (n7 >= n5 && n7 < n6 && n9 >= n3 && n8 < n4 && n8 < n9) {
                graphics.setColor(this.getHashColor());
                this.paintHorizontalLine(graphics, this.tree, n7, n8, n9 - 1);
            }
        } else {
            int n10 = rectangle2.x + rectangle2.width + this.getHorizontalLegBuffer();
            int n11 = rectangle2.x + rectangle2.width + this.getRightChildIndent();
            if (n7 >= n5 && n7 < n6 && n11 >= n3 && n10 < n4 && n10 < n11) {
                graphics.setColor(this.getHashColor());
                this.paintHorizontalLine(graphics, this.tree, n7, n10, n11 - 1);
            }
        }
    }

    @Override
    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        n2 = this.ltr ? n2 + 4 : n2 - 4;
        n3 = this.ltr ? n3 + 4 : n3 - 4;
        n2 += n2 % 2;
        for (int i = n2; i <= n3; i += 2) {
            graphics.drawLine(i, n, i, n);
        }
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (!this.paintLines) {
            return;
        }
        if (!this.paintLines) {
            return;
        }
        int n = treePath.getPathCount() - 1;
        if (n == 0 && !this.getShowsRootHandles() && !this.isRootVisible()) {
            return;
        }
        int n2 = this.getRowX(-1, n + 1);
        n2 = this.ltr ? n2 - this.getRightChildIndent() + insets.left : this.tree.getWidth() - n2 - insets.right + this.getRightChildIndent() - 1;
        int n3 = rectangle.x;
        int n4 = rectangle.x + (rectangle.width - 1);
        if (n2 >= n3 && n2 <= n4) {
            int n5;
            Object object;
            TreeModel treeModel;
            int n6 = rectangle.y;
            int n7 = rectangle.y + rectangle.height;
            Rectangle rectangle2 = this.getPathBounds(this.tree, treePath);
            Rectangle rectangle3 = this.getPathBounds(this.tree, this.getLastChildPath(treePath));
            if (rectangle3 == null) {
                return;
            }
            int n8 = rectangle2 == null ? Math.max(insets.top + this.getVerticalLegBuffer(), n6) : Math.max(rectangle2.y + rectangle2.height + this.getVerticalLegBuffer(), n6);
            if (n == 0 && !this.isRootVisible() && (treeModel = this.getModel()) != null && treeModel.getChildCount(object = treeModel.getRoot()) > 0 && (rectangle2 = this.getPathBounds(this.tree, treePath.pathByAddingChild(treeModel.getChild(object, 0)))) != null) {
                n8 = Math.max(insets.top + this.getVerticalLegBuffer(), rectangle2.y + rectangle2.height / 2);
            }
            if (n8 <= (n5 = Math.min(rectangle3.y + rectangle3.height / 2, n7))) {
                graphics.setColor(this.getHashColor());
                this.paintVerticalLine(graphics, this.tree, n2, n8, n5);
            }
        }
    }

    @Override
    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        n = this.ltr ? n + 4 : n - 4;
        n2 += n2 % 2;
        for (int i = n2; i <= n3; i += 2) {
            graphics.drawLine(n, i, n, i);
        }
    }

    @Override
    protected Color getHashColor() {
        return this.linesColor;
    }

    @Override
    public Icon getExpandedIcon() {
        return this.tree.isEnabled() ? COLLAPSE_ICON : DISABLED_COLLAPSE_ICON;
    }

    @Override
    public Icon getCollapsedIcon() {
        return this.tree.isEnabled() ? EXPAND_ICON : DISABLED_EXPAND_ICON;
    }

    @Override
    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        icon.paintIcon(component, graphics, this.findCenteredX(n, icon.getIconWidth()), n2 - icon.getIconHeight() / 2);
    }

    private int findCenteredX(int n, int n2) {
        return this.ltr ? n + 2 - (int)Math.ceil((double)n2 / 2.0) : n - 2 - (int)Math.floor((double)n2 / 2.0) - 3;
    }

    private void repaintSelection() {
        if (this.tree.getSelectionCount() > 0) {
            for (Rectangle rectangle : this.getSelectionRects()) {
                this.tree.repaint(rectangle);
            }
        }
    }

    private List<Rectangle> getSelectionRects() {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        int[] nArray = this.tree.getSelectionRows();
        if (nArray == null) {
            return arrayList;
        }
        Arrays.sort(nArray);
        Rectangle rectangle = null;
        int n = -1;
        for (int n2 : nArray) {
            if (this.selectionStyle.equals((Object)TreeSelectionStyle.single)) {
                arrayList.add(this.tree.getRowBounds(n2));
                continue;
            }
            if (n != -1 && n + 1 != n2) {
                arrayList.add(rectangle);
                rectangle = null;
                n = -1;
            }
            if (n != -1 && n + 1 != n2) continue;
            Rectangle rectangle2 = this.tree.getRowBounds(n2);
            if (this.isFullLineSelection()) {
                rectangle2.x = 0;
                rectangle2.width = this.tree.getWidth();
            }
            rectangle = n == -1 ? rectangle2 : GeometryUtils.getContainingRect(rectangle, rectangle2);
            n = n2;
        }
        if (rectangle != null) {
            arrayList.add(rectangle);
        }
        return arrayList;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        Object object2;
        Object object3;
        if (this.tree.getSelectionCount() > 0) {
            object3 = this.getSelectionRects();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                LafUtils.drawCustomWebBorder((Graphics2D)graphics, this.tree, new RoundRectangle2D.Double(((Rectangle)object).x + this.selectionShadeWidth, ((Rectangle)object).y + this.selectionShadeWidth, ((Rectangle)object).width - this.selectionShadeWidth * 2 - 1, ((Rectangle)object).height - this.selectionShadeWidth * 2 - 1, this.selectionRound * 2, this.selectionRound * 2), StyleConstants.shadeColor, this.selectionShadeWidth, true, true);
            }
        }
        if (this.tree.isEnabled() && this.highlightRolloverNode && this.rolloverRow != -1 && !this.tree.isRowSelected(this.rolloverRow)) {
            Object object4 = object3 = this.isFullLineSelection() ? this.getFullRowBounds(this.rolloverRow) : this.tree.getRowBounds(this.rolloverRow);
            if (object3 != null) {
                ((Rectangle)object3).x += this.selectionShadeWidth;
                ((Rectangle)object3).y += this.selectionShadeWidth;
                ((Rectangle)object3).width -= this.selectionShadeWidth * 2 + 1;
                ((Rectangle)object3).height -= this.selectionShadeWidth * 2 + 1;
                object2 = LafUtils.setupAlphaComposite((Graphics2D)graphics, 0.35f);
                LafUtils.drawCustomWebBorder((Graphics2D)graphics, this.tree, new RoundRectangle2D.Double(((Rectangle)object3).x, ((Rectangle)object3).y, ((Rectangle)object3).width, ((Rectangle)object3).height, this.selectionRound * 2, this.selectionRound * 2), StyleConstants.shadeColor, this.selectionShadeWidth, true, true);
                LafUtils.restoreComposite((Graphics2D)graphics, (Composite)object2);
            }
        }
        super.paint(graphics, jComponent);
        if (this.isSelectorAvailable() && this.selectionStart != null && this.selectionEnd != null) {
            object3 = (Graphics2D)graphics;
            LafUtils.setupAntialias((Graphics2D)object3);
            object2 = LafUtils.setupAntialias((Graphics2D)object3);
            object = LafUtils.setupStroke((Graphics2D)object3, this.selectorStroke);
            Rectangle rectangle = GeometryUtils.getContainingRect(this.selectionStart, this.selectionEnd);
            ((Graphics2D)object3).setPaint(this.selectorColor);
            ((Graphics2D)object3).fill(this.getSelectionShape(rectangle, true));
            ((Graphics2D)object3).setPaint(this.selectorBorderColor);
            ((Graphics2D)object3).draw(this.getSelectionShape(rectangle, false));
            LafUtils.restoreStroke((Graphics2D)object3, (Stroke)object);
            LafUtils.restoreAntialias((Graphics2D)object3, object2);
        }
    }

    private Shape getSelectionShape(Rectangle rectangle, boolean bl) {
        int n;
        int n2 = n = bl ? 1 : 0;
        if (this.selectorRound > 0) {
            return new RoundRectangle2D.Double(rectangle.x + n, rectangle.y + n, rectangle.width - n, rectangle.height - n, this.selectorRound * 2, this.selectorRound * 2);
        }
        return new Rectangle2D.Double(rectangle.x + n, rectangle.y + n, rectangle.width - n, rectangle.height - n);
    }
}

