/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.highlight;

import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class HighlightManager {
    public static List<Component> highlightComponentsWithText(String string, Component component) {
        List<Component> list = SwingUtils.findComponentsWithText(string, component);
        if (list.size() > 0) {
            HighlightManager.setHiglightedComponents(list, component);
        } else {
            HighlightManager.clearHighlightedComponents(component);
        }
        return list;
    }

    public static void setHiglightedComponent(Component component) {
        HighlightManager.setHiglightedComponent(component, null);
    }

    public static void setHiglightedComponent(Component component, Component component2) {
        WebGlassPane webGlassPane;
        if (component != null && (webGlassPane = GlassPaneManager.getGlassPane(SwingUtils.getWindowAncestor(component))) != null) {
            webGlassPane.clearHighlights();
            webGlassPane.setHighlightBase(component2 != null ? component2 : webGlassPane);
            webGlassPane.addHighlightedComponent(component);
        }
    }

    public static void setHiglightedComponents(List<Component> list) {
        HighlightManager.setHiglightedComponents(list, null);
    }

    public static void setHiglightedComponents(List<Component> list, Component component) {
        if (list != null && list.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Component component2 : list) {
                WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(SwingUtils.getWindowAncestor(component2));
                if (webGlassPane == null) continue;
                if (!arrayList.contains(webGlassPane.getId())) {
                    webGlassPane.setHighlightBase(component != null ? component : webGlassPane);
                    webGlassPane.clearHighlights();
                    arrayList.add(webGlassPane.getId());
                }
                webGlassPane.addHighlightedComponent(component2);
            }
        }
    }

    public static void removeHigligtedComponent(Component component) {
        WebGlassPane webGlassPane;
        if (component != null && (webGlassPane = GlassPaneManager.getGlassPane(SwingUtils.getWindowAncestor(component))) != null) {
            webGlassPane.removeHighlightedComponent(component);
        }
    }

    public static void removeHiglightedComponents(List<Component> list) {
        if (list != null && list.size() > 0) {
            for (Component component : list) {
                WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(SwingUtils.getWindowAncestor(component));
                if (webGlassPane == null) continue;
                webGlassPane.removeHighlightedComponent(component);
            }
        }
    }

    public static void clearHighlightedComponents(Component component) {
        HighlightManager.clearHighlightedComponents(SwingUtils.getWindowAncestor(component));
    }

    public static void clearHighlightedComponents(Window window) {
        WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(window);
        if (webGlassPane != null) {
            webGlassPane.clearHighlights();
        }
    }

    public static void setHighlightBase(Component component) {
        HighlightManager.setHighlightBase(SwingUtils.getWindowAncestor(component), component);
    }

    public static void setHighlightBase(Window window, Component component) {
        WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(window);
        if (webGlassPane != null) {
            webGlassPane.setHighlightBase(component);
        }
    }
}

