/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.tooltip.TooltipWay;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class TooltipConverter
implements Converter {
    @Override
    public boolean canConvert(Class clazz) {
        return Tooltip.class.getCanonicalName().equals(clazz.getCanonicalName());
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Tooltip tooltip = (Tooltip)object;
        if (TooltipConverter.shouldWriteDelay(tooltip)) {
            hierarchicalStreamWriter.addAttribute("delay", tooltip.getDelay().toString());
        }
        if (TooltipConverter.shouldWriteWay(tooltip)) {
            hierarchicalStreamWriter.addAttribute("way", tooltip.getWay().toString());
        }
        if (TooltipConverter.shouldWriteType(tooltip)) {
            hierarchicalStreamWriter.addAttribute("type", tooltip.getType().toString());
        }
        hierarchicalStreamWriter.setValue(tooltip.getText());
    }

    public static boolean shouldWriteDelay(Tooltip tooltip) {
        return tooltip.getDelay() != null;
    }

    public static boolean shouldWriteWay(Tooltip tooltip) {
        return tooltip.getWay() != null;
    }

    public static boolean shouldWriteType(Tooltip tooltip) {
        return tooltip.getType() != null && tooltip.getType() != LanguageManager.getDefaultTooltipType();
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String string = hierarchicalStreamReader.getAttribute("type");
        TooltipType tooltipType = TooltipConverter.parseType(string);
        String string2 = hierarchicalStreamReader.getAttribute("way");
        TooltipWay tooltipWay = TooltipConverter.parseWay(string2);
        String string3 = hierarchicalStreamReader.getAttribute("delay");
        Integer n = TooltipConverter.parseDelay(string3);
        String string4 = hierarchicalStreamReader.getValue();
        return new Tooltip(tooltipType, tooltipWay, n, string4);
    }

    public static TooltipType parseType(String string) {
        return string != null ? TooltipType.valueOf(string) : LanguageManager.getDefaultTooltipType();
    }

    public static TooltipWay parseWay(String string) {
        return string != null ? TooltipWay.valueOf(string) : null;
    }

    public static Integer parseDelay(String string) {
        return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }
}

