/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.TooltipConverter;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.language.data.Value;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;

public class ValueConverter
implements Converter {
    private static final String LANGUAGE = "lang";
    private static final String MNEMONIC = "mnemonic";
    private static final String HOTKEY = "hotkey";
    private static final String STATE = "state";
    private static final String TIP_TYPE = "type";
    private static final String TIP_WAY = "way";
    private static final String TIP_DELAY = "delay";
    public static final String TOOLTIP_KEY = "tooltip";

    @Override
    public boolean canConvert(Class clazz) {
        return Value.class.getCanonicalName().equals(clazz.getCanonicalName());
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Value value = (Value)object;
        if (value.getLang() != null) {
            hierarchicalStreamWriter.addAttribute(LANGUAGE, value.getLang());
        }
        if (value.getMnemonic() != null) {
            hierarchicalStreamWriter.addAttribute(MNEMONIC, value.getMnemonic().toString());
        }
        if (value.getHotkey() != null) {
            hierarchicalStreamWriter.addAttribute(HOTKEY, value.getHotkey());
        }
        if (value.getTexts() != null && value.getTexts().size() == 1 && (value.getTooltips() == null || value.getTooltips().size() == 0)) {
            Text text = value.getTextObject(0);
            if (text.getState() != null) {
                hierarchicalStreamWriter.addAttribute(STATE, text.getState());
            }
            hierarchicalStreamWriter.setValue(text.getText());
        } else if (value.getTooltips() != null && value.getTooltips().size() == 1 && (value.getTexts() == null || value.getTexts().size() == 0)) {
            Tooltip tooltip = value.getTooltipObject(0);
            if (TooltipConverter.shouldWriteDelay(tooltip)) {
                hierarchicalStreamWriter.addAttribute(TIP_DELAY, tooltip.getDelay().toString());
            }
            if (TooltipConverter.shouldWriteWay(tooltip)) {
                hierarchicalStreamWriter.addAttribute(TIP_WAY, tooltip.getWay().toString());
            }
            if (TooltipConverter.shouldWriteType(tooltip)) {
                hierarchicalStreamWriter.addAttribute(TIP_TYPE, tooltip.getType().toString());
            }
            hierarchicalStreamWriter.addAttribute(STATE, TOOLTIP_KEY);
            hierarchicalStreamWriter.setValue(tooltip.getText());
        } else if (value.getTexts() != null && value.getTexts().size() > 0 || value.getTooltips() != null && value.getTooltips().size() > 0) {
            marshallingContext.convertAnother(value.getTexts());
            marshallingContext.convertAnother(value.getTooltips());
        } else {
            hierarchicalStreamWriter.setValue("");
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Value value = new Value();
        value.setLang(hierarchicalStreamReader.getAttribute(LANGUAGE));
        String string = hierarchicalStreamReader.getAttribute(MNEMONIC);
        value.setMnemonic(string != null ? Character.valueOf(string.charAt(0)) : null);
        value.setHotkey(hierarchicalStreamReader.getAttribute(HOTKEY));
        String string2 = hierarchicalStreamReader.getAttribute(STATE);
        TooltipType tooltipType = TooltipConverter.parseType(hierarchicalStreamReader.getAttribute(TIP_TYPE));
        TooltipWay tooltipWay = TooltipConverter.parseWay(hierarchicalStreamReader.getAttribute(TIP_WAY));
        Integer n = TooltipConverter.parseDelay(hierarchicalStreamReader.getAttribute(TIP_DELAY));
        String string3 = hierarchicalStreamReader.getValue();
        ArrayList<Text> arrayList = new ArrayList<Text>();
        ArrayList<Tooltip> arrayList2 = new ArrayList<Tooltip>();
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            if (hierarchicalStreamReader.getNodeName().equals("text")) {
                arrayList.add((Text)unmarshallingContext.convertAnother(value, Text.class));
            } else if (hierarchicalStreamReader.getNodeName().equals(TOOLTIP_KEY)) {
                arrayList2.add((Tooltip)unmarshallingContext.convertAnother(value, Tooltip.class));
            }
            hierarchicalStreamReader.moveUp();
        }
        if (arrayList.size() == 0 && arrayList2.size() == 0) {
            if (string2 != null && string2.equals(TOOLTIP_KEY)) {
                value.setTooltips(CollectionUtils.copy(new Tooltip(tooltipType, tooltipWay, n, string3)));
                value.setTexts(null);
            } else {
                value.setTexts(CollectionUtils.copy(new Text(string3, string2)));
                value.setTooltips(null);
            }
        } else {
            value.setTexts(arrayList.size() > 0 ? arrayList : null);
            value.setTooltips(arrayList2.size() > 0 ? arrayList2 : null);
        }
        return value;
    }
}

