/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.extended.layout.AlignLayout;
import com.alee.laf.StyleConstants;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.ShadeLayerStyle;
import com.alee.managers.popup.WebPopup;
import com.alee.utils.LafUtils;
import com.alee.utils.swing.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class ShadeLayer
extends PopupLayer {
    private boolean animate = ShadeLayerStyle.animate;
    private int opacity = 0;
    private Timer animator;
    private boolean blockClose = false;
    private AlignLayout layout;

    public ShadeLayer() {
        this.setOpaque(false);
        this.layout = new AlignLayout();
        this.setLayout(this.layout);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!ShadeLayer.this.blockClose) {
                    ShadeLayer.this.hideAllPopups();
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    @Override
    public void showPopup(WebPopup webPopup) {
        this.showPopup(webPopup, false, false);
    }

    public void showPopup(WebPopup webPopup, boolean bl, boolean bl2) {
        this.layout.setHfill(bl);
        this.layout.setVfill(bl2);
        this.removeAll();
        this.add((Component)webPopup, "0,0", 0);
        this.setBounds(new Rectangle(0, 0, this.getParent().getWidth(), this.getParent().getHeight()));
        this.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean bl) {
        this.animate = bl;
    }

    public boolean isBlockClose() {
        return this.blockClose;
    }

    public void setBlockClose(boolean bl) {
        this.blockClose = bl;
    }

    @Override
    public void paint(Graphics graphics) {
        LafUtils.setupAlphaComposite((Graphics2D)graphics, (float)this.opacity / 100.0f, this.opacity < 100);
        super.paint(graphics);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        Composite composite = LafUtils.setupAlphaComposite(graphics2D, 0.8f);
        graphics2D.setPaint(Color.LIGHT_GRAY);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        LafUtils.restoreComposite(graphics2D, composite);
        LafUtils.restoreAntialias(graphics2D, object);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.stopAnimator();
            if (this.animate) {
                this.opacity = 0;
                this.animator = new Timer("ShadeLayer.fadeIn", (long)StyleConstants.animationDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ShadeLayer.this.opacity < 100) {
                            ShadeLayer.this.opacity += 25;
                            ShadeLayer.this.repaint();
                        } else {
                            ShadeLayer.this.animator.stop();
                        }
                    }
                });
                this.animator.start();
            } else {
                this.opacity = 100;
                this.repaint();
            }
        }
    }

    private void stopAnimator() {
        if (this.animator != null) {
            this.animator.stop();
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.normalContains(n, n2);
    }
}

