/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class JTextComponentSettingsProcessor
extends SettingsProcessor<JTextComponent, String> {
    private ActionListener actionListener;
    private FocusAdapter focusAdapter;

    public JTextComponentSettingsProcessor(SettingsProcessorData settingsProcessorData) {
        super(settingsProcessorData);
    }

    @Override
    public String getDefaultValue() {
        String string = (String)super.getDefaultValue();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    protected void doInit(JTextComponent jTextComponent) {
        this.focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JTextComponentSettingsProcessor.this.save();
            }
        };
        jTextComponent.addFocusListener(this.focusAdapter);
        if (jTextComponent instanceof JTextField) {
            JTextField jTextField = (JTextField)jTextComponent;
            this.actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTextComponentSettingsProcessor.this.save();
                }
            };
            jTextField.addActionListener(this.actionListener);
        }
    }

    @Override
    protected void doLoad(JTextComponent jTextComponent) {
        jTextComponent.setText((String)this.loadValue());
    }

    @Override
    protected void doSave(JTextComponent jTextComponent) {
        this.saveValue(jTextComponent.getText());
    }

    @Override
    protected void doDestroy(JTextComponent jTextComponent) {
        jTextComponent.removeFocusListener(this.focusAdapter);
        this.focusAdapter = null;
        if (jTextComponent instanceof JTextField) {
            JTextField jTextField = (JTextField)jTextComponent;
            jTextField.removeActionListener(this.actionListener);
            this.actionListener = null;
        }
    }
}

