/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.laf.label.WebLabel;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.tooltip.FadeType;
import com.alee.managers.tooltip.HotkeyTipLabel;
import com.alee.managers.tooltip.TooltipListener;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.managers.tooltip.WebCustomTooltipStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.Timer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WebCustomTooltip
extends JComponent
implements ShapeProvider {
    private static final String ID_PREFIX = "WCT";
    private static final int fadeFps = WebCustomTooltipStyle.fadeFps;
    private static final long fadeTime = WebCustomTooltipStyle.fadeTime;
    private static final int cornerLength = WebCustomTooltipStyle.cornerLength;
    private static final int cornerSideX = WebCustomTooltipStyle.cornerSideX;
    private String id = null;
    private JComponent tooltip = null;
    private WeakReference<Component> component = null;
    private Point displayLocation = null;
    private TooltipWay displayWay = WebCustomTooltipStyle.displayWay;
    private boolean showHotkey = WebCustomTooltipStyle.showHotkey;
    private int hotkeyLocation = WebCustomTooltipStyle.hotkeyLocation;
    private boolean defaultCloseBehavior = WebCustomTooltipStyle.defaultCloseBehavior;
    private int contentSpacing = WebCustomTooltipStyle.contentSpacing;
    private int leftRightSpacing = WebCustomTooltipStyle.leftRightSpacing;
    private int windowSideSpacing = WebCustomTooltipStyle.windowSideSpacing;
    private int round = WebCustomTooltipStyle.round;
    private int shadeWidth = WebCustomTooltipStyle.shadeWidth;
    private Color shadeColor = WebCustomTooltipStyle.shadeColor;
    private Color borderColor = WebCustomTooltipStyle.borderColor;
    private Color topBgColor = WebCustomTooltipStyle.topBgColor;
    private Color bottomBgColor = WebCustomTooltipStyle.bottomBgColor;
    private Color textColor = WebCustomTooltipStyle.textColor;
    private float trasparency = WebCustomTooltipStyle.trasparency;
    private List<TooltipListener> listeners = new ArrayList<TooltipListener>();
    private HotkeyTipLabel hotkey;
    private int cornerPeak = 0;
    private FadeType fadeType;
    private float fade = 0.0f;
    private Timer fadeTimer;
    private AncestorListener ancestorListener;

    private static WebLabel createDefaultComponent(Icon icon, String string) {
        return new WebLabel(string, icon);
    }

    public WebCustomTooltip(Component component, String string) {
        this(component, null, string);
    }

    public WebCustomTooltip(Component component, Icon icon, String string) {
        this(component, WebCustomTooltip.createDefaultComponent(icon, string));
    }

    public WebCustomTooltip(Component component, String string, TooltipWay tooltipWay) {
        this(component, null, string, tooltipWay);
    }

    public WebCustomTooltip(Component component, Icon icon, String string, TooltipWay tooltipWay) {
        this(component, (JComponent)WebCustomTooltip.createDefaultComponent(icon, string), tooltipWay);
    }

    public WebCustomTooltip(Component component, String string, boolean bl) {
        this(component, null, string, bl);
    }

    public WebCustomTooltip(Component component, Icon icon, String string, boolean bl) {
        this(component, (JComponent)WebCustomTooltip.createDefaultComponent(icon, string), bl);
    }

    public WebCustomTooltip(Component component, String string, TooltipWay tooltipWay, boolean bl) {
        this(component, null, string, tooltipWay, bl);
    }

    public WebCustomTooltip(Component component, Icon icon, String string, TooltipWay tooltipWay, boolean bl) {
        this(component, WebCustomTooltip.createDefaultComponent(icon, string), tooltipWay, bl);
    }

    public WebCustomTooltip(Component component, JComponent jComponent) {
        this(component, jComponent, WebCustomTooltipStyle.displayWay);
    }

    public WebCustomTooltip(Component component, JComponent jComponent, TooltipWay tooltipWay) {
        this(component, jComponent, tooltipWay, WebCustomTooltipStyle.showHotkey);
    }

    public WebCustomTooltip(Component component, JComponent jComponent, boolean bl) {
        this(component, jComponent, WebCustomTooltipStyle.displayWay, bl);
    }

    public WebCustomTooltip(Component component, JComponent jComponent, TooltipWay tooltipWay, boolean bl) {
        SwingUtils.setOrientation(this);
        SwingUtils.setForegroundRecursively(jComponent, this.textColor);
        this.setOpaque(false);
        this.id = TextUtils.generateId(ID_PREFIX);
        this.component = new WeakReference<Component>(component);
        this.tooltip = jComponent;
        this.showHotkey = bl;
        this.displayWay = tooltipWay;
        this.hotkey = new HotkeyTipLabel();
        this.setLayout(new BorderLayout(6, 6));
        this.add((Component)jComponent, "Center");
        this.fadeTimer = new Timer("WebCustomTooltip.fade", (long)(1000 / fadeFps));
        this.fadeTimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                float f = (float)fadeTime / (1000.0f / (float)fadeFps);
                float f2 = 1.0f / f;
                if (WebCustomTooltip.this.fadeType.equals((Object)FadeType.fadeIn)) {
                    if (WebCustomTooltip.this.fade < 1.0f) {
                        WebCustomTooltip.this.fade = Math.min(WebCustomTooltip.this.fade + f2, 1.0f);
                        WebCustomTooltip.this.repaint();
                    } else {
                        WebCustomTooltip.this.fireTooltipFullyShown();
                        WebCustomTooltip.this.fadeTimer.stop();
                    }
                } else if (WebCustomTooltip.this.fadeType.equals((Object)FadeType.fadeOut)) {
                    if (WebCustomTooltip.this.fade > 0.0f) {
                        WebCustomTooltip.this.fade = Math.max(WebCustomTooltip.this.fade - f2, 0.0f);
                        WebCustomTooltip.this.repaint();
                    } else {
                        JComponent jComponent = (JComponent)WebCustomTooltip.this.getParent();
                        if (jComponent != null) {
                            Rectangle rectangle = WebCustomTooltip.this.getBounds();
                            jComponent.remove(WebCustomTooltip.this);
                            jComponent.repaint(rectangle);
                        }
                        WebCustomTooltip.this.fadeTimer.stop();
                    }
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                WebCustomTooltip.this.updateHotkey();
                WebCustomTooltip.this.updateBorder();
                WebCustomTooltip.this.updateLocation();
                WebCustomTooltip.this.fade = 0.0f;
                WebCustomTooltip.this.fadeType = FadeType.fadeIn;
                WebCustomTooltip.this.fadeTimer.start();
                WebCustomTooltip.this.fireTooltipShown();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                WebCustomTooltip.this.fireTooltipHidden();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
                WebCustomTooltip.this.updateBorder();
                WebCustomTooltip.this.updateLocation();
            }
        });
        if (component instanceof JComponent) {
            this.ancestorListener = new AncestorAdapter(){

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    WebCustomTooltip.this.closeTooltip();
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                    WebCustomTooltip.this.closeTooltip();
                }
            };
            ((JComponent)component).addAncestorListener(this.ancestorListener);
        }
    }

    private void updateHotkey() {
        String string = HotkeyManager.getComponentHotkeysString(this.getComponent());
        if (this.showHotkey && !string.trim().equals("")) {
            this.hotkey.setText(string);
            if (this.getComponentZOrder(this.hotkey) != -1) {
                this.remove(this.hotkey);
            }
            this.add((Component)this.hotkey, this.getActualHotkeyLocation());
        } else {
            this.remove(this.hotkey);
        }
    }

    private String getActualHotkeyLocation() {
        switch (this.hotkeyLocation) {
            case 10: {
                return "Before";
            }
            case 11: {
                return "After";
            }
            case 2: {
                return "West";
            }
            case 4: {
                return "East";
            }
        }
        return "After";
    }

    public void closeTooltip() {
        if (this.getParent() == null) {
            return;
        }
        this.fadeType = FadeType.fadeOut;
        if (!this.fadeTimer.isRunning()) {
            this.fadeTimer.start();
        }
    }

    public void destroyTooltip() {
        Component component = this.getComponent();
        if (component instanceof JComponent) {
            ((JComponent)component).removeAncestorListener(this.ancestorListener);
        }
        this.fireTooltipDestroyed();
    }

    public TooltipWay getActualDisplayWay() {
        Component component = this.getComponent();
        if (this.displayWay != null) {
            if (this.displayWay.equals((Object)TooltipWay.leading) || this.displayWay.equals((Object)TooltipWay.trailing)) {
                boolean bl = component.getComponentOrientation().isLeftToRight();
                if (this.displayWay.equals((Object)TooltipWay.leading) && bl || this.displayWay.equals((Object)TooltipWay.trailing) && !bl) {
                    return TooltipWay.left;
                }
                return TooltipWay.right;
            }
            return this.displayWay;
        }
        if (!component.isShowing()) {
            return TooltipWay.down;
        }
        Component component2 = SwingUtilities.getRootPane(component).getGlassPane();
        Dimension dimension = component2.getSize();
        Rectangle rectangle = SwingUtils.getRelativeBounds(component, component2);
        Dimension dimension2 = this.getPreferredSize();
        if (rectangle.y + this.getTooltipPoint((Component)component, (TooltipWay)TooltipWay.down).y + dimension2.height < dimension.height - this.windowSideSpacing) {
            return TooltipWay.down;
        }
        if (rectangle.y + this.getTooltipPoint((Component)component, (TooltipWay)TooltipWay.up).y - dimension2.height > this.windowSideSpacing) {
            return TooltipWay.up;
        }
        if (rectangle.x + this.getTooltipPoint((Component)component, (TooltipWay)TooltipWay.right).x + dimension2.width < dimension.width - this.windowSideSpacing) {
            return TooltipWay.right;
        }
        if (rectangle.x + this.getTooltipPoint((Component)component, (TooltipWay)TooltipWay.left).x - dimension2.width > this.windowSideSpacing) {
            return TooltipWay.left;
        }
        return TooltipWay.down;
    }

    private Point getTooltipPoint(Component component, TooltipWay tooltipWay) {
        if (this.displayLocation == null) {
            if (tooltipWay.equals((Object)TooltipWay.down)) {
                return new Point(component.getWidth() / 2, component.getHeight() - cornerLength / 2 + this.shadeWidth);
            }
            if (tooltipWay.equals((Object)TooltipWay.up)) {
                return new Point(component.getWidth() / 2, cornerLength / 2 - this.shadeWidth);
            }
            if (tooltipWay.equals((Object)TooltipWay.left)) {
                return new Point(cornerLength / 2 - this.shadeWidth, this.getHeight() / 2);
            }
            return new Point(component.getWidth() - cornerLength / 2 + this.shadeWidth, this.getHeight() / 2);
        }
        return this.displayLocation;
    }

    public void updateBorder() {
        TooltipWay tooltipWay = this.getActualDisplayWay();
        int n = this.shadeWidth + this.contentSpacing + this.leftRightSpacing + (tooltipWay.equals((Object)TooltipWay.right) ? cornerLength : 0);
        int n2 = this.shadeWidth + this.contentSpacing + this.leftRightSpacing + (tooltipWay.equals((Object)TooltipWay.left) ? cornerLength : 0);
        int n3 = this.shadeWidth + this.contentSpacing + (tooltipWay.equals((Object)TooltipWay.down) ? cornerLength : 0);
        int n4 = this.shadeWidth + this.contentSpacing + (tooltipWay.equals((Object)TooltipWay.up) ? cornerLength : 0);
        Insets insets = this.getHotkeyMargins();
        this.setBorder(BorderFactory.createEmptyBorder(n3 + insets.top, n + insets.left, n4 + insets.bottom, n2 + insets.right));
        this.revalidate();
    }

    private Insets getHotkeyMargins() {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        boolean bl2 = this.hotkeyLocation == 2 || this.hotkeyLocation == 10 && bl || this.hotkeyLocation == 11 && !bl;
        int n = this.showHotkey && bl2 ? 0 : 2;
        int n2 = this.showHotkey && !bl2 ? 0 : 2;
        return new Insets(0, n, 0, n2);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        this.closeTooltip();
    }

    public int getContentSpacing() {
        return this.contentSpacing;
    }

    public void setContentSpacing(int n) {
        this.contentSpacing = n;
        this.updateBorder();
    }

    public int getLeftRightSpacing() {
        return this.leftRightSpacing;
    }

    public void setLeftRightSpacing(int n) {
        this.leftRightSpacing = n;
        this.updateBorder();
        this.updateLocation();
    }

    public void updateLocation() {
        Component component = this.getComponent();
        if (this.getParent() != null && this.getParent().isShowing() && component.isShowing()) {
            TooltipWay tooltipWay = this.getActualDisplayWay();
            Point point = this.getParent().getLocationOnScreen();
            Point point2 = component.getLocationOnScreen();
            Dimension dimension = this.getPreferredSize();
            if (tooltipWay.equals((Object)TooltipWay.up) || tooltipWay.equals((Object)TooltipWay.down)) {
                int n;
                int n2;
                if (this.displayLocation == null) {
                    n2 = point2.x - point.x + component.getWidth() / 2;
                    n = point2.y - point.y + (tooltipWay.equals((Object)TooltipWay.up) ? cornerLength / 2 - this.shadeWidth - dimension.height : component.getHeight() - cornerLength / 2 + this.shadeWidth);
                } else {
                    n2 = point2.x - point.x + this.displayLocation.x;
                    n = point2.y - point.y + this.displayLocation.y - (tooltipWay.equals((Object)TooltipWay.up) ? dimension.height : 0);
                }
                if (n2 - dimension.width / 2 < this.windowSideSpacing) {
                    int n3 = this.windowSideSpacing - (n2 - dimension.width / 2);
                    this.cornerPeak = Math.max(this.shadeWidth + this.round + cornerSideX + 1, this.getWidth() / 2 - n3);
                    this.setLocation(this.windowSideSpacing, n);
                } else if (n2 + dimension.width / 2 > this.getParent().getWidth() - this.windowSideSpacing) {
                    int n4 = n2 + dimension.width / 2 - (this.getParent().getWidth() - this.windowSideSpacing);
                    this.cornerPeak = Math.min(dimension.width - this.shadeWidth - this.round - cornerSideX - 1, this.getWidth() / 2 + n4);
                    this.setLocation(this.getParent().getWidth() - this.windowSideSpacing - dimension.width, n);
                } else {
                    this.cornerPeak = this.getWidth() / 2;
                    this.setLocation(n2 - dimension.width / 2, n);
                }
            } else if (tooltipWay.equals((Object)TooltipWay.left) || tooltipWay.equals((Object)TooltipWay.right)) {
                int n;
                int n5;
                if (this.displayLocation == null) {
                    n5 = point2.y - point.y + component.getHeight() / 2;
                    n = point2.x - point.x + (tooltipWay.equals((Object)TooltipWay.left) ? cornerLength / 2 - this.shadeWidth - dimension.width : component.getWidth() - cornerLength / 2 + this.shadeWidth);
                } else {
                    n5 = point2.y - point.y + this.displayLocation.y;
                    n = point2.x - point.x + this.displayLocation.x - (tooltipWay.equals((Object)TooltipWay.left) ? dimension.width : 0);
                }
                if (n5 - dimension.height / 2 < this.windowSideSpacing) {
                    int n6 = this.windowSideSpacing - (n5 - dimension.height / 2);
                    this.cornerPeak = Math.max(this.shadeWidth + this.round + cornerSideX + 1, this.getHeight() / 2 - n6);
                    this.setLocation(n, this.windowSideSpacing);
                } else if (n5 + dimension.height / 2 > this.getParent().getHeight() - this.windowSideSpacing) {
                    int n7 = n5 + dimension.height / 2 - (this.getParent().getHeight() - this.windowSideSpacing);
                    this.cornerPeak = Math.min(dimension.height - this.shadeWidth - this.round - cornerSideX - 1, this.getHeight() / 2 + n7);
                    this.setLocation(n, this.getParent().getHeight() - this.windowSideSpacing - dimension.height);
                } else {
                    this.cornerPeak = this.getHeight() / 2;
                    this.setLocation(n, n5 - dimension.height / 2);
                }
            }
            this.setSize(this.getPreferredSize());
        }
    }

    public Point getDisplayLocation() {
        return this.displayLocation;
    }

    public void setDisplayLocation(int n, int n2) {
        this.setDisplayLocation(new Point(n, n2));
    }

    public void setDisplayLocation(Point point) {
        this.displayLocation = point;
        this.updateLocation();
    }

    public int getWindowSideSpacing() {
        return this.windowSideSpacing;
    }

    public void setWindowSideSpacing(int n) {
        this.windowSideSpacing = n;
        this.updateLocation();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
        this.updateLocation();
    }

    public Component getComponent() {
        return (Component)this.component.get();
    }

    public String getId() {
        return this.id;
    }

    public JComponent getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String string) {
        if (this.tooltip != null && this.tooltip instanceof JLabel) {
            ((JLabel)this.tooltip).setText(string);
            this.updateBorder();
            this.updateLocation();
        }
    }

    public void setTooltip(JComponent jComponent) {
        if (this.tooltip != null) {
            this.remove(this.tooltip);
        }
        this.tooltip = jComponent;
        this.add((Component)jComponent, "Center");
        this.updateBorder();
        this.updateLocation();
    }

    public TooltipWay getDisplayWay() {
        return this.displayWay;
    }

    public void setDisplayWay(TooltipWay tooltipWay) {
        this.displayWay = tooltipWay;
        this.updateBorder();
        this.updateLocation();
    }

    public boolean isShowHotkey() {
        return this.showHotkey;
    }

    public void setShowHotkey(boolean bl) {
        this.showHotkey = bl;
        this.updateHotkey();
        this.updateBorder();
        this.updateLocation();
    }

    public int getHotkeyLocation() {
        return this.hotkeyLocation;
    }

    public void setHotkeyLocation(int n) {
        this.hotkeyLocation = n;
        this.updateHotkey();
        this.updateBorder();
        this.updateLocation();
    }

    public boolean isDefaultCloseBehavior() {
        return this.defaultCloseBehavior;
    }

    public void setDefaultCloseBehavior(boolean bl) {
        this.defaultCloseBehavior = bl;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color getHotkeyColor() {
        return this.hotkey.getForeground();
    }

    public void setHotkeyColor(Color color) {
        this.hotkey.setForeground(color);
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color color) {
        this.topBgColor = color;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color color) {
        this.bottomBgColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public float getTrasparency() {
        return this.trasparency;
    }

    public void setTrasparency(float f) {
        this.trasparency = f;
    }

    @Override
    public Shape provideShape() {
        return this.getTooltipShape(this.getActualDisplayWay(), true);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        if (this.fade < 1.0f) {
            LafUtils.setupAlphaComposite(graphics2D, this.fade);
        }
        Composite composite = null;
        if (this.trasparency < 1.0f) {
            composite = LafUtils.setupAlphaComposite(graphics2D, this.trasparency);
        }
        TooltipWay tooltipWay = this.getActualDisplayWay();
        Shape shape = null;
        if (this.shadeWidth > 0 && this.shadeColor != null) {
            shape = this.getTooltipShape(tooltipWay, false);
        }
        LafUtils.drawShade(graphics2D, shape, WebCustomTooltipStyle.shadeType, this.shadeColor, this.shadeWidth);
        if (this.topBgColor != null) {
            if (this.bottomBgColor != null) {
                if (tooltipWay.equals((Object)TooltipWay.down)) {
                    graphics2D.setPaint(new GradientPaint(0.0f, this.getHeight() * 2 / 3, this.topBgColor, 0.0f, this.getHeight(), this.bottomBgColor));
                } else {
                    graphics2D.setPaint(new GradientPaint(0.0f, this.getHeight() / 3, this.topBgColor, 0.0f, this.getHeight(), this.bottomBgColor));
                }
            } else {
                graphics2D.setPaint(this.topBgColor);
            }
            graphics2D.fill(this.getTooltipShape(tooltipWay, true));
        }
        if (this.borderColor != null) {
            graphics2D.setPaint(this.borderColor);
            graphics2D.draw(shape);
        }
        if (composite != null) {
            LafUtils.restoreComposite(graphics2D, composite);
        }
        LafUtils.restoreAntialias(graphics2D, object);
    }

    private Shape getTooltipShape(TooltipWay tooltipWay, boolean bl) {
        float f = bl ? 1.0f : 0.0f;
        float f2 = (float)(tooltipWay.equals((Object)TooltipWay.left) || tooltipWay.equals((Object)TooltipWay.right) ? cornerLength + 1 : 1) - f + (float)(this.shadeWidth * 2);
        float f3 = (float)(tooltipWay.equals((Object)TooltipWay.up) || tooltipWay.equals((Object)TooltipWay.down) ? cornerLength + 1 : 1) - f + (float)(this.shadeWidth * 2);
        Area area = new Area(new RoundRectangle2D.Double(this.shadeWidth + (tooltipWay.equals((Object)TooltipWay.right) ? cornerLength : 0), this.shadeWidth + (tooltipWay.equals((Object)TooltipWay.down) ? cornerLength : 0), (float)this.getWidth() - f2, (float)this.getHeight() - f3, this.round * 2, this.round * 2));
        f = bl ? 0.5f : 0.0f;
        GeneralPath generalPath = new GeneralPath(0);
        if (tooltipWay.equals((Object)TooltipWay.up)) {
            generalPath.moveTo((float)this.cornerPeak + f, this.getHeight() - this.shadeWidth - 1);
            generalPath.lineTo((float)(this.cornerPeak - cornerSideX) + f, this.getHeight() - this.shadeWidth - 1 - cornerLength);
            generalPath.lineTo((float)(this.cornerPeak + cornerSideX) + f, this.getHeight() - this.shadeWidth - 1 - cornerLength);
        } else if (tooltipWay.equals((Object)TooltipWay.down)) {
            generalPath.moveTo(this.cornerPeak, this.shadeWidth);
            generalPath.lineTo(this.cornerPeak - cornerSideX, this.shadeWidth + cornerLength);
            generalPath.lineTo(this.cornerPeak + cornerSideX, this.shadeWidth + cornerLength);
        } else if (tooltipWay.equals((Object)TooltipWay.left)) {
            generalPath.moveTo(this.getWidth() - this.shadeWidth - 1, (float)this.cornerPeak + f);
            generalPath.lineTo(this.getWidth() - this.shadeWidth - 1 - cornerLength, (float)this.cornerPeak + f - (float)cornerSideX);
            generalPath.lineTo(this.getWidth() - this.shadeWidth - 1 - cornerLength, (float)this.cornerPeak + f + (float)cornerSideX);
        } else if (tooltipWay.equals((Object)TooltipWay.right)) {
            generalPath.moveTo(this.shadeWidth, this.cornerPeak);
            generalPath.lineTo(this.shadeWidth + cornerLength, this.cornerPeak - cornerSideX);
            generalPath.lineTo(this.shadeWidth + cornerLength, this.cornerPeak + cornerSideX);
        }
        generalPath.closePath();
        area.add(new Area(generalPath));
        return area;
    }

    public void addTooltipListener(TooltipListener tooltipListener) {
        this.listeners.add(tooltipListener);
    }

    public void removeTooltipListener(TooltipListener tooltipListener) {
        this.listeners.remove(tooltipListener);
    }

    public void removeAllTooltipListeners() {
        this.listeners.clear();
    }

    private void fireTooltipShown() {
        for (TooltipListener tooltipListener : CollectionUtils.copy(this.listeners)) {
            tooltipListener.tooltipShown();
        }
    }

    private void fireTooltipFullyShown() {
        for (TooltipListener tooltipListener : CollectionUtils.copy(this.listeners)) {
            tooltipListener.tooltipFullyShown();
        }
    }

    private void fireTooltipHidden() {
        for (TooltipListener tooltipListener : CollectionUtils.copy(this.listeners)) {
            tooltipListener.tooltipHidden();
        }
    }

    private void fireTooltipDestroyed() {
        for (TooltipListener tooltipListener : CollectionUtils.copy(this.listeners)) {
            tooltipListener.tooltipDestroyed();
        }
    }
}

