/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.laf.StyleConstants;
import com.alee.utils.LafUtils;
import com.alee.utils.TimeUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class DebugUtils {
    public static void initTimeDebugInfo() {
        if (StyleConstants.DEBUG) {
            TimeUtils.pinNanoTime();
        }
    }

    public static void paintTimeDebugInfo(Graphics graphics, JComponent jComponent) {
        if (StyleConstants.DEBUG) {
            DebugUtils.paintDebugInfoImpl((Graphics2D)graphics, jComponent);
        }
    }

    public static void paintTimeDebugInfo(Graphics2D graphics2D, JComponent jComponent) {
        if (StyleConstants.DEBUG) {
            DebugUtils.paintDebugInfoImpl(graphics2D, jComponent);
        }
    }

    private static void paintDebugInfoImpl(Graphics2D graphics2D, JComponent jComponent) {
        double d = (float)TimeUtils.getPassedNanoTime() / 1000000.0f;
        String string = "" + StyleConstants.DEBUG_FORMAT.format(d);
        Rectangle rectangle = graphics2D.getClip().getBounds();
        Font font = graphics2D.getFont();
        graphics2D.setFont(StyleConstants.DEBUG_FONT);
        Object object = LafUtils.setupAntialias(graphics2D);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.stringWidth(string) + 4;
        int n2 = fontMetrics.getHeight();
        graphics2D.setPaint(Color.BLACK);
        graphics2D.fillRect(rectangle.x + rectangle.width - n, rectangle.y, n, n2);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.drawString(string, rectangle.x + rectangle.width - n + 2, rectangle.y + n2 - fontMetrics.getDescent());
        LafUtils.restoreAntialias(graphics2D, object);
        graphics2D.setFont(font);
    }

    public static void paintBorderDebugInfo(Graphics graphics, JComponent jComponent) {
        DebugUtils.paintBorderDebugInfo(graphics, jComponent, Color.RED);
    }

    public static void paintBorderDebugInfo(Graphics graphics, JComponent jComponent, Color color) {
        Insets insets = jComponent.getInsets();
        graphics.setColor(color);
        graphics.drawRect(0, 0, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
        graphics.drawRect(insets.left, insets.top, jComponent.getWidth() - insets.left - insets.right - 1, jComponent.getHeight() - insets.top - insets.bottom - 1);
    }
}

