/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.extended.date.WebCalendar;
import com.alee.extended.date.WebDateField;
import com.alee.extended.filechooser.WebFileChooserField;
import com.alee.extended.filechooser.WebPathField;
import com.alee.extended.panel.WebCollapsiblePane;
import com.alee.laf.StyleConstants;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.language.LanguageManager;
import com.alee.utils.ImageUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.ThreadUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.EventPump;
import com.alee.utils.swing.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class SwingUtils {
    public static final String HANDLES_ENABLE_STATE = "HANDLES_ENABLE_STATE";
    private static Integer systemShortcutModifier = null;
    private static JLabel label = null;
    private static String[] fontNames;
    private static Font[] fonts;
    private static Thread scrollThread1;
    private static Thread scrollThread2;
    private static Map<Window, Timer> windowPackTimers;
    private static final int STRONG_BEARING_CACHE_SIZE = 10;
    private static BearingCacheEntry[] strongBearingCache;
    private static int strongBearingCacheNextIndex;
    private static Set<SoftReference<BearingCacheEntry>> softBearingCache;

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 0x10) != 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 8) == 8;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) == 4;
    }

    public static void packRowHeights(JTable jTable) {
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n = 0;
            for (int j = 0; j < jTable.getColumnCount(); ++j) {
                Object object;
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, j);
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object = jTable.getValueAt(i, j), false, false, i, j);
                int n2 = component != null ? component.getPreferredSize().height : 0;
                n = Math.max(n2, n);
            }
            jTable.setRowHeight(i, n);
        }
    }

    public static void packColumnWidths(JTable jTable) {
        SwingUtils.packColumnWidths(jTable, StyleConstants.spacing);
    }

    public static void packColumnWidths(JTable jTable, int n) {
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            SwingUtils.packColumnWidth(jTable, i, n);
        }
    }

    public static void packColumnWidth(JTable jTable, int n) {
        SwingUtils.packColumnWidth(jTable, n, StyleConstants.spacing);
    }

    public static void packColumnWidth(JTable jTable, int n, int n2) {
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)jTable.getColumnModel();
        TableColumn tableColumn = defaultTableColumnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
        int n3 = component.getPreferredSize().width;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            tableCellRenderer = jTable.getCellRenderer(i, n);
            component = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n), false, false, i, n);
            int n4 = component.getPreferredSize().width;
            n3 = Math.max(n3, n4);
        }
        tableColumn.setPreferredWidth(n3 += 2 * n2);
        tableColumn.setWidth(n3);
    }

    public static void setWindowOpacity(Window window, float f) {
        if (window != null && SwingUtils.isWindowTransparencyAllowed()) {
            try {
                ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "setWindowOpacity", window, Float.valueOf(f));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static float getWindowOpacity(Window window) {
        if (window != null && SwingUtils.isWindowTransparencyAllowed()) {
            try {
                return ((Float)ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "getWindowOpacity", window)).floatValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 1.0f;
    }

    public static void setWindowOpaque(Window window, boolean bl) {
        if (window != null && SwingUtils.isWindowTransparencyAllowed()) {
            try {
                ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "setWindowOpaque", window, bl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isWindowOpaque(Window window) {
        if (window != null && SwingUtils.isWindowTransparencyAllowed()) {
            try {
                return (Boolean)ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "isWindowOpaque", window);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean isWindowTransparencyAllowed() {
        try {
            return SystemUtils.isWindows() || SystemUtils.isMac() || SystemUtils.isSolaris();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.isPopupTrigger() || SwingUtilities.isRightMouseButton(mouseEvent);
    }

    /*
     * Could not resolve type clashes
     */
    public static void destroyContainer(Container container) {
        for (Container container2 : SwingUtils.collectAllContainers(container)) {
            container2.removeAll();
            container2.setLayout(null);
            for (EventListener eventListener : container2.getMouseListeners()) {
                container2.removeMouseListener((MouseListener)eventListener);
            }
            for (EventListener eventListener : container2.getMouseMotionListeners()) {
                container2.removeMouseMotionListener((MouseMotionListener)eventListener);
            }
            for (EventListener eventListener : container2.getMouseWheelListeners()) {
                container2.removeMouseWheelListener((MouseWheelListener)eventListener);
            }
            for (EventListener eventListener : container2.getKeyListeners()) {
                container2.removeKeyListener((KeyListener)eventListener);
            }
            for (EventListener eventListener : container2.getComponentListeners()) {
                container2.removeComponentListener((ComponentListener)eventListener);
            }
            for (EventListener eventListener : container2.getContainerListeners()) {
                container2.removeContainerListener((ContainerListener)eventListener);
            }
            if (!(container2 instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)container2;
            for (AncestorListener ancestorListener : jComponent.getAncestorListeners()) {
                jComponent.removeAncestorListener(ancestorListener);
            }
        }
    }

    public static List<Container> collectAllContainers(Container container) {
        return SwingUtils.collectAllContainers(container, new ArrayList<Container>());
    }

    public static List<Container> collectAllContainers(Container container, List<Container> list) {
        list.add(container);
        for (Component component : container.getComponents()) {
            if (!(component instanceof Container)) continue;
            SwingUtils.collectAllContainers((Container)component, list);
        }
        return list;
    }

    public static Component getTopComponentAt(Component component, int n, int n2) {
        Component component2 = component.getComponentAt(n, n2);
        if (component2 == component || !(component2 instanceof Container)) {
            return component;
        }
        Rectangle rectangle = component2.getBounds();
        return SwingUtils.getTopComponentAt(component2, n - rectangle.x, n2 - rectangle.y);
    }

    public static void showAsModal(final Frame frame, final Frame frame2) {
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                frame2.setEnabled(false);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                frame2.setEnabled(true);
                frame.removeWindowListener(this);
            }
        });
        frame2.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (frame.isShowing()) {
                    frame.setExtendedState(0);
                    frame.toFront();
                } else {
                    frame2.removeWindowListener(this);
                }
            }
        });
        frame.setVisible(true);
        try {
            new EventPump(frame).start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static ShapeProvider getShapeProvider(Component component) {
        if (component instanceof ShapeProvider) {
            return (ShapeProvider)((Object)component);
        }
        Object object = ReflectUtils.callMethodSafely(component, "getUI", new Object[0]);
        if (object instanceof ShapeProvider) {
            return (ShapeProvider)object;
        }
        return null;
    }

    public static ButtonGroup groupButtons(Container container) {
        return SwingUtils.groupButtons(container, false);
    }

    public static ButtonGroup groupButtons(Container container, boolean bl) {
        ButtonGroup buttonGroup = new ButtonGroup();
        SwingUtils.groupButtons(container, bl, buttonGroup);
        return buttonGroup;
    }

    public static void groupButtons(Container container, boolean bl, ButtonGroup buttonGroup) {
        for (Component component : container.getComponents()) {
            if (component instanceof AbstractButton) {
                buttonGroup.add((AbstractButton)component);
            }
            if (!bl || !(component instanceof Container)) continue;
            SwingUtils.groupButtons(container, true);
        }
    }

    public static ButtonGroup groupButtons(AbstractButton ... abstractButtonArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        SwingUtils.groupButtons(buttonGroup, abstractButtonArray);
        return buttonGroup;
    }

    public static void groupButtons(ButtonGroup buttonGroup, AbstractButton ... abstractButtonArray) {
        for (AbstractButton abstractButton : abstractButtonArray) {
            buttonGroup.add(abstractButton);
        }
    }

    public static void copyOrientation(Component component, Component component2) {
        ComponentOrientation componentOrientation = component.getComponentOrientation();
        if (componentOrientation.isLeftToRight() != component2.getComponentOrientation().isLeftToRight()) {
            component2.applyComponentOrientation(componentOrientation);
        }
    }

    public static void updateGlobalOrientations() {
        SwingUtils.updateGlobalOrientations(LanguageManager.getOrientation());
    }

    public static void updateGlobalOrientations(ComponentOrientation componentOrientation) {
        for (Window window : Window.getWindows()) {
            window.applyComponentOrientation(componentOrientation);
            JRootPane jRootPane = SwingUtils.getRootPane(window);
            if (jRootPane != null) {
                jRootPane.revalidate();
                jRootPane.repaint();
                continue;
            }
            window.repaint();
        }
    }

    public static void setOrientation(Component component) {
        SwingUtils.setOrientation(component, false);
    }

    public static void setOrientation(Component component, boolean bl) {
        ComponentOrientation componentOrientation = LanguageManager.getOrientation();
        if (bl || componentOrientation.isLeftToRight() != component.getComponentOrientation().isLeftToRight()) {
            component.setComponentOrientation(componentOrientation);
        }
    }

    public static void applyOrientation(Component component) {
        SwingUtils.applyOrientation(component, false);
    }

    public static void applyOrientation(Component component, boolean bl) {
        ComponentOrientation componentOrientation = LanguageManager.getOrientation();
        if (bl || componentOrientation.isLeftToRight() != component.getComponentOrientation().isLeftToRight()) {
            component.applyComponentOrientation(componentOrientation);
        }
    }

    public static int maxWidth(Component ... componentArray) {
        int n = 0;
        for (Component component : componentArray) {
            n = Math.max(n, component.getPreferredSize().width);
        }
        return n;
    }

    public static int maxHeight(Component ... componentArray) {
        int n = 0;
        for (Component component : componentArray) {
            n = Math.max(n, component.getPreferredSize().height);
        }
        return n;
    }

    public static Window getWindowAncestor(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            return (Window)container;
        }
        return null;
    }

    public static JRootPane getRootPaneAncestor(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JRootPane)) continue;
            return (JRootPane)container;
        }
        return null;
    }

    public static JRootPane getRootPane(Window window) {
        if (window instanceof JWindow) {
            return ((JWindow)window).getRootPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getRootPane();
        }
        if (window instanceof JFrame) {
            return ((JFrame)window).getRootPane();
        }
        return null;
    }

    public static <C extends JComponent> C setBorder(C c, int n) {
        return SwingUtils.setBorder(c, n, n, n, n);
    }

    public static <C extends JComponent> C setBorder(C c, int n, int n2, int n3, int n4) {
        return SwingUtils.setBorder(c, BorderFactory.createEmptyBorder(n, n2, n3, n4));
    }

    public static <C extends JComponent> C setBorder(C c, Border border) {
        c.setBorder(border);
        return c;
    }

    public static <C extends Component> C setPlainFont(C c) {
        if (c != null && c.getFont() != null) {
            c.setFont(c.getFont().deriveFont(0));
        }
        return c;
    }

    public static <C extends Component> C setBoldFont(C c) {
        if (c != null && c.getFont() != null) {
            c.setFont(c.getFont().deriveFont(1));
        }
        return c;
    }

    public static <C extends Component> C setItalicFont(C c) {
        if (c != null && c.getFont() != null) {
            c.setFont(c.getFont().deriveFont(2));
        }
        return c;
    }

    public static <C extends Component> C setFontSize(C c, int n) {
        if (c != null && c.getFont() != null) {
            c.setFont(c.getFont().deriveFont((float)n));
        }
        return c;
    }

    public static <C extends Component> C changeFontSize(C c, int n) {
        if (c != null && c.getFont() != null) {
            Font font = c.getFont();
            c.setFont(font.deriveFont((float)font.getSize() + (float)n));
        }
        return c;
    }

    public static <C extends Component> C setFontSizeAndStyle(C c, int n, int n2) {
        if (c != null && c.getFont() != null) {
            c.setFont(c.getFont().deriveFont(n2, n));
        }
        return c;
    }

    public static Dimension copy(Dimension dimension) {
        return new Dimension(dimension);
    }

    public static Point copy(Point point) {
        return new Point(point);
    }

    public static Insets copy(Insets insets) {
        return new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static Color copy(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Rectangle size(Component component) {
        return new Rectangle(0, 0, component.getWidth(), component.getHeight());
    }

    public static Insets max(Insets insets, Insets insets2) {
        return new Insets(Math.max(insets.top, insets2.top), Math.max(insets.left, insets2.left), Math.max(insets.bottom, insets2.bottom), Math.max(insets.right, insets2.right));
    }

    public static Insets min(Insets insets, Insets insets2) {
        return new Insets(Math.min(insets.top, insets2.top), Math.min(insets.left, insets2.left), Math.min(insets.bottom, insets2.bottom), Math.min(insets.right, insets2.right));
    }

    public static Dimension max(Component component, Component component2) {
        return SwingUtils.max(component.getPreferredSize(), component2.getPreferredSize());
    }

    public static Dimension max(Dimension dimension, Dimension dimension2) {
        if (dimension == null && dimension2 == null) {
            return null;
        }
        if (dimension == null) {
            return dimension2;
        }
        if (dimension2 == null) {
            return dimension;
        }
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public static Dimension min(Component component, Component component2) {
        return SwingUtils.min(component.getPreferredSize(), component2.getPreferredSize());
    }

    public static Dimension min(Dimension dimension, Dimension dimension2) {
        if (dimension == null || dimension2 == null) {
            return null;
        }
        return new Dimension(Math.min(dimension.width, dimension2.width), Math.min(dimension.height, dimension2.height));
    }

    public static void setOpaqueRecursively(Component component, boolean bl) {
        SwingUtils.setOpaqueRecursively(component, bl, false);
    }

    public static void setOpaqueRecursively(Component component, boolean bl, boolean bl2) {
        if (component instanceof JComponent) {
            Component[] componentArray = (Component[])component;
            if (!bl2) {
                componentArray.setOpaque(bl);
            }
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                SwingUtils.setOpaqueRecursively(component2, bl, false);
            }
        }
    }

    public static void setDoubleBufferedRecursively(Component component, boolean bl) {
        SwingUtils.setDoubleBufferedRecursively(component, bl, false);
    }

    public static void setDoubleBufferedRecursively(Component component, boolean bl, boolean bl2) {
        if (component instanceof JComponent) {
            Component[] componentArray = (Component[])component;
            if (!bl2) {
                componentArray.setDoubleBuffered(bl);
            }
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                SwingUtils.setDoubleBufferedRecursively(component2, bl, false);
            }
        }
    }

    public static void setEnabledRecursively(Component component, boolean bl) {
        SwingUtils.setEnabledRecursively(component, bl, false);
    }

    public static void setEnabledRecursively(Component component, boolean bl, boolean bl2) {
        if (!bl2) {
            component.setEnabled(bl);
        }
        if (component instanceof Container) {
            Object object;
            if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(HANDLES_ENABLE_STATE)) != null && ((Boolean)object).booleanValue() && !bl2) {
                return;
            }
            for (Component component2 : ((Container)component).getComponents()) {
                SwingUtils.setEnabledRecursively(component2, bl, false);
            }
        }
    }

    public static void setFocusableRecursively(JComponent jComponent, boolean bl) {
        SwingUtils.setFocusableRecursively(jComponent, bl, false);
    }

    public static void setFocusableRecursively(JComponent jComponent, boolean bl, boolean bl2) {
        if (!bl2) {
            jComponent.setFocusable(bl);
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            if (!(jComponent.getComponent(i) instanceof JComponent)) continue;
            SwingUtils.setFocusableRecursively((JComponent)jComponent.getComponent(i), bl, false);
        }
    }

    public static void setBackgroundRecursively(Component component, Color color) {
        SwingUtils.setBackgroundRecursively(component, color, false);
    }

    public static void setBackgroundRecursively(Component component, Color color, boolean bl) {
        if (!bl) {
            component.setBackground(color);
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                SwingUtils.setBackgroundRecursively(component2, color, false);
            }
        }
    }

    public static void setForegroundRecursively(JComponent jComponent, Color color) {
        SwingUtils.setForegroundRecursively(jComponent, color, false);
    }

    public static void setForegroundRecursively(JComponent jComponent, Color color, boolean bl) {
        if (!bl) {
            jComponent.setForeground(color);
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            if (!(jComponent.getComponent(i) instanceof JComponent)) continue;
            SwingUtils.setForegroundRecursively((JComponent)jComponent.getComponent(i), color, false);
        }
    }

    public static void setFontRecursively(JComponent jComponent, Font font) {
        SwingUtils.setFontRecursively(jComponent, font, false);
    }

    public static void setFontRecursively(JComponent jComponent, Font font, boolean bl) {
        if (!bl) {
            jComponent.setFont(font);
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            if (!(jComponent.getComponent(i) instanceof JComponent)) continue;
            SwingUtils.setFontRecursively((JComponent)jComponent.getComponent(i), font, false);
        }
    }

    public static BufferedImage createComponentSnapshot(Component component) {
        return SwingUtils.createComponentSnapshot(component, component.getWidth(), component.getHeight());
    }

    public static BufferedImage createComponentSnapshot(Component component, int n, int n2) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(n, n2, 3);
        if (component != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            component.setSize(n, n2);
            component.paintAll(graphics2D);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public static void setAccelerator(JMenuItem jMenuItem, HotkeyData hotkeyData) {
        if (hotkeyData.isHotkeySet()) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(hotkeyData.getKeyCode(), (hotkeyData.isCtrl() ? SwingUtils.getSystemShortcutModifier() : 0) | (hotkeyData.isAlt() ? 8 : 0) | (hotkeyData.isShift() ? 1 : 0)));
        }
    }

    public static Window getActiveWindow() {
        Window[] windowArray = Window.getWindows();
        Window window = null;
        for (Window window2 : windowArray) {
            if (!window2.isVisible() || !window2.isActive() || !window2.isFocused()) continue;
            window = window2;
            break;
        }
        return window;
    }

    public static boolean isShortcut(InputEvent inputEvent) {
        return (inputEvent.getModifiers() & SwingUtils.getSystemShortcutModifier()) != 0;
    }

    public static int getSystemShortcutModifier() {
        if (systemShortcutModifier == null) {
            systemShortcutModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        return systemShortcutModifier;
    }

    public static String hotkeyToString(KeyEvent keyEvent) {
        return SwingUtils.hotkeyToString(SwingUtils.isCtrl(keyEvent), SwingUtils.isAlt(keyEvent), SwingUtils.isShift(keyEvent), keyEvent.getKeyCode());
    }

    public static String hotkeyToString(HotkeyData hotkeyData) {
        return SwingUtils.hotkeyToString(hotkeyData.isCtrl(), hotkeyData.isAlt(), hotkeyData.isShift(), hotkeyData.getKeyCode());
    }

    public static String hotkeyToString(boolean bl, boolean bl2, boolean bl3, Integer n) {
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append(bl ? KeyEvent.getKeyModifiersText(SwingUtils.getSystemShortcutModifier()) + (bl2 || bl3 || n != null ? "+" : "") : "");
        stringBuilder.append(bl2 ? KeyEvent.getKeyModifiersText(8) + (bl3 || n != null ? "+" : "") : "");
        stringBuilder.append(bl3 ? KeyEvent.getKeyModifiersText(1) + (n != null ? "+" : "") : "");
        stringBuilder.append(n != null ? KeyEvent.getKeyText(n) : "");
        return stringBuilder.toString();
    }

    public static boolean isCtrl(InputEvent inputEvent) {
        return SwingUtils.isCtrl(inputEvent.getModifiers());
    }

    public static boolean isCtrl(int n) {
        return (n & 2) != 0;
    }

    public static boolean isAlt(InputEvent inputEvent) {
        return SwingUtils.isAlt(inputEvent.getModifiers());
    }

    public static boolean isAlt(int n) {
        return (n & 8) != 0;
    }

    public static boolean isShift(InputEvent inputEvent) {
        return SwingUtils.isShift(inputEvent.getModifiers());
    }

    public static boolean isShift(int n) {
        return (n & 1) != 0;
    }

    public static HotkeyData getHotkeyData(KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        return new HotkeyData(SwingUtils.isCtrl(n), SwingUtils.isAlt(n), SwingUtils.isShift(n), keyStroke.getKeyCode());
    }

    public static Font getDefaultLabelFont() {
        if (label == null) {
            label = new JLabel();
        }
        return label.getFont();
    }

    public static JScrollPane getScrollPane(Component component) {
        if (component != null && component.getParent() != null && component.getParent() instanceof JViewport && component.getParent().getParent() != null && component.getParent().getParent() instanceof JScrollPane) {
            return (JScrollPane)component.getParent().getParent();
        }
        return null;
    }

    public static Component findFocusableComponent(Container container) {
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy != null) {
            return focusTraversalPolicy.getFirstComponent(container);
        }
        for (Component component : container.getComponents()) {
            Component component2;
            if (component.isFocusable()) {
                return component;
            }
            if (!(component instanceof Container) || (component2 = SwingUtils.findFocusableComponent((Container)component)) == null) continue;
            return component2;
        }
        return null;
    }

    public static List<Component> findComponentsWithText(String string, Component component) {
        return SwingUtils.findComponentsWithText(string, component, new ArrayList<Component>());
    }

    public static List<Component> findComponentsWithText(String string, Component component, List<Component> list) {
        block34: {
            try {
                if (string == null || string.equals("")) {
                    return list;
                }
                if (component instanceof WebPathField || component instanceof WebFileChooserField || component instanceof WebDateField || component instanceof WebCalendar) {
                    for (Component component2 : ((Container)component).getComponents()) {
                        if (SwingUtils.findComponentsWithText(string, component2).size() <= 0) continue;
                        list.add(component);
                        break block34;
                    }
                    break block34;
                }
                if (component instanceof WebCollapsiblePane) {
                    if (SwingUtils.findComponentsWithText(string, ((WebCollapsiblePane)component).getHeaderPanel()).size() > 0) {
                        list.add(component);
                    }
                } else if (component instanceof JComboBox) {
                    JComboBox jComboBox = (JComboBox)component;
                    if (jComboBox.getSelectedItem().toString().toLowerCase().contains(string.toLowerCase())) {
                        list.add(component);
                    } else if (jComboBox.isEditable()) {
                        if (SwingUtils.findComponentsWithText(string, jComboBox.getEditor().getEditorComponent()).size() > 0) {
                            list.add(component);
                        }
                    } else if (SwingUtils.findComponentsWithText(string, jComboBox.getRenderer().getListCellRendererComponent(null, jComboBox.getSelectedItem(), -1, true, true)).size() > 0) {
                        list.add(component);
                    }
                } else if (component instanceof JSpinner) {
                    if (((JSpinner)component).getValue().toString().toLowerCase().contains(string.toLowerCase())) {
                        list.add(component);
                    }
                } else if (component instanceof JLabel) {
                    if (((JLabel)component).getText().toLowerCase().contains(string.toLowerCase())) {
                        list.add(component);
                    }
                } else if (component instanceof AbstractButton) {
                    if (((AbstractButton)component).getText().toLowerCase().contains(string.toLowerCase())) {
                        list.add(component);
                    }
                } else if (component instanceof JTextComponent) {
                    if (((JTextComponent)component).getText().toLowerCase().contains(string.toLowerCase())) {
                        if (component.getParent() != null && component.getParent().getParent() != null && component.getParent().getParent() instanceof JScrollPane) {
                            list.add(component.getParent().getParent());
                        } else {
                            list.add(component);
                        }
                    }
                } else if (component instanceof JTabbedPane) {
                    JTabbedPane jTabbedPane = (JTabbedPane)component;
                    for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                        if (!(jTabbedPane.getComponentAt(i) instanceof Container)) continue;
                        SwingUtils.checkContent(string, (Container)jTabbedPane.getComponentAt(i), list);
                    }
                } else if (component instanceof Container) {
                    SwingUtils.checkContent(string, (Container)component, list);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list;
    }

    private static void checkContent(String string, Container container, List<Component> list) {
        for (Component component : container.getComponents()) {
            SwingUtils.findComponentsWithText(string, component, list);
        }
    }

    public static Rectangle getBoundsInWindow(Component component) {
        return SwingUtils.getRelativeBounds(component, SwingUtils.getRootPaneAncestor(component));
    }

    public static Rectangle getRelativeBounds(Component component, Component component2) {
        return new Rectangle(SwingUtils.getRelativeLocation(component, component2), component.getSize());
    }

    public static Point getRelativeLocation(Component component, Component component2) {
        Point point = component.getLocationOnScreen();
        Point point2 = component2.getLocationOnScreen();
        return new Point(point.x - point2.x, point.y - point2.y);
    }

    public static boolean isSameAncestor(Component component, Component component2) {
        return SwingUtils.getWindowAncestor(component) == SwingUtils.getWindowAncestor(component2);
    }

    public static void equalizeComponentsSize(Component ... componentArray) {
        Dimension dimension = new Dimension(0, 0);
        for (Component component : componentArray) {
            if (component == null) continue;
            Dimension dimension2 = component.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
        }
        for (Component component : componentArray) {
            if (component == null) continue;
            component.setPreferredSize(dimension);
        }
    }

    public static void equalizeComponentsWidths(Component ... componentArray) {
        int n = 0;
        for (Component component : componentArray) {
            if (component == null) continue;
            n = Math.max(n, component.getPreferredSize().width);
        }
        for (Component component : componentArray) {
            if (component == null) continue;
            component.setPreferredSize(new Dimension(n, component.getPreferredSize().height));
        }
    }

    public static void equalizeComponentsHeights(Component ... componentArray) {
        int n = 0;
        for (Component component : componentArray) {
            if (component == null) continue;
            n = Math.max(n, component.getPreferredSize().height);
        }
        for (Component component : componentArray) {
            if (component == null) continue;
            component.setPreferredSize(new Dimension(component.getPreferredSize().width, n));
        }
    }

    public static boolean isEqualOrChild(Component component, Component component2) {
        if (component == component2) {
            return true;
        }
        if (component instanceof Container) {
            for (Component component3 : ((Container)component).getComponents()) {
                if (!SwingUtils.isEqualOrChild(component3, component2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean hasFocusOwner(Component component) {
        Component component2 = FocusManager.getCurrentManager().getFocusOwner();
        return component == component2 || component instanceof Container && ((Container)component).isAncestorOf(component2);
    }

    public static String[] getFontNames() {
        if (fontNames == null) {
            fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        return fontNames;
    }

    public static Font[] getFonts() {
        if (fonts == null) {
            fonts = SwingUtils.createFonts(SwingUtils.getFontNames());
        }
        return fonts;
    }

    public static Font[] createFonts(String[] stringArray) {
        Font[] fontArray = new Font[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fontArray[i] = new Font(stringArray[i], 0, 13);
        }
        return fontArray;
    }

    public static void delayInvokeLater(final long l, final Runnable runnable) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadUtils.sleepSafely(l);
                SwingUtilities.invokeLater(runnable);
            }
        }).start();
    }

    public static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeLater(final HotkeyRunnable hotkeyRunnable, final KeyEvent keyEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            hotkeyRunnable.run(keyEvent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    hotkeyRunnable.run(keyEvent);
                }
            });
        }
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    public static void invokeAndWaitSafely(Runnable runnable) {
        try {
            SwingUtils.invokeAndWait(runnable);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Insets toRTL(Insets insets) {
        return new Insets(insets.top, insets.right, insets.bottom, insets.left);
    }

    public static Point getMousePoint(Component component) {
        Point point = MouseInfo.getPointerInfo().getLocation();
        Point point2 = component.getLocationOnScreen();
        return new Point(point.x - point2.x, point.y - point2.y);
    }

    public static void scrollSmoothly(JScrollPane jScrollPane, int n, int n2) {
        final JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
        final JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
        Dimension dimension = jScrollPane.getViewport().getSize();
        n = n > jScrollBar.getMaximum() - dimension.width ? jScrollBar.getMaximum() - dimension.width : n;
        n2 = n2 > jScrollBar2.getMaximum() - dimension.height ? jScrollBar2.getMaximum() - dimension.height : n2;
        final int n3 = n < 0 ? 0 : n;
        final int n4 = n2 < 0 ? 0 : n2;
        final int n5 = jScrollBar.getValue() > n3 ? -1 : 1;
        final int n6 = jScrollBar2.getValue() > n4 ? -1 : 1;
        new Thread(new Runnable(){

            @Override
            public void run() {
                scrollThread1 = Thread.currentThread();
                int n = jScrollBar.getValue();
                while (n != n3) {
                    if (scrollThread1 != Thread.currentThread()) {
                        Thread.currentThread().interrupt();
                    }
                    if (n != n3) {
                        int n2;
                        n = n2 = n + n5 * Math.max(Math.abs(n - n3) / 4, 1);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jScrollBar.setValue(n2);
                            }
                        });
                        if (n5 < 0 && n2 == jScrollBar.getMinimum() || n5 > 0 && n2 == jScrollBar.getMaximum()) break;
                    }
                    ThreadUtils.sleepSafely(25L);
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                scrollThread2 = Thread.currentThread();
                int n = jScrollBar2.getValue();
                while (n != n4) {
                    if (scrollThread2 != Thread.currentThread()) {
                        Thread.currentThread().interrupt();
                    }
                    if (n != n4) {
                        int n2;
                        n = n2 = n + n6 * Math.max(Math.abs(n - n4) / 4, 1);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jScrollBar2.setValue(n2);
                            }
                        });
                        if (n6 < 0 && n2 == jScrollBar2.getMinimum() || n6 > 0 && n2 == jScrollBar2.getMaximum()) break;
                    }
                    ThreadUtils.sleepSafely(25L);
                }
            }
        }).start();
    }

    public static void packAndCenter(Window window) {
        SwingUtils.packAndCenter(window, StyleConstants.animate);
    }

    public static void packAndCenter(final Window window, boolean bl) {
        if (window == null) {
            return;
        }
        final Rectangle rectangle = window.getBounds();
        Dimension dimension = window.getPreferredSize();
        Rectangle rectangle2 = new Rectangle(rectangle.x + rectangle.width / 2 - dimension.width / 2, rectangle.y + rectangle.height / 2 - dimension.height / 2, dimension.width, dimension.height);
        if (windowPackTimers.containsKey(window) && windowPackTimers.get(window) != null && windowPackTimers.get(window).isRunning()) {
            windowPackTimers.get(window).stop();
        }
        if (window.isShowing() && bl) {
            final int n = rectangle2.width - rectangle.width;
            final int n2 = rectangle2.height - rectangle.height;
            Timer timer = new Timer(10L, new ActionListener(){
                int step = 1;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.step <= 10) {
                        int n3 = rectangle.width + n * this.step / 10;
                        int n22 = rectangle.height + n2 * this.step / 10;
                        Rectangle rectangle2 = new Rectangle(rectangle.x + rectangle.width / 2 - n3 / 2, rectangle.y + rectangle.height / 2 - n22 / 2, n3, n22);
                        window.setBounds(rectangle2);
                    } else {
                        ((Timer)windowPackTimers.get(window)).stop();
                    }
                    ++this.step;
                }
            });
            windowPackTimers.put(window, timer);
            timer.start();
        } else {
            window.setBounds(rectangle2);
        }
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        SwingUtils.drawString(jComponent, graphics, string, n2, n3);
        if (n >= 0 && n < string.length()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.fillRect(n2 + fontMetrics.stringWidth(string.substring(0, n)), n3 + fontMetrics.getDescent() - 1, fontMetrics.charWidth(string.charAt(n)), 1);
        }
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2) {
        graphics.drawString(string, n, n2);
    }

    public static Map setupTextAntialias(Graphics graphics, Component component) {
        return SwingUtils.setupTextAntialias((Graphics2D)graphics, component);
    }

    public static Map setupTextAntialias(Graphics2D graphics2D, Component component) {
        return SwingUtils.setupTextAntialias(graphics2D, component, StyleConstants.textRenderingHints);
    }

    public static Map setupTextAntialias(Graphics graphics, Component component, Map map) {
        return SwingUtils.setupTextAntialias((Graphics2D)graphics, component, map);
    }

    public static Map setupTextAntialias(Graphics2D graphics2D, Component component, Map map) {
        if (map != null) {
            Map map2 = SwingUtils.getRenderingHints(graphics2D, map, null);
            graphics2D.addRenderingHints(map);
            return map2;
        }
        return null;
    }

    public static void restoreTextAntialias(Graphics graphics, Map map) {
        SwingUtils.restoreTextAntialias((Graphics2D)graphics, map);
    }

    public static void restoreTextAntialias(Graphics2D graphics2D, Map map) {
        if (map != null) {
            graphics2D.addRenderingHints(map);
        }
    }

    private static Map getRenderingHints(Graphics2D graphics2D, Map map, Map map2) {
        if (map2 == null) {
            map2 = new RenderingHints(null);
        } else {
            map2.clear();
        }
        if (map == null || map.size() == 0) {
            return map2;
        }
        Set set = map.keySet();
        for (Object k : set) {
            RenderingHints.Key key = (RenderingHints.Key)k;
            Object object = graphics2D.getRenderingHint(key);
            if (object == null) continue;
            map2.put(key, object);
        }
        return map2;
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics) {
        return SwingUtils.getFontMetrics(jComponent, graphics, graphics.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics, Font font) {
        if (jComponent != null) {
            return jComponent.getFontMetrics(font);
        }
        return graphics.getFontMetrics(font);
    }

    public static int stringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        return fontMetrics.stringWidth(string);
    }

    public static int getLeftSideBearing(JComponent jComponent, FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return SwingUtils.getLeftSideBearing(jComponent, fontMetrics, string.charAt(0));
    }

    public static int getLeftSideBearing(JComponent jComponent, FontMetrics fontMetrics, char c) {
        return SwingUtils.getBearing(jComponent, fontMetrics, c, true);
    }

    public static int getRightSideBearing(JComponent jComponent, FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return SwingUtils.getRightSideBearing(jComponent, fontMetrics, string.charAt(string.length() - 1));
    }

    public static int getRightSideBearing(JComponent jComponent, FontMetrics fontMetrics, char c) {
        return SwingUtils.getBearing(jComponent, fontMetrics, c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getBearing(JComponent jComponent, FontMetrics fontMetrics, char c, boolean bl) {
        if (fontMetrics == null) {
            if (jComponent == null) {
                return 0;
            }
            fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        }
        Class<SwingUtils> clazz = SwingUtils.class;
        synchronized (SwingUtils.class) {
            BearingCacheEntry bearingCacheEntry = null;
            BearingCacheEntry bearingCacheEntry2 = new BearingCacheEntry(fontMetrics);
            for (BearingCacheEntry bearingCacheEntry3 : strongBearingCache) {
                if (!bearingCacheEntry2.equals(bearingCacheEntry3)) continue;
                bearingCacheEntry = bearingCacheEntry3;
                break;
            }
            if (bearingCacheEntry == null) {
                Iterator<SoftReference<BearingCacheEntry>> iterator = softBearingCache.iterator();
                while (iterator.hasNext()) {
                    BearingCacheEntry bearingCacheEntry4 = (BearingCacheEntry)((SoftReference)iterator.next()).get();
                    if (bearingCacheEntry4 == null) {
                        iterator.remove();
                        continue;
                    }
                    if (!bearingCacheEntry2.equals(bearingCacheEntry4)) continue;
                    bearingCacheEntry = bearingCacheEntry4;
                    SwingUtils.putEntryInStrongCache(bearingCacheEntry);
                    break;
                }
            }
            if (bearingCacheEntry == null) {
                bearingCacheEntry = bearingCacheEntry2;
                SwingUtils.cacheEntry(bearingCacheEntry);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return bl ? bearingCacheEntry.getLeftSideBearing(c) : bearingCacheEntry.getRightSideBearing(c);
        }
    }

    private static synchronized void cacheEntry(BearingCacheEntry bearingCacheEntry) {
        BearingCacheEntry bearingCacheEntry2 = strongBearingCache[strongBearingCacheNextIndex];
        if (bearingCacheEntry2 != null) {
            softBearingCache.add(new SoftReference<BearingCacheEntry>(bearingCacheEntry2));
        }
        SwingUtils.putEntryInStrongCache(bearingCacheEntry);
    }

    private static synchronized void putEntryInStrongCache(BearingCacheEntry bearingCacheEntry) {
        SwingUtils.strongBearingCache[SwingUtils.strongBearingCacheNextIndex] = bearingCacheEntry;
        strongBearingCacheNextIndex = (strongBearingCacheNextIndex + 1) % 10;
    }

    static {
        windowPackTimers = new HashMap<Window, Timer>();
        strongBearingCache = new BearingCacheEntry[10];
        strongBearingCacheNextIndex = 0;
        softBearingCache = new HashSet<SoftReference<BearingCacheEntry>>();
    }

    private static class BearingCacheEntry {
        private FontMetrics fontMetrics;
        private Font font;
        private FontRenderContext frc;
        private Map<Character, Short> cache;
        private static final char[] oneChar = new char[1];

        public BearingCacheEntry(FontMetrics fontMetrics) {
            this.fontMetrics = fontMetrics;
            this.font = fontMetrics.getFont();
            this.frc = fontMetrics.getFontRenderContext();
            this.cache = new HashMap<Character, Short>();
            assert (this.font != null && this.frc != null);
        }

        public int getLeftSideBearing(char c) {
            Short s = this.cache.get(Character.valueOf(c));
            if (s == null) {
                s = this.calcBearing(c);
                this.cache.put(Character.valueOf(c), s);
            }
            return ((0xFF00 & s) >>> 8) - 127;
        }

        public int getRightSideBearing(char c) {
            Short s = this.cache.get(Character.valueOf(c));
            if (s == null) {
                s = this.calcBearing(c);
                this.cache.put(Character.valueOf(c), s);
            }
            return (0xFF & s) - 127;
        }

        private short calcBearing(char c) {
            Object object;
            BearingCacheEntry.oneChar[0] = c;
            GlyphVector glyphVector = this.font.createGlyphVector(this.frc, oneChar);
            Rectangle rectangle = glyphVector.getGlyphPixelBounds(0, this.frc, 0.0f, 0.0f);
            int n = rectangle.x;
            int n2 = rectangle.width - this.fontMetrics.charWidth(c);
            if (n < 0 && ((object = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || object == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                ++n;
            }
            if (n2 > 0 && ((object = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || object == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                --n2;
            }
            if (n < -127 || n > 127) {
                n = 0;
            }
            if (n2 < -127 || n2 > 127) {
                n2 = 0;
            }
            int n3 = (n + 127 << 8) + (n2 + 127);
            return (short)n3;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof BearingCacheEntry)) {
                return false;
            }
            BearingCacheEntry bearingCacheEntry = (BearingCacheEntry)object;
            return this.font.equals(bearingCacheEntry.font) && this.frc.equals(bearingCacheEntry.frc);
        }

        public int hashCode() {
            int n = 17;
            if (this.font != null) {
                n = 37 * n + this.font.hashCode();
            }
            if (this.frc != null) {
                n = 37 * n + this.frc.hashCode();
            }
            return n;
        }
    }
}

