/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.zip.UnzipListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtils {
    public static boolean unzip(String string, String string2) {
        return ZipUtils.unzip(string, string2, null);
    }

    public static boolean unzip(String string, String string2, UnzipListener unzipListener) {
        return ZipUtils.unzip(new File(string), new File(string2), unzipListener);
    }

    public static boolean unzip(File file, File file2) {
        return ZipUtils.unzip(file, file2, null);
    }

    public static boolean unzip(File file, File file2, UnzipListener unzipListener) {
        try {
            ZipFile zipFile = new ZipFile(file);
            if (unzipListener != null) {
                unzipListener.sizeDetermined(zipFile.size());
            }
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                File file3;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    file3 = new File(file2, zipEntry.getName());
                    file3.mkdirs();
                } else {
                    file3 = new File(file2, zipEntry.getName());
                    file3.getParentFile().mkdirs();
                    file3.createNewFile();
                    ZipUtils.copyInputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(file3)));
                }
                if (unzipListener == null) continue;
                unzipListener.fileUnzipped(zipEntry, file3, n);
                ++n;
            }
            zipFile.close();
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private static void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }
}

