/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.ninepatch;

import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Rectangle;
import java.io.Serializable;

@XStreamAlias(value="NinePatchInterval")
public final class NinePatchInterval
implements Serializable,
Cloneable {
    public static final String ID_PREFIX = "NPI";
    @XStreamAsAttribute
    private transient String id;
    @XStreamAsAttribute
    private boolean pixel;
    @XStreamAsAttribute
    private int start;
    @XStreamAsAttribute
    private int end;

    public NinePatchInterval() {
        this(0);
    }

    public NinePatchInterval(int n) {
        this(n, n);
    }

    public NinePatchInterval(int n, boolean bl) {
        this(n, n, bl);
    }

    public NinePatchInterval(int n, int n2) {
        this(n, n2, true);
    }

    public NinePatchInterval(int n, int n2, boolean bl) {
        this.setId();
        this.setPixel(bl);
        this.setStart(n);
        this.setEnd(n2);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setId() {
        this.id = TextUtils.generateId(ID_PREFIX);
    }

    public boolean isPixel() {
        return this.pixel;
    }

    public void setPixel(boolean bl) {
        this.pixel = bl;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public boolean intersects(NinePatchInterval ninePatchInterval) {
        return new Rectangle(this.getStart(), 0, this.getEnd() - this.getStart(), 1).intersects(new Rectangle(ninePatchInterval.getStart(), 0, ninePatchInterval.getEnd() - ninePatchInterval.getStart(), 1));
    }

    public NinePatchInterval clone() {
        NinePatchInterval ninePatchInterval = new NinePatchInterval();
        ninePatchInterval.setId(this.getId());
        ninePatchInterval.setPixel(this.isPixel());
        ninePatchInterval.setStart(this.getStart());
        ninePatchInterval.setEnd(this.getEnd());
        return ninePatchInterval;
    }

    public boolean isSame(NinePatchInterval ninePatchInterval) {
        return ninePatchInterval != null && this.getId().equals(ninePatchInterval.getId());
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NinePatchInterval) {
            NinePatchInterval ninePatchInterval = (NinePatchInterval)object;
            return this.isPixel() == ninePatchInterval.isPixel() && this.getStart() == ninePatchInterval.getStart() && this.getEnd() == ninePatchInterval.getEnd();
        }
        return false;
    }
}

