/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.collection.ValuesTable;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ColorConverter
extends AbstractSingleValueConverter {
    private static ValuesTable<String, Color> defaultColors = new ValuesTable();

    @Override
    public boolean canConvert(Class clazz) {
        return clazz.equals(Color.class);
    }

    @Override
    public Object fromString(String string) {
        if (defaultColors.containsKey(string)) {
            return defaultColors.get(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.replaceAll(" ", ""), ",");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                arrayList.add(Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (arrayList.size() == 3) {
            return new Color((Integer)arrayList.get(0), (Integer)arrayList.get(1), (Integer)arrayList.get(2));
        }
        if (arrayList.size() == 4) {
            return new Color((Integer)arrayList.get(0), (Integer)arrayList.get(1), (Integer)arrayList.get(2), (Integer)arrayList.get(3));
        }
        return null;
    }

    @Override
    public String toString(Object object) {
        Color color = (Color)object;
        if (defaultColors.containsValue(color)) {
            return defaultColors.getKey(color);
        }
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue() + (color.getAlpha() < 255 ? "," + color.getAlpha() : "");
    }

    static {
        defaultColors.put("black", Color.BLACK);
        defaultColors.put("white", Color.WHITE);
        defaultColors.put("red", Color.RED);
        defaultColors.put("green", Color.GREEN);
        defaultColors.put("blue", Color.BLUE);
        defaultColors.put("lightGray", Color.LIGHT_GRAY);
        defaultColors.put("gray", Color.GRAY);
        defaultColors.put("darkGray", Color.DARK_GRAY);
        defaultColors.put("pink", Color.PINK);
        defaultColors.put("orange", Color.ORANGE);
        defaultColors.put("yellow", Color.YELLOW);
        defaultColors.put("magenta", Color.MAGENTA);
        defaultColors.put("cyan", Color.CYAN);
    }
}

