/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizontalFlowLayout
implements LayoutManager {
    private int horizGap;
    private boolean fillLast;

    public HorizontalFlowLayout() {
        this(2);
    }

    public HorizontalFlowLayout(int n) {
        this(n, false);
    }

    public HorizontalFlowLayout(int n, boolean bl) {
        this.horizGap = n;
        this.fillLast = bl;
    }

    public int getHorizontalGap() {
        return this.horizGap;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    private Dimension getLayoutSize(Container container, boolean bl) {
        int n = container.getComponentCount();
        Dimension dimension = new Dimension(0, 0);
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
            dimension.height = Math.max(dimension2.height, dimension.height);
            dimension.width += dimension2.width;
            if (i == 0) continue;
            dimension.width += this.getHorizontalGap();
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension = this.preferredLayoutSize(container);
        Dimension dimension2 = new Dimension(dimension.width, container.getSize().height);
        boolean bl = container.getComponentOrientation().isLeftToRight();
        Insets insets = container.getInsets();
        int n = bl ? insets.left : insets.right;
        int n2 = bl ? insets.right : insets.left;
        boolean bl2 = dimension.width < dimension2.width;
        int n3 = n;
        int n4 = insets.top;
        int n5 = Math.max(dimension2.height, dimension.height) - insets.top - insets.bottom;
        int n6 = dimension2.width - dimension.width;
        int n7 = container.getComponentCount();
        for (int i = 0; i < n7; ++i) {
            int n8;
            int n9;
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            int n10 = n9 = bl2 ? component.getMinimumSize().width : component.getPreferredSize().width;
            if (n6 > 0) {
                n9 += n9 * n6 / dimension.width;
            }
            int n11 = n8 = this.fillLast && i == n7 - 1 && container.getWidth() - n3 - n2 > 0 ? container.getWidth() - n3 - n2 : n9;
            if (bl) {
                component.setBounds(n3, n4, n8, n5);
            } else {
                component.setBounds(container.getWidth() - n3 - n8, n4, n8, n5);
            }
            n3 += n9 + this.getHorizontalGap();
        }
    }
}

