/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileListModel;
import com.alee.extended.list.FileViewType;
import com.alee.extended.list.WebFileListCellEditor;
import com.alee.extended.list.WebFileListCellRenderer;
import com.alee.extended.list.WebFileListStyle;
import com.alee.laf.list.WebList;
import com.alee.laf.list.editor.ListCellEditor;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.utils.FileUtils;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import javax.swing.ListModel;

public class WebFileList
extends WebList {
    private boolean generateThumbnails = WebFileListStyle.generateThumbnails;
    private int preferredColumnCount = WebFileListStyle.preferredColumnCount;
    private int preferredRowCount = WebFileListStyle.preferredRowCount;
    private FileViewType fileViewType = WebFileListStyle.fileViewType;
    private FileFilter fileFilter = WebFileListStyle.fileFilter;
    private File displayedDirectory = null;
    private WebScrollPane scrollView = null;

    public WebFileList() {
        super((ListModel)new FileListModel());
        this.initializeDefaultSettings();
    }

    public WebFileList(String string) {
        super((ListModel)new FileListModel(string));
        this.initializeDefaultSettings();
    }

    public WebFileList(File file) {
        super((ListModel)new FileListModel(file));
        this.initializeDefaultSettings();
    }

    public WebFileList(File[] fileArray) {
        super((ListModel)new FileListModel(fileArray));
        this.initializeDefaultSettings();
    }

    public WebFileList(List<File> list) {
        super((ListModel)new FileListModel(list));
        this.initializeDefaultSettings();
    }

    protected void initializeDefaultSettings() {
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(0);
        this.setCellRenderer(new WebFileListCellRenderer(this));
    }

    public WebFileListCellRenderer getWebFileListCellRenderer() throws ClassCastException {
        return (WebFileListCellRenderer)this.getCellRenderer();
    }

    public FileListModel getFileListModel() throws ClassCastException {
        return (FileListModel)this.getModel();
    }

    @Override
    protected ListCellEditor createDefaultCellEditor() {
        return new WebFileListCellEditor();
    }

    public void setPreferredColumnCount(int n) {
        this.preferredColumnCount = n;
    }

    public int getPreferredColumnCount() {
        return this.preferredColumnCount;
    }

    public int getPreferredRowCount() {
        return this.preferredRowCount;
    }

    public void setPreferredRowCount(int n) {
        this.preferredRowCount = n;
    }

    public boolean isGenerateThumbnails() {
        return this.generateThumbnails;
    }

    public void setGenerateThumbnails(boolean bl) {
        this.generateThumbnails = bl;
    }

    public FileViewType getFileViewType() {
        return this.fileViewType;
    }

    public void setFileViewType(FileViewType fileViewType) {
        this.fileViewType = fileViewType;
        this.getWebFileListCellRenderer().updateFilesView();
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.setDisplayedDirectory(this.getDisplayedDirectory());
    }

    public File getDisplayedDirectory() {
        return this.displayedDirectory;
    }

    public void setDisplayedDirectory(File file) {
        Object[] objectArray = this.getSelectedValues();
        File[] fileArray = file != null ? FileUtils.sortFiles(file.listFiles(this.fileFilter)) : FileUtils.getDiskRoots();
        this.getFileListModel().setData(fileArray);
        if (FileUtils.equals(this.displayedDirectory, file)) {
            this.clearSelection();
            FileListModel fileListModel = this.getFileListModel();
            if (objectArray != null && objectArray.length > 0 && fileListModel != null) {
                for (Object object : objectArray) {
                    int n = fileListModel.indexOf((FileElement)object);
                    if (n == -1) continue;
                    this.addSelectionInterval(n, n);
                }
            }
        } else {
            this.displayedDirectory = file;
            this.clearSelection();
        }
    }

    public WebScrollPane getScrollView() {
        if (this.scrollView == null) {
            this.scrollView = this.createScrollView();
        }
        return this.scrollView;
    }

    public WebScrollPane createScrollView() {
        return new WebScrollPane(this){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (WebFileList.this.getModel().getSize() > 0) {
                    Insets insets = this.getInsets();
                    Dimension dimension2 = WebFileList.this.getCellBounds(0, 0).getSize();
                    dimension.width = dimension2.width * WebFileList.this.preferredColumnCount + insets.left + insets.right + 13 + 1;
                    dimension.height = dimension2.height * WebFileList.this.preferredRowCount + insets.top + insets.bottom + 1;
                }
                return dimension;
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getModel().getSize() > 0) {
            Dimension dimension2 = this.getCellBounds(0, 0).getSize();
            dimension.width = dimension2.width * this.preferredColumnCount;
        }
        return dimension;
    }

    public void repaint(FileElement fileElement) {
        this.repaint(this.getFileListModel().indexOf(fileElement));
    }
}

