/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.painter.Painter;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebButtonUI;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.swing.UnselectableButtonGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebButtonGroup
extends WebPanel
implements SwingConstants {
    private int orientation;
    private UnselectableButtonGroup buttonGroup;

    public WebButtonGroup(JComponent ... jComponentArray) {
        this(0, jComponentArray);
    }

    public WebButtonGroup(boolean bl, JComponent ... jComponentArray) {
        this(0, bl, jComponentArray);
    }

    public WebButtonGroup(int n, JComponent ... jComponentArray) {
        this(n, false, jComponentArray);
    }

    public WebButtonGroup(int n, boolean bl, JComponent ... jComponentArray) {
        this.putClientProperty("HANDLES_ENABLE_STATE", true);
        this.setOpaque(false);
        this.setOrientation(n);
        if (jComponentArray != null) {
            for (JComponent jComponent : jComponentArray) {
                if (jComponent == null) continue;
                this.add((Component)jComponent);
                if (!bl) continue;
                if (this.isButton(jComponent)) {
                    this.getButtonGroup().add((AbstractButton)jComponent);
                    continue;
                }
                if (!this.isWebButtonGroup(jComponent)) continue;
                WebButtonGroup webButtonGroup = (WebButtonGroup)jComponent;
                for (Component component : webButtonGroup.getComponents()) {
                    if (!this.isButton(component)) continue;
                    this.getButtonGroup().add((AbstractButton)component);
                }
            }
        }
        this.updateButtons();
    }

    public WebButton getWebButton(int n) {
        return (WebButton)this.getComponent(n);
    }

    public WebButton getWebButton(String string) {
        for (Component component : this.getComponents()) {
            if (!component.getName().equals(string)) continue;
            return (WebButton)component;
        }
        return null;
    }

    public boolean isAnySelected() {
        return this.buttonGroup.getSelection() != null && this.buttonGroup.getSelection().isSelected();
    }

    public UnselectableButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new UnselectableButtonGroup();
            this.buttonGroup.setUnselectable(false);
        }
        return this.buttonGroup;
    }

    public boolean isUnselectable() {
        return this.getButtonGroup().isUnselectable();
    }

    public void setUnselectable(boolean bl) {
        this.getButtonGroup().setUnselectable(bl);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        boolean bl = n == 0;
        this.setLayout(bl ? new HorizontalFlowLayout(0, false) : new VerticalFlowLayout(0, 0, 0, true, false));
        this.updateButtons();
    }

    public void updateButtons() {
        Component[] componentArray = this.getComponents();
        boolean bl = this.orientation == 0;
        boolean bl2 = false;
        for (int i = 0; i < componentArray.length; ++i) {
            SwingConstants swingConstants;
            if (this.isWebStyledButton(componentArray[i])) {
                swingConstants = (WebButtonUI)((AbstractButton)componentArray[i]).getUI();
                if (bl2) {
                    if (bl) {
                        ((WebButtonUI)swingConstants).setDrawLeft(false);
                        ((WebButtonUI)swingConstants).setDrawLeftLine(false);
                    } else {
                        ((WebButtonUI)swingConstants).setDrawTop(false);
                        ((WebButtonUI)swingConstants).setDrawTopLine(false);
                    }
                }
                if (i < componentArray.length - 1 && this.isWebStyledButton(componentArray[i + 1])) {
                    if (bl) {
                        ((WebButtonUI)swingConstants).setDrawRight(false);
                        ((WebButtonUI)swingConstants).setDrawRightLine(true);
                    } else {
                        ((WebButtonUI)swingConstants).setDrawBottom(false);
                        ((WebButtonUI)swingConstants).setDrawBottomLine(true);
                    }
                }
                bl2 = true;
                continue;
            }
            if (this.isWebButtonGroup(componentArray[i])) {
                WebButtonUI webButtonUI;
                swingConstants = (WebButtonGroup)componentArray[i];
                if (bl2) {
                    for (Component component : ((Container)((Object)swingConstants)).getComponents()) {
                        if (!this.isWebStyledButton(component)) continue;
                        webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                        if (bl) {
                            webButtonUI.setDrawLeft(false);
                            webButtonUI.setDrawLeftLine(false);
                            continue;
                        }
                        webButtonUI.setDrawTop(false);
                        webButtonUI.setDrawTopLine(false);
                    }
                }
                if (i < componentArray.length - 1 && this.isWebButtonGroup(componentArray[i + 1])) {
                    for (Component component : ((Container)((Object)swingConstants)).getComponents()) {
                        if (!this.isWebStyledButton(component)) continue;
                        webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                        if (bl) {
                            webButtonUI.setDrawRight(false);
                            webButtonUI.setDrawRightLine(true);
                            continue;
                        }
                        webButtonUI.setDrawBottom(false);
                        webButtonUI.setDrawBottomLine(true);
                    }
                }
                bl2 = true;
                continue;
            }
            bl2 = false;
        }
    }

    private void restoreSides(boolean bl, WebButtonUI webButtonUI) {
        if (this.getParent() instanceof WebButtonGroup) {
            if (bl) {
                webButtonUI.setDrawLeft(true);
                webButtonUI.setDrawLeftLine(false);
                webButtonUI.setDrawRight(true);
                webButtonUI.setDrawRightLine(false);
            } else {
                webButtonUI.setDrawTop(true);
                webButtonUI.setDrawTopLine(false);
                webButtonUI.setDrawBottom(true);
                webButtonUI.setDrawBottomLine(false);
            }
        } else {
            webButtonUI.setDrawSides(true, true, true, true);
            webButtonUI.setDrawLines(false, false, false, false);
        }
    }

    private boolean isWebStyledButton(Component component) {
        return this.isButton(component) && ((AbstractButton)component).getUI() instanceof WebButtonUI;
    }

    private boolean isButton(Component component) {
        return component instanceof AbstractButton;
    }

    private boolean isWebButtonGroup(Component component) {
        return component instanceof WebButtonGroup;
    }

    public void setButtonsFocusable(boolean bl) {
        this.setFocusable(this, bl);
    }

    private void setFocusable(WebButtonGroup webButtonGroup, boolean bl) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebButtonGroup(component)) {
                this.setFocusable((WebButtonGroup)component, bl);
                continue;
            }
            component.setFocusable(bl);
        }
    }

    public void setButtonsForeground(Color color) {
        this.setForeground(this, color);
    }

    private void setForeground(WebButtonGroup webButtonGroup, Color color) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebButtonGroup(component)) {
                this.setForeground((WebButtonGroup)component, color);
                continue;
            }
            component.setForeground(color);
        }
    }

    public void setButtonsSelectedForeground(Color color) {
        this.setSelectedForeground(this, color);
    }

    private void setSelectedForeground(WebButtonGroup webButtonGroup, Color color) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setSelectedForeground(color);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setSelectedForeground((WebButtonGroup)component, color);
        }
    }

    public void setButtonsDrawTop(boolean bl) {
        this.setDrawTop(this, bl);
    }

    private void setDrawTop(WebButtonGroup webButtonGroup, boolean bl) {
        if (this.orientation == 0) {
            for (Component component : webButtonGroup.getComponents()) {
                this.setDrawTop(component, bl);
            }
        } else {
            this.setDrawTop(this.getFirstComponent(), bl);
        }
    }

    private void setDrawTop(Component component, boolean bl) {
        if (this.isWebStyledButton(component)) {
            WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
            webButtonUI.setDrawTop(bl);
        } else if (this.isWebButtonGroup(component)) {
            this.setDrawTop((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsDrawLeft(boolean bl) {
        this.setDrawLeft(this, bl);
    }

    private void setDrawLeft(WebButtonGroup webButtonGroup, boolean bl) {
        if (this.orientation == 1) {
            for (Component component : webButtonGroup.getComponents()) {
                this.setDrawLeft(component, bl);
            }
        } else {
            this.setDrawLeft(this.getFirstComponent(), bl);
        }
    }

    private void setDrawLeft(Component component, boolean bl) {
        if (this.isWebStyledButton(component)) {
            WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
            webButtonUI.setDrawLeft(bl);
        } else if (this.isWebButtonGroup(component)) {
            this.setDrawLeft((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsDrawBottom(boolean bl) {
        this.setDrawBottom(this, bl);
    }

    private void setDrawBottom(WebButtonGroup webButtonGroup, boolean bl) {
        if (this.orientation == 0) {
            for (Component component : webButtonGroup.getComponents()) {
                this.setDrawBottom(component, bl);
            }
        } else {
            this.setDrawBottom(this.getLastComponent(), bl);
        }
    }

    private void setDrawBottom(Component component, boolean bl) {
        if (this.isWebStyledButton(component)) {
            WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
            webButtonUI.setDrawBottom(bl);
        } else if (this.isWebButtonGroup(component)) {
            this.setDrawBottom((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsDrawRight(boolean bl) {
        this.setDrawRight(this, bl);
    }

    private void setDrawRight(WebButtonGroup webButtonGroup, boolean bl) {
        if (this.orientation == 1) {
            for (Component component : webButtonGroup.getComponents()) {
                this.setDrawRight(component, bl);
            }
        } else {
            this.setDrawRight(this.getLastComponent(), bl);
        }
    }

    private void setDrawRight(Component component, boolean bl) {
        if (this.isWebStyledButton(component)) {
            WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
            webButtonUI.setDrawRight(bl);
        } else if (this.isWebButtonGroup(component)) {
            this.setDrawRight((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsDrawSides(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setButtonsDrawTop(bl);
        this.setButtonsDrawLeft(bl2);
        this.setButtonsDrawBottom(bl3);
        this.setButtonsDrawRight(bl4);
    }

    public void setButtonsRolloverDarkBorderOnly(boolean bl) {
        this.setRolloverDarkBorderOnly(this, bl);
    }

    private void setRolloverDarkBorderOnly(WebButtonGroup webButtonGroup, boolean bl) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setRolloverDarkBorderOnly(bl);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setRolloverDarkBorderOnly((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsRolloverShine(boolean bl) {
        this.setRolloverShine(this, bl);
    }

    private void setRolloverShine(WebButtonGroup webButtonGroup, boolean bl) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setRolloverShine(bl);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setRolloverShine((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsShineColor(Color color) {
        this.setShineColor(this, color);
    }

    private void setShineColor(WebButtonGroup webButtonGroup, Color color) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setShineColor(color);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setShineColor((WebButtonGroup)component, color);
        }
    }

    public void setButtonsRound(int n) {
        this.setRound(this, n);
    }

    private void setRound(WebButtonGroup webButtonGroup, int n) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setRound(n);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setRound((WebButtonGroup)component, n);
        }
    }

    public void setButtonsRolloverShadeOnly(boolean bl) {
        this.setRolloverShadeOnly(this, bl);
    }

    private void setRolloverShadeOnly(WebButtonGroup webButtonGroup, boolean bl) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setRolloverShadeOnly(bl);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setRolloverShadeOnly((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsShadeWidth(int n) {
        this.setShadeWidth(this, n);
    }

    private void setShadeWidth(WebButtonGroup webButtonGroup, int n) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setShadeWidth(n);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setShadeWidth((WebButtonGroup)component, n);
        }
    }

    public void setButtonsShadeColor(Color color) {
        this.setShadeColor(this, color);
    }

    private void setShadeColor(WebButtonGroup webButtonGroup, Color color) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setShadeColor(color);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setShadeColor((WebButtonGroup)component, color);
        }
    }

    public void setButtonsInnerShadeWidth(int n) {
        this.setInnerShadeWidth(this, n);
    }

    private void setInnerShadeWidth(WebButtonGroup webButtonGroup, int n) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setInnerShadeWidth(n);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setInnerShadeWidth((WebButtonGroup)component, n);
        }
    }

    public void setButtonsInnerShadeColor(Color color) {
        this.setInnerShadeColor(this, color);
    }

    private void setInnerShadeColor(WebButtonGroup webButtonGroup, Color color) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setInnerShadeColor(color);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setInnerShadeColor((WebButtonGroup)component, color);
        }
    }

    public void setButtonsLeftRightSpacing(int n) {
        this.setLeftRightSpacing(this, n);
    }

    private void setLeftRightSpacing(WebButtonGroup webButtonGroup, int n) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setLeftRightSpacing(n);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setLeftRightSpacing((WebButtonGroup)component, n);
        }
    }

    public void setButtonsRolloverDecoratedOnly(boolean bl) {
        this.setRolloverDecoratedOnly(this, bl);
    }

    private void setRolloverDecoratedOnly(WebButtonGroup webButtonGroup, boolean bl) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setRolloverDecoratedOnly(bl);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setRolloverDecoratedOnly((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsUndecorated(boolean bl) {
        this.setUndecorated(this, bl);
    }

    private void setUndecorated(WebButtonGroup webButtonGroup, boolean bl) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setUndecorated(bl);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setUndecorated((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsPainter(Painter painter) {
        this.setPainter(this, painter);
    }

    private void setPainter(WebButtonGroup webButtonGroup, Painter painter) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setPainter(painter);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setPainter((WebButtonGroup)component, painter);
        }
    }

    public void setButtonsMoveIconOnPress(boolean bl) {
        this.setMoveIconOnPress(this, bl);
    }

    private void setMoveIconOnPress(WebButtonGroup webButtonGroup, boolean bl) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setMoveIconOnPress(bl);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setMoveIconOnPress((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsDrawFocus(boolean bl) {
        this.setDrawFocus(this, bl);
    }

    private void setDrawFocus(WebButtonGroup webButtonGroup, boolean bl) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setDrawFocus(bl);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setDrawFocus((WebButtonGroup)component, bl);
        }
    }

    public void setButtonsMargin(Insets insets) {
        this.setMargin(this, insets);
    }

    public void setButtonsMargin(int n, int n2, int n3, int n4) {
        this.setButtonsMargin(new Insets(n, n2, n3, n4));
    }

    public void setButtonsMargin(int n) {
        this.setButtonsMargin(n, n, n, n);
    }

    private void setMargin(WebButtonGroup webButtonGroup, Insets insets) {
        for (Component component : webButtonGroup.getComponents()) {
            if (this.isWebStyledButton(component)) {
                WebButtonUI webButtonUI = (WebButtonUI)((AbstractButton)component).getUI();
                webButtonUI.setMargin(insets);
                continue;
            }
            if (!this.isWebButtonGroup(component)) continue;
            this.setMargin((WebButtonGroup)component, insets);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (Component component : this.getComponents()) {
            component.setEnabled(bl);
        }
    }
}

