/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects.zoom;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.TransitionUtils;
import com.alee.extended.transition.effects.DefaultTransitionEffect;
import com.alee.extended.transition.effects.zoom.ZoomType;
import com.alee.utils.LafUtils;
import java.awt.Composite;
import java.awt.Graphics2D;

public class ZoomTransitionEffect
extends DefaultTransitionEffect {
    private static final String ZOOM_MINIMUM_SPEED = "ZOOM_MINIMUM_SPEED";
    private static final String ZOOM_SPEED = "ZOOM_SPEED";
    private static final String ZOOM_FADE = "ZOOM_FADE";
    private static final String ZOOM_TYPE = "ZOOM_TYPE";
    private float minimumSpeed;
    private float speed;
    private ZoomType type;
    private float size;

    public float getMinimumSpeed() {
        return this.get(ZOOM_MINIMUM_SPEED, Float.valueOf(0.02f)).floatValue();
    }

    public void setMinimumSpeed(float f) {
        this.put(ZOOM_MINIMUM_SPEED, Float.valueOf(f));
    }

    public float getSpeed() {
        return this.get(ZOOM_SPEED, Float.valueOf(0.1f)).floatValue();
    }

    public void setSpeed(float f) {
        this.put(ZOOM_SPEED, Float.valueOf(f));
    }

    public boolean isFade() {
        return this.get(ZOOM_FADE, true);
    }

    public void setFade(boolean bl) {
        this.put(ZOOM_FADE, bl);
    }

    public ZoomType getType() {
        return this.get(ZOOM_TYPE, ZoomType.random);
    }

    public void setType(ZoomType zoomType) {
        this.put(ZOOM_TYPE, (Object)zoomType);
    }

    @Override
    public void prepareAnimation(ImageTransition imageTransition) {
        this.minimumSpeed = this.getMinimumSpeed();
        this.speed = this.getSpeed();
        this.type = TransitionUtils.getActualValue(this.getType());
        this.size = 0.0f;
        imageTransition.repaint();
    }

    @Override
    public boolean performAnimation(ImageTransition imageTransition) {
        if (this.size < 1.0f) {
            this.size = Math.min(this.size + this.getCurrentSpeed(), 1.0f);
            imageTransition.repaint();
            return false;
        }
        return true;
    }

    private float getCurrentSpeed() {
        return Math.max(this.minimumSpeed, this.speed * (float)Math.sqrt((1.0f - this.size) / 1.0f));
    }

    @Override
    public void paint(Graphics2D graphics2D, ImageTransition imageTransition) {
        int n = imageTransition.getWidth();
        int n2 = imageTransition.getHeight();
        if (this.type.equals((Object)ZoomType.zoomIn)) {
            graphics2D.drawImage(imageTransition.getCurrentImage(), 0, 0, n, n2, null);
            Composite composite = LafUtils.setupAlphaComposite(graphics2D, this.size, this.isFade());
            int n3 = Math.round((float)n * this.size);
            int n4 = Math.round((float)n2 * this.size);
            graphics2D.drawImage(imageTransition.getOtherImage(), n / 2 - n3 / 2, n2 / 2 - n4 / 2, n3, n4, null);
            LafUtils.restoreComposite(graphics2D, composite, this.isFade());
        } else {
            graphics2D.drawImage(imageTransition.getOtherImage(), 0, 0, n, n2, null);
            Composite composite = LafUtils.setupAlphaComposite(graphics2D, 1.0f - this.size, this.isFade());
            int n5 = Math.round((float)n * (1.0f - this.size));
            int n6 = Math.round((float)n2 * (1.0f - this.size));
            graphics2D.drawImage(imageTransition.getCurrentImage(), n / 2 - n5 / 2, n2 / 2 - n6 / 2, n5, n6, null);
            LafUtils.restoreComposite(graphics2D, composite, this.isFade());
        }
    }
}

