/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class ComponentMoveAdapter
extends MouseAdapter {
    protected Component toDrag;
    protected boolean dragging = false;
    protected Component dragged = null;
    protected Point initialPoint = null;
    protected Rectangle initialBounds = null;

    public static void install(Component component) {
        ComponentMoveAdapter.install(component, null);
    }

    public static void install(Component component, Component component2) {
        ComponentMoveAdapter componentMoveAdapter = new ComponentMoveAdapter(component2);
        component.addMouseListener(componentMoveAdapter);
        component.addMouseMotionListener(componentMoveAdapter);
    }

    public ComponentMoveAdapter() {
        this(null);
    }

    public ComponentMoveAdapter(Component component) {
        this.toDrag = component;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.dragged = this.getDraggedComponent(mouseEvent);
            if (this.dragged != null) {
                this.dragging = true;
                this.initialPoint = MouseInfo.getPointerInfo().getLocation();
                this.initialBounds = this.dragged.getBounds();
            }
        }
    }

    private Component getDraggedComponent(MouseEvent mouseEvent) {
        return this.toDrag == null ? SwingUtils.getWindowAncestor(mouseEvent.getComponent()) : this.toDrag;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragging) {
            Point point = MouseInfo.getPointerInfo().getLocation();
            this.dragged.setLocation(this.initialBounds.x + (point.x - this.initialPoint.x), this.initialBounds.y + (point.y - this.initialPoint.y));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
        this.dragged = null;
        this.initialPoint = null;
        this.initialBounds = null;
    }
}

