/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf;

import com.alee.laf.WebLookAndFeel;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;

public class AltProcessor
implements KeyEventPostProcessor {
    private static boolean altKeyPressed = false;
    private static boolean menuCanceledOnPress = false;
    private static JRootPane root = null;
    private static Window winAncestor = null;

    @Override
    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        if (keyEvent.getKeyCode() == 18) {
            root = SwingUtilities.getRootPane(keyEvent.getComponent());
            Window window = winAncestor = root == null ? null : SwingUtils.getWindowAncestor(root);
            if (keyEvent.getID() == 401) {
                if (!altKeyPressed) {
                    this.altPressed(keyEvent);
                }
                altKeyPressed = true;
                return true;
            }
            if (keyEvent.getID() == 402) {
                if (altKeyPressed) {
                    this.altReleased();
                } else {
                    MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                    MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                    if (menuElementArray.length <= 0) {
                        WebLookAndFeel.setMnemonicHidden(true);
                        this.repaintMnemonicsInWindow(winAncestor);
                    }
                }
                altKeyPressed = false;
            }
            root = null;
            winAncestor = null;
        } else {
            altKeyPressed = false;
        }
        return false;
    }

    private void altPressed(KeyEvent keyEvent) {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        if (menuElementArray.length > 0 && !(menuElementArray[0] instanceof ComboPopup)) {
            menuSelectionManager.clearSelectedPath();
            menuCanceledOnPress = true;
            keyEvent.consume();
        } else if (menuElementArray.length > 0) {
            menuCanceledOnPress = false;
            WebLookAndFeel.setMnemonicHidden(false);
            this.repaintMnemonicsInWindow(winAncestor);
            keyEvent.consume();
        } else {
            JMenu jMenu;
            JMenuBar jMenuBar;
            menuCanceledOnPress = false;
            WebLookAndFeel.setMnemonicHidden(false);
            this.repaintMnemonicsInWindow(winAncestor);
            JMenuBar jMenuBar2 = jMenuBar = root != null ? root.getJMenuBar() : null;
            if (jMenuBar == null && winAncestor instanceof JFrame) {
                jMenuBar = ((JFrame)winAncestor).getJMenuBar();
            }
            JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
            if (jMenu != null) {
                keyEvent.consume();
            }
        }
    }

    private void altReleased() {
        if (menuCanceledOnPress) {
            WebLookAndFeel.setMnemonicHidden(true);
            this.repaintMnemonicsInWindow(winAncestor);
            return;
        }
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        if (menuSelectionManager.getSelectedPath().length == 0) {
            JMenu jMenu;
            JMenuBar jMenuBar;
            JMenuBar jMenuBar2 = jMenuBar = root != null ? root.getJMenuBar() : null;
            if (jMenuBar == null && winAncestor instanceof JFrame) {
                jMenuBar = ((JFrame)winAncestor).getJMenuBar();
            }
            JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                menuSelectionManager.setSelectedPath(menuElementArray);
            } else if (!WebLookAndFeel.isMnemonicHidden()) {
                WebLookAndFeel.setMnemonicHidden(true);
                this.repaintMnemonicsInWindow(winAncestor);
            }
        } else if (menuSelectionManager.getSelectedPath()[0] instanceof ComboPopup) {
            WebLookAndFeel.setMnemonicHidden(true);
            this.repaintMnemonicsInWindow(winAncestor);
        }
    }

    private void repaintMnemonicsInWindow(Window window) {
        Window[] windowArray;
        if (window == null || !window.isShowing()) {
            return;
        }
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            this.repaintMnemonicsInWindow(window2);
        }
        this.repaintMnemonicsInContainer(window);
    }

    private void repaintMnemonicsInContainer(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component == null || !component.isVisible()) continue;
            if (component instanceof AbstractButton && ((AbstractButton)component).getMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (component instanceof JLabel && ((JLabel)component).getDisplayedMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.repaintMnemonicsInContainer((Container)component);
        }
    }
}

