/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.laf.colorchooser.ColorChooserListener;
import com.alee.laf.colorchooser.WebColorChooser;
import com.alee.laf.rootpane.WebDialog;
import com.alee.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;

public class WebColorChooserDialog
extends WebDialog {
    public static final ImageIcon COLOR_CHOOSER_ICON = new ImageIcon(WebColorChooserDialog.class.getResource("icons/color_chooser.png"));
    private WebColorChooser colorChooser;

    public WebColorChooserDialog() {
        this(new WebColorChooser());
    }

    public WebColorChooserDialog(Component component) {
        this(new WebColorChooser(), component);
    }

    public WebColorChooserDialog(String string) {
        this(new WebColorChooser(), string);
    }

    public WebColorChooserDialog(Component component, String string) {
        this(new WebColorChooser(), component, string);
    }

    public WebColorChooserDialog(WebColorChooser webColorChooser) {
        this(webColorChooser, null, null);
    }

    public WebColorChooserDialog(WebColorChooser webColorChooser, Component component) {
        this(webColorChooser, component, null);
    }

    public WebColorChooserDialog(WebColorChooser webColorChooser, String string) {
        this(webColorChooser, null, string);
    }

    public WebColorChooserDialog(WebColorChooser webColorChooser, Component component, String string) {
        super(SwingUtils.getWindowAncestor(component));
        this.updateTitle(string);
        this.setIconImage(COLOR_CHOOSER_ICON.getImage());
        this.setLayout(new BorderLayout(0, 0));
        this.colorChooser = webColorChooser;
        this.colorChooser.setOpaque(false);
        this.colorChooser.setShowButtonsPanel(true);
        this.getContentPane().add((Component)this.colorChooser, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                WebColorChooserDialog.this.colorChooser.setResult(-1);
            }
        });
        this.colorChooser.addColorChooserListener(new ColorChooserListener(){

            @Override
            public void okPressed(ActionEvent actionEvent) {
                WebColorChooserDialog.this.dispose();
            }

            @Override
            public void resetPressed(ActionEvent actionEvent) {
            }

            @Override
            public void cancelPressed(ActionEvent actionEvent) {
                WebColorChooserDialog.this.dispose();
            }
        });
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.setDefaultCloseOperation(2);
    }

    public void updateTitle(String string) {
        if (string == null) {
            this.setLanguage("weblaf.colorchooser.title", new Object[0]);
        } else {
            this.removeLanguage();
            this.setTitle(string);
        }
    }

    public int getResult() {
        return this.colorChooser.getResult();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.getResult();
    }

    public Color getColor() {
        return this.colorChooser.getColor();
    }

    public void setColor(Color color) {
        this.colorChooser.setColor(color);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.colorChooser.resetResult();
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(bl);
    }
}

