/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.laf.StyleConstants;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.list.WebListStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class WebListUI
extends BasicListUI {
    private boolean highlightRolloverCell = WebListStyle.highlightRolloverCell;
    private int selectionRound = WebListStyle.selectionRound;
    private int selectionShadeWidth = WebListStyle.selectionShadeWidth;
    private boolean autoScrollToSelection = WebListStyle.autoScrollToSelection;
    private MouseAdapter mouseoverAdapter;
    private ListSelectionListener selectionListener;
    private int rolloverIndex = -1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebListUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(jComponent);
        this.list.setOpaque(true);
        this.list.setBackground(WebListStyle.background);
        this.list.setForeground(WebListStyle.foreground);
        if (!(this.list.getCellRenderer() instanceof WebListCellRenderer)) {
            this.list.setCellRenderer(new WebListCellRenderer());
        }
        this.mouseoverAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.updateMouseover(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.updateMouseover(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.updateMouseover(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.updateMouseover(mouseEvent);
            }

            private void updateMouseover(MouseEvent mouseEvent) {
                if (!WebListUI.this.highlightRolloverCell) {
                    return;
                }
                int n = WebListUI.this.list.locationToIndex(mouseEvent.getPoint());
                Rectangle rectangle = WebListUI.this.list.getCellBounds(n, n);
                if (rectangle == null || !rectangle.contains(mouseEvent.getPoint()) || !WebListUI.this.list.isEnabled()) {
                    n = -1;
                }
                if (WebListUI.this.rolloverIndex != n) {
                    Rectangle rectangle2;
                    int n2 = WebListUI.this.rolloverIndex;
                    WebListUI.this.rolloverIndex = n;
                    if (WebListUI.this.rolloverIndex != -1) {
                        rectangle2 = WebListUI.this.list.getCellBounds(WebListUI.this.rolloverIndex, WebListUI.this.rolloverIndex);
                        if (rectangle2 != null) {
                            WebListUI.this.list.repaint(rectangle2);
                        } else {
                            WebListUI.this.list.repaint();
                        }
                    }
                    if (n2 != -1) {
                        rectangle2 = WebListUI.this.list.getCellBounds(n2, n2);
                        if (rectangle2 != null) {
                            WebListUI.this.list.repaint(rectangle2);
                        } else {
                            WebListUI.this.list.repaint();
                        }
                    }
                }
            }
        };
        this.list.addMouseListener(this.mouseoverAdapter);
        this.list.addMouseMotionListener(this.mouseoverAdapter);
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (WebListUI.this.autoScrollToSelection && WebListUI.this.list.getSelectedIndex() != -1) {
                    int n = WebListUI.this.list.getLeadSelectionIndex();
                    Rectangle rectangle = WebListUI.this.getCellBounds(WebListUI.this.list, n, n);
                    if (!rectangle.intersects(WebListUI.this.list.getVisibleRect())) {
                        WebListUI.this.list.scrollRectToVisible(rectangle);
                    }
                }
            }
        };
        this.list.addListSelectionListener(this.selectionListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.list.removeMouseListener(this.mouseoverAdapter);
        this.list.removeMouseMotionListener(this.mouseoverAdapter);
        this.list.removeListSelectionListener(this.selectionListener);
        super.uninstallUI(jComponent);
    }

    public boolean isHighlightRolloverCell() {
        return this.highlightRolloverCell;
    }

    public void setHighlightRolloverCell(boolean bl) {
        this.highlightRolloverCell = bl;
    }

    public int getSelectionRound() {
        return this.selectionRound;
    }

    public void setSelectionRound(int n) {
        this.selectionRound = n;
    }

    public int getSelectionShadeWidth() {
        return this.selectionShadeWidth;
    }

    public void setSelectionShadeWidth(int n) {
        this.selectionShadeWidth = n;
    }

    public boolean isAutoScrollToSelection() {
        return this.autoScrollToSelection;
    }

    public void setAutoScrollToSelection(boolean bl) {
        this.autoScrollToSelection = bl;
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object;
        Object e = listModel.getElementAt(n);
        boolean bl = this.list.hasFocus() && n == n2;
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        if (bl2 || n == this.rolloverIndex) {
            object = (Graphics2D)graphics;
            Composite composite = LafUtils.setupAlphaComposite((Graphics2D)object, 0.35f, !bl2);
            LafUtils.drawCustomWebBorder((Graphics2D)object, this.list, new RoundRectangle2D.Double(rectangle.x + this.selectionShadeWidth, rectangle.y + this.selectionShadeWidth, rectangle.width - this.selectionShadeWidth * 2 - 1, rectangle.height - this.selectionShadeWidth * 2 - 1, this.selectionRound * 2, this.selectionRound * 2), StyleConstants.shadeColor, this.selectionShadeWidth, true, true);
            LafUtils.restoreComposite((Graphics2D)object, composite, !bl2);
        }
        object = listCellRenderer.getListCellRendererComponent(this.list, e, n, bl2, bl);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        this.rendererPane.paintComponent(graphics, (Component)object, this.list, n3, n4, n5, n6, true);
    }
}

