/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.DataProvider;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingConstants;

public class MenuUtils
implements SwingConstants {
    public static void setupPopupMenu(JComponent jComponent, JPopupMenu jPopupMenu) {
        MenuUtils.setupPopupMenu(jComponent, jPopupMenu, 0);
    }

    public static void setupPopupMenu(JComponent jComponent, JPopupMenu jPopupMenu, int n) {
        MenuUtils.setupPopupMenu(jComponent, jPopupMenu, n, 4);
    }

    public static void setupPopupMenu(JComponent jComponent, JPopupMenu jPopupMenu, int n, int n2) {
        MenuUtils.setupPopupMenu(jComponent, jPopupMenu, n, n2, 5);
    }

    public static void setupPopupMenu(final JComponent jComponent, final JPopupMenu jPopupMenu, final int n, final int n2, final int n3) {
        MenuUtils.setupPopupMenu(jComponent, jPopupMenu, new DataProvider<Point>(){

            @Override
            public Point provide() {
                int n4;
                int n22;
                Dimension dimension = jPopupMenu.getPreferredSize();
                ShapeProvider shapeProvider = SwingUtils.getShapeProvider(jComponent);
                if (shapeProvider != null) {
                    Shape shape = shapeProvider.provideShape();
                    Rectangle rectangle = shape.getBounds();
                    n22 = n2 == 4 ? rectangle.x : (n2 == 2 ? rectangle.x + rectangle.width - dimension.width : rectangle.x + rectangle.width / 2 - dimension.width / 2);
                    n4 = n3 == 1 ? rectangle.y - dimension.height - n : rectangle.y + rectangle.height + n;
                } else {
                    Dimension dimension2 = jComponent.getSize();
                    n22 = n2 == 4 ? 0 : (n2 == 2 ? dimension2.width - dimension.width : dimension2.width / 2 - dimension.width / 2);
                    n4 = n3 == 1 ? -dimension.height - n : dimension2.height + n;
                }
                return new Point(n22, n4);
            }
        });
    }

    public static void setupPopupMenu(final JComponent jComponent, final JPopupMenu jPopupMenu, final DataProvider<Point> dataProvider) {
        if (jComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            abstractButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Point point = (Point)dataProvider.provide();
                    jPopupMenu.show(jComponent, point.x, point.y);
                }
            });
        } else {
            jComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.showMenu(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.showMenu(mouseEvent);
                }

                private void showMenu(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        if (!jComponent.isFocusOwner()) {
                            jComponent.requestFocusInWindow();
                        }
                        Point point = (Point)dataProvider.provide();
                        jPopupMenu.show(jComponent, point.x, point.y);
                    }
                }
            });
        }
    }
}

