/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.laf.WebLookAndFeel;
import com.alee.managers.language.LanguageConstants;
import com.alee.managers.language.LanguageKeyListener;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageUpdaterComparator;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.language.data.Value;
import com.alee.managers.language.updaters.AbstractButtonLU;
import com.alee.managers.language.updaters.DialogLU;
import com.alee.managers.language.updaters.FrameLU;
import com.alee.managers.language.updaters.JInternalFrameLU;
import com.alee.managers.language.updaters.JLabelLU;
import com.alee.managers.language.updaters.JProgressBarLU;
import com.alee.managers.language.updaters.JTextComponentLU;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.language.updaters.WebFileDropLU;
import com.alee.managers.language.updaters.WebFormattedTextFieldLU;
import com.alee.managers.language.updaters.WebPasswordFieldLU;
import com.alee.managers.language.updaters.WebTextFieldLU;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.DataProvider;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class LanguageManager
implements LanguageConstants {
    public static final ImageIcon other = new ImageIcon(LanguageManager.class.getResource("icons/lang/other.png"));
    public static String DEFAULT = LanguageManager.getSystemLanguageKey();
    private static final Object supportedLanguagesLock = new Object();
    private static List<String> supportedLanguages = CollectionUtils.copy("en", "ru", "pl", "ar", "es", "fr", "pt");
    private static String language;
    private static ComponentOrientation orientation;
    private static TooltipType defaultTooltipType;
    private static final Object languageListenersLock;
    private static List<LanguageListener> languageListeners;
    private static final Object languageKeyListenersLock;
    private static Map<String, List<LanguageKeyListener>> languageKeyListeners;
    private static Dictionary globalDictionary;
    private static Map<String, Value> globalCache;
    private static List<Dictionary> dictionaries;
    private static final Object componentsLock;
    private static Map<Component, String> components;
    private static Map<Component, Object[]> componentsData;
    private static final Object updatersLock;
    private static List<LanguageUpdater> updaters;
    private static Map<Component, LanguageUpdater> customUpdaters;
    private static Map<Class, LanguageUpdater> updatersCache;
    private static LanguageUpdaterComparator languageUpdaterComparator;
    private static boolean initialized;
    private static Map<Component, List<WebCustomTooltip>> tooltipsCache;
    private static Map<String, ImageIcon> languageIcons;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            language = supportedLanguages.contains(DEFAULT) ? DEFAULT : "en";
            LanguageManager.updateLocale();
            languageListeners = new ArrayList<LanguageListener>();
            languageKeyListeners = new HashMap<String, List<LanguageKeyListener>>();
            globalDictionary = new Dictionary();
            globalCache = new HashMap<String, Value>();
            dictionaries = new ArrayList<Dictionary>();
            XmlUtils.processAnnotations(Dictionary.class);
            XmlUtils.processAnnotations(Record.class);
            XmlUtils.processAnnotations(Value.class);
            XmlUtils.processAnnotations(Text.class);
            XmlUtils.processAnnotations(Tooltip.class);
            XmlUtils.processAnnotations(TooltipType.class);
            LanguageManager.addDictionary(WebLookAndFeel.class, "resources/language.xml");
            LanguageManager.registerLanguageUpdater(new JLabelLU());
            LanguageManager.registerLanguageUpdater(new AbstractButtonLU());
            LanguageManager.registerLanguageUpdater(new JTextComponentLU());
            LanguageManager.registerLanguageUpdater(new WebTextFieldLU());
            LanguageManager.registerLanguageUpdater(new WebFormattedTextFieldLU());
            LanguageManager.registerLanguageUpdater(new WebPasswordFieldLU());
            LanguageManager.registerLanguageUpdater(new JProgressBarLU());
            LanguageManager.registerLanguageUpdater(new FrameLU());
            LanguageManager.registerLanguageUpdater(new DialogLU());
            LanguageManager.registerLanguageUpdater(new JInternalFrameLU());
            LanguageManager.registerLanguageUpdater(new WebFileDropLU());
            LanguageManager.addLanguageListener(new LanguageListener(){

                @Override
                public void languageChanged(String string, String string2) {
                    this.updateAll();
                }

                @Override
                public void dictionaryAdded(Dictionary dictionary) {
                    this.updateSmart(dictionary);
                }

                @Override
                public void dictionaryRemoved(Dictionary dictionary) {
                    this.updateSmart(dictionary);
                }

                @Override
                public void dictionariesCleared() {
                    this.updateAll();
                }

                private void updateAll() {
                    if (languageKeyListeners.size() > 0) {
                        LanguageManager.fireAllLanguageKeysUpdated();
                    }
                    LanguageManager.updateAllComponents();
                }

                private void updateSmart(Dictionary dictionary) {
                    List<String> list = this.gatherKeys(dictionary);
                    if (languageKeyListeners.size() > 0) {
                        for (String string : list) {
                            LanguageManager.fireLanguageKeyUpdated(string);
                        }
                    }
                    LanguageManager.updateAllComponents(list);
                }

                private List<String> gatherKeys(Dictionary dictionary) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    this.gatherKeys(dictionary, arrayList);
                    return arrayList;
                }

                private void gatherKeys(Dictionary dictionary, List<String> list) {
                    if (dictionary.getRecords() != null) {
                        for (Record serializable : dictionary.getRecords()) {
                            list.add(serializable.getKey());
                        }
                    }
                    if (dictionary.getSubdictionaries() != null) {
                        for (Dictionary dictionary2 : dictionary.getSubdictionaries()) {
                            this.gatherKeys(dictionary2, list);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSupportedLanguages() {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            return CollectionUtils.copy(supportedLanguages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSupportedLanguage(String string) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            supportedLanguages.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSupportedLanguage(String string, Dictionary dictionary) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            LanguageManager.addDictionary(dictionary);
            supportedLanguages.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSupportedLanguage(String string) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            supportedLanguages.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerComponent(Component component, String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length == 0) {
            objectArray = null;
        }
        Object object = componentsLock;
        synchronized (object) {
            components.put(component, string);
            if (objectArray != null) {
                componentsData.put(component, objectArray);
            }
        }
        LanguageManager.updateComponent(component, string, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterComponent(Component component) {
        Object object = componentsLock;
        synchronized (object) {
            components.remove(component);
            componentsData.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegisteredComponent(Component component) {
        Object object = componentsLock;
        synchronized (object) {
            return components.containsKey(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLanguageUpdater(LanguageUpdater languageUpdater) {
        Object object = updatersLock;
        synchronized (object) {
            updaters.add(languageUpdater);
            updatersCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLanguageUpdater(LanguageUpdater languageUpdater) {
        Object object = updatersLock;
        synchronized (object) {
            updaters.remove(languageUpdater);
            updatersCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLanguageUpdater(Component component, LanguageUpdater languageUpdater) {
        Object object = updatersLock;
        synchronized (object) {
            customUpdaters.put(component, languageUpdater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLanguageUpdater(Component component) {
        Object object = updatersLock;
        synchronized (object) {
            customUpdaters.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanguageUpdater getLanguageUpdater(Component component) {
        Object object = updatersLock;
        synchronized (object) {
            LanguageUpdater languageUpdater = customUpdaters.get(component);
            if (languageUpdater != null) {
                return languageUpdater;
            }
            LanguageUpdater languageUpdater2 = updatersCache.get(component.getClass());
            if (languageUpdater2 != null) {
                return languageUpdater2;
            }
            ArrayList<LanguageUpdater> arrayList = new ArrayList<LanguageUpdater>();
            for (LanguageUpdater languageUpdater3 : updaters) {
                if (!languageUpdater3.getComponentClass().isInstance(component)) continue;
                arrayList.add(languageUpdater3);
            }
            if (arrayList.size() == 1) {
                languageUpdater2 = (LanguageUpdater)arrayList.get(0);
            } else if (arrayList.size() > 1) {
                Collections.sort(arrayList, languageUpdaterComparator);
                languageUpdater2 = (LanguageUpdater)arrayList.get(0);
            }
            updatersCache.put(component.getClass(), languageUpdater2);
            return languageUpdater2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAllComponents() {
        Object object = componentsLock;
        synchronized (object) {
            for (Map.Entry<Component, String> entry : components.entrySet()) {
                LanguageManager.updateComponent(entry.getKey(), entry.getValue(), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAllComponents(List<String> list) {
        Object object = componentsLock;
        synchronized (object) {
            for (Map.Entry<Component, String> entry : components.entrySet()) {
                if (!list.contains(entry.getValue())) continue;
                LanguageManager.updateComponent(entry.getKey(), entry.getValue(), new Object[0]);
            }
        }
    }

    public static void updateComponent(Component component, Object ... objectArray) {
        String string = components.get(component);
        if (string != null) {
            LanguageManager.updateComponent(component, string, objectArray);
        }
    }

    public static void updateComponent(Component component, String string, Object ... objectArray) {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length == 0) {
            objectArray = null;
        }
        Value value = LanguageManager.getNotNullValue(string);
        if (objectArray != null) {
            componentsData.put(component, objectArray);
            objectArray2 = objectArray;
        } else {
            objectArray2 = componentsData.get(component);
        }
        LanguageUpdater languageUpdater = LanguageManager.getLanguageUpdater(component);
        if (languageUpdater != null) {
            languageUpdater.update(component, string, value, LanguageManager.parseData(objectArray2));
        }
        boolean bl = component instanceof JComponent;
        if (tooltipsCache.containsKey(component)) {
            if (bl) {
                ((JComponent)component).setToolTipText(null);
            }
            TooltipManager.removeTooltips(component, tooltipsCache.get(component));
            tooltipsCache.get(component).clear();
        }
        if (value != null && value.getTooltips() != null && value.getTooltips().size() > 0) {
            for (Tooltip tooltip : value.getTooltips()) {
                if (tooltip.getType().equals((Object)TooltipType.swing)) {
                    if (!bl) continue;
                    ((JComponent)component).setToolTipText(tooltip.getText());
                    continue;
                }
                if (tooltip.getDelay() != null) {
                    LanguageManager.cacheTip(TooltipManager.setTooltip(component, tooltip.getText(), tooltip.getWay(), (int)tooltip.getDelay()));
                    continue;
                }
                LanguageManager.cacheTip(TooltipManager.setTooltip(component, tooltip.getText()));
            }
        }
    }

    private static Object[] parseData(Object ... objectArray) {
        if (objectArray != null) {
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                objectArray2[i] = object != null && object instanceof DataProvider ? ((DataProvider)object).provide() : object;
            }
            return objectArray2;
        }
        return null;
    }

    private static void cacheTip(WebCustomTooltip webCustomTooltip) {
        Component component = webCustomTooltip.getComponent();
        if (!tooltipsCache.containsKey(component)) {
            tooltipsCache.put(component, new ArrayList());
        }
        tooltipsCache.get(component).add(webCustomTooltip);
    }

    public static ImageIcon getLanguageIcon(String string) {
        ImageIcon imageIcon;
        if (languageIcons.containsKey(string)) {
            return languageIcons.get(string);
        }
        try {
            URL uRL = LanguageManager.class.getResource("icons/lang/" + string + ".png");
            imageIcon = new ImageIcon(uRL);
        }
        catch (Throwable throwable) {
            imageIcon = other;
        }
        languageIcons.put(string, imageIcon);
        return imageIcon;
    }

    public static TooltipType getDefaultTooltipType() {
        return defaultTooltipType;
    }

    public static void setDefaultTooltipType(TooltipType tooltipType) {
        defaultTooltipType = tooltipType;
    }

    public static String getLanguage() {
        return language;
    }

    public static void setLanguage(String string) {
        if (string == null || LanguageManager.getLanguage().trim().toLowerCase().equals(string.trim().toLowerCase())) {
            return;
        }
        ComponentOrientation componentOrientation = LanguageManager.getOrientation();
        String string2 = language;
        language = string;
        LanguageManager.updateLocale();
        LanguageManager.rebuildCache();
        if (componentOrientation.isLeftToRight() != LanguageManager.getOrientation().isLeftToRight()) {
            SwingUtils.updateGlobalOrientations();
        }
        LanguageManager.fireLanguageChanged(string2, string);
    }

    private static void updateLocale() {
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!locale.getLanguage().equals(language)) continue;
            Locale.setDefault(locale);
            return;
        }
        Locale.setDefault(new Locale(language));
    }

    public static boolean isLeftToRight() {
        return LanguageManager.getOrientation().isLeftToRight();
    }

    public static ComponentOrientation getOrientation() {
        if (orientation != null) {
            return orientation;
        }
        return ComponentOrientation.getOrientation(Locale.getDefault());
    }

    public static void setOrientation(ComponentOrientation componentOrientation) {
        orientation = componentOrientation;
        SwingUtils.updateGlobalOrientations();
    }

    public static void changeOrientation() {
        LanguageManager.setOrientation(LanguageManager.getOrientation().isLeftToRight() ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
    }

    public static Dictionary getGlobalDictionary() {
        return globalDictionary;
    }

    public static List<Dictionary> getDictionaries() {
        return dictionaries;
    }

    public static Dictionary loadDictionary(Class clazz, String string) {
        return LanguageManager.loadDictionary(clazz.getResource(string));
    }

    public static Dictionary loadDictionary(URL uRL) {
        return (Dictionary)XmlUtils.fromXML(uRL);
    }

    public static Dictionary loadDictionary(String string) {
        return LanguageManager.loadDictionary(new File(string));
    }

    public static Dictionary loadDictionary(File file) {
        return (Dictionary)XmlUtils.fromXML(file);
    }

    public static void addDictionary(Class clazz, String string) {
        LanguageManager.addDictionary(LanguageManager.loadDictionary(clazz, string));
    }

    public static void addDictionary(URL uRL) {
        LanguageManager.addDictionary(LanguageManager.loadDictionary(uRL));
    }

    public static void addDictionary(String string) {
        LanguageManager.addDictionary(LanguageManager.loadDictionary(string));
    }

    public static void addDictionary(File file) {
        LanguageManager.addDictionary(LanguageManager.loadDictionary(file));
    }

    public static void addDictionary(Dictionary dictionary) {
        dictionaries.add(dictionary);
        LanguageManager.mergeDictionary(dictionary);
        LanguageManager.updateCache(dictionary);
        LanguageManager.fireDictionaryAdded(dictionary);
    }

    public static void removeDictionary(Dictionary dictionary) {
        if (dictionaries.contains(dictionary)) {
            globalDictionary.clear();
            dictionaries.remove(dictionary);
            for (Dictionary dictionary2 : dictionaries) {
                LanguageManager.mergeDictionary(dictionary2);
            }
            LanguageManager.rebuildCache();
            LanguageManager.fireDictionaryRemoved(dictionary);
        }
    }

    private static void mergeDictionary(Dictionary dictionary) {
        LanguageManager.mergeDictionary(dictionary.getPrefix(), dictionary);
    }

    private static void mergeDictionary(String string, Dictionary dictionary) {
        Object object;
        String string2 = string = string != null && !string.equals("") ? string + "." : "";
        if (dictionary.getRecords() != null) {
            for (Record serializable : dictionary.getRecords()) {
                object = serializable.clone();
                ((Record)object).setKey(string + ((Record)object).getKey());
                globalDictionary.addRecord((Record)object);
            }
        }
        if (dictionary.getSubdictionaries() != null) {
            for (Dictionary dictionary2 : dictionary.getSubdictionaries()) {
                object = dictionary2.getPrefix();
                String string3 = string + (String)(object != null && !((String)object).equals("") ? object : "");
                LanguageManager.mergeDictionary(string3, dictionary2);
            }
        }
    }

    public static void clearDictionaries() {
        globalDictionary.clear();
        dictionaries.clear();
        LanguageManager.clearCache();
    }

    public static String get(String string) {
        Value value = LanguageManager.getValue(string);
        return value != null ? value.getText() : string;
    }

    public static Character getMnemonic(String string) {
        Value value = LanguageManager.getValue(string);
        return value != null ? value.getMnemonic() : null;
    }

    public static Value getValue(String string) {
        return globalCache != null ? globalCache.get(string) : null;
    }

    public static Value getNotNullValue(String string) {
        Value value = LanguageManager.getValue(string);
        if (value != null) {
            return value;
        }
        Value value2 = new Value(LanguageManager.getLanguage(), string);
        globalCache.put(string, value2);
        return value2;
    }

    private static void rebuildCache() {
        LanguageManager.clearCache();
        LanguageManager.updateCache(globalDictionary);
    }

    private static void clearCache() {
        globalCache.clear();
    }

    private static void updateCache(Dictionary dictionary) {
        LanguageManager.updateCache(dictionary.getPrefix(), dictionary);
    }

    private static void updateCache(String string, Dictionary dictionary) {
        Object object;
        String string2 = string = string != null && !string.equals("") ? string + "." : "";
        if (dictionary.getRecords() != null) {
            for (Record serializable : dictionary.getRecords()) {
                object = serializable.getValue(language);
                if (object != null && ((Value)object).getHotkey() == null && serializable.getHotkey() != null) {
                    ((Value)object).setHotkey(serializable.getHotkey());
                }
                globalCache.put(string + serializable.getKey(), (Value)object);
            }
        }
        if (dictionary.getSubdictionaries() != null) {
            for (Dictionary dictionary2 : dictionary.getSubdictionaries()) {
                object = dictionary2.getPrefix();
                String string3 = string + (String)(object != null && !((String)object).equals("") ? object : "");
                LanguageManager.updateCache(string3, dictionary2);
            }
        }
    }

    public static String getSystemLanguageKey() {
        return System.getProperty("user.language");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LanguageListener> getLanguageListeners() {
        Object object = languageListenersLock;
        synchronized (object) {
            return CollectionUtils.copy(languageListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageListener(LanguageListener languageListener) {
        Object object = languageListenersLock;
        synchronized (object) {
            languageListeners.add(languageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageListener(LanguageListener languageListener) {
        Object object = languageListenersLock;
        synchronized (object) {
            languageListeners.remove(languageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireLanguageChanged(String string, String string2) {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener languageListener : languageListeners) {
                languageListener.languageChanged(string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionaryAdded(Dictionary dictionary) {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener languageListener : languageListeners) {
                languageListener.dictionaryAdded(dictionary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionaryRemoved(Dictionary dictionary) {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener languageListener : languageListeners) {
                languageListener.dictionaryRemoved(dictionary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionariesCleared() {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener languageListener : languageListeners) {
                languageListener.dictionariesCleared();
            }
        }
    }

    public static Map<String, List<LanguageKeyListener>> getLanguageKeyListeners() {
        return languageKeyListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageKeyListener(String string, LanguageKeyListener languageKeyListener) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            List<LanguageKeyListener> list = languageKeyListeners.get(string);
            if (list == null) {
                list = new ArrayList<LanguageKeyListener>();
                languageKeyListeners.put(string, list);
            }
            list.add(languageKeyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageKeyListener(LanguageKeyListener languageKeyListener) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            for (Map.Entry<String, List<LanguageKeyListener>> entry : languageKeyListeners.entrySet()) {
                entry.getValue().remove(languageKeyListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageKeyListeners(String string) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            languageKeyListeners.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireLanguageKeyUpdated(String string) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            List<LanguageKeyListener> list = languageKeyListeners.get(string);
            if (list != null) {
                Value value = LanguageManager.getValue(string);
                for (LanguageKeyListener languageKeyListener : CollectionUtils.copy(list)) {
                    languageKeyListener.languageKeyUpdated(string, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireAllLanguageKeysUpdated() {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            for (Map.Entry<String, List<LanguageKeyListener>> entry : languageKeyListeners.entrySet()) {
                Value value = LanguageManager.getValue(entry.getKey());
                for (LanguageKeyListener languageKeyListener : CollectionUtils.copy((Collection)entry.getValue())) {
                    languageKeyListener.languageKeyUpdated(entry.getKey(), value);
                }
            }
        }
    }

    static {
        orientation = null;
        defaultTooltipType = TooltipType.weblaf;
        languageListenersLock = new Object();
        languageKeyListenersLock = new Object();
        globalDictionary = new Dictionary();
        globalCache = new HashMap<String, Value>();
        dictionaries = new ArrayList<Dictionary>();
        componentsLock = new Object();
        components = new WeakHashMap<Component, String>();
        componentsData = new WeakHashMap<Component, Object[]>();
        updatersLock = new Object();
        updaters = new ArrayList<LanguageUpdater>();
        customUpdaters = new WeakHashMap<Component, LanguageUpdater>();
        updatersCache = new HashMap<Class, LanguageUpdater>();
        languageUpdaterComparator = new LanguageUpdaterComparator();
        initialized = false;
        tooltipsCache = new HashMap<Component, List<WebCustomTooltip>>();
        languageIcons = new HashMap<String, ImageIcon>();
    }
}

