/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.extended.painter.NinePatchIconPainter;
import com.alee.extended.painter.Painter;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.PopupStyle;
import com.alee.managers.popup.ShadeLayer;
import com.alee.managers.popup.WebPopup;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;

public class PopupManager {
    private static Map<Window, ShadeLayer> shadeLayers = new HashMap<Window, ShadeLayer>();
    private static Map<Window, PopupLayer> popupLayers = new HashMap<Window, PopupLayer>();
    private static PopupStyle defaultPopupStyle = PopupStyle.bordered;
    private static Map<PopupStyle, Painter> stylePainters = new HashMap<PopupStyle, Painter>();

    public static void hideAllPopups() {
        for (ShadeLayer popupLayer : shadeLayers.values()) {
            popupLayer.hideAllPopups();
        }
        for (PopupLayer popupLayer : popupLayers.values()) {
            popupLayer.hideAllPopups();
        }
    }

    public static void hideAllPopups(Window window) {
        if (shadeLayers.containsKey(window)) {
            shadeLayers.get(window).hideAllPopups();
        }
        if (popupLayers.containsKey(window)) {
            popupLayers.get(window).hideAllPopups();
        }
    }

    public static PopupStyle getDefaultPopupStyle() {
        return defaultPopupStyle;
    }

    public static void setDefaultPopupStyle(PopupStyle popupStyle) {
        defaultPopupStyle = popupStyle;
    }

    public static Painter getPopupPainter() {
        return PopupManager.getPopupPainter(defaultPopupStyle);
    }

    public static Painter getPopupPainter(PopupStyle popupStyle) {
        if (!stylePainters.containsKey((Object)popupStyle)) {
            if (popupStyle.equals((Object)PopupStyle.none)) {
                stylePainters.put(PopupStyle.none, null);
            } else {
                stylePainters.put(popupStyle, new NinePatchIconPainter(PopupManager.class.getResource("icons/popup/" + (Object)((Object)popupStyle) + ".9.png")));
            }
        }
        return stylePainters.get((Object)popupStyle);
    }

    public static void showModalPopup(Component component, WebPopup webPopup, boolean bl, boolean bl2) {
        Window window = SwingUtils.getWindowAncestor(component);
        if (window != null) {
            PopupManager.showModalPopup(window, webPopup, bl, bl2);
        }
    }

    public static void showModalPopup(Window window, WebPopup webPopup, boolean bl, boolean bl2) {
        PopupManager.hideAllPopups(window);
        PopupManager.getShadeLayer(window).showPopup(webPopup, bl, bl2);
        webPopup.transferFocus();
    }

    private static ShadeLayer getShadeLayer(Window window) {
        if (shadeLayers.containsKey(window)) {
            return shadeLayers.get(window);
        }
        final ShadeLayer shadeLayer = new ShadeLayer();
        if (window instanceof JDialog) {
            final JDialog jDialog = (JDialog)window;
            jDialog.getLayeredPane().add((Component)shadeLayer, JLayeredPane.PALETTE_LAYER);
            jDialog.getLayeredPane().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    shadeLayer.setBounds(0, 0, jDialog.getLayeredPane().getWidth(), jDialog.getLayeredPane().getHeight());
                }
            });
        } else if (window instanceof JFrame) {
            final JFrame jFrame = (JFrame)window;
            jFrame.getLayeredPane().add((Component)shadeLayer, JLayeredPane.PALETTE_LAYER);
            jFrame.getLayeredPane().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    shadeLayer.setBounds(0, 0, jFrame.getLayeredPane().getWidth(), jFrame.getLayeredPane().getHeight());
                }
            });
        }
        shadeLayers.put(window, shadeLayer);
        return shadeLayer;
    }

    public static void showPopup(Component component, WebPopup webPopup) {
        PopupManager.showPopup(component, webPopup, true);
    }

    public static void showPopup(Component component, WebPopup webPopup, boolean bl) {
        Window window = SwingUtils.getWindowAncestor(component);
        if (window != null) {
            PopupManager.showPopup(window, webPopup, bl);
        }
    }

    public static void showPopup(Window window, WebPopup webPopup, boolean bl) {
        PopupManager.getPopupLayer(window).showPopup(webPopup);
        if (bl) {
            webPopup.transferFocus();
        }
    }

    private static PopupLayer getPopupLayer(Window window) {
        if (popupLayers.containsKey(window)) {
            return popupLayers.get(window);
        }
        final PopupLayer popupLayer = new PopupLayer();
        if (window instanceof JDialog) {
            final JDialog jDialog = (JDialog)window;
            jDialog.getLayeredPane().add((Component)popupLayer, JLayeredPane.PALETTE_LAYER);
            jDialog.getLayeredPane().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    popupLayer.setBounds(0, 0, jDialog.getLayeredPane().getWidth(), jDialog.getLayeredPane().getHeight());
                }
            });
        } else if (window instanceof JFrame) {
            final JFrame jFrame = (JFrame)window;
            jFrame.getLayeredPane().add((Component)popupLayer, JLayeredPane.PALETTE_LAYER);
            jFrame.getLayeredPane().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    popupLayer.setBounds(0, 0, jFrame.getLayeredPane().getWidth(), jFrame.getLayeredPane().getHeight());
                }
            });
        } else if (window instanceof JWindow) {
            final JWindow jWindow = (JWindow)window;
            jWindow.getLayeredPane().add((Component)popupLayer, JLayeredPane.PALETTE_LAYER);
            jWindow.getLayeredPane().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    popupLayer.setBounds(0, 0, jWindow.getLayeredPane().getWidth(), jWindow.getLayeredPane().getHeight());
                }
            });
        }
        popupLayers.put(window, popupLayer);
        return popupLayer;
    }
}

