/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.extended.painter.Painter;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.PopupListener;
import com.alee.managers.popup.PopupManager;
import com.alee.managers.popup.PopupStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.EmptyMouseAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WebPopup
extends WebPanel
implements FocusTracker {
    private List<PopupListener> popupListeners = new ArrayList<PopupListener>();
    private boolean closeOnFocusLoss = false;
    private boolean requestFocusOnShow = true;
    private Component defaultFocusComponent = null;
    private List<Component> focusableChilds = new ArrayList<Component>();
    private Component lastComponent = null;
    private AncestorListener lastListener = null;
    protected boolean focused = false;

    public WebPopup() {
        this(PopupManager.getPopupPainter());
    }

    public WebPopup(PopupStyle popupStyle) {
        this(PopupManager.getPopupPainter(popupStyle));
    }

    public WebPopup(Painter painter) {
        this.setOpaque(false);
        this.setPainter(painter);
        this.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (WebPopup.this.requestFocusOnShow) {
                    if (WebPopup.this.defaultFocusComponent != null) {
                        WebPopup.this.defaultFocusComponent.requestFocusInWindow();
                    } else {
                        WebPopup.this.transferFocus();
                    }
                }
                WebPopup.this.firePopupOpened();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                WebPopup.this.firePopupClosed();
            }
        });
        EmptyMouseAdapter.install(this);
        FocusManager.registerFocusTracker(this);
        this.setFocusCycleRoot(true);
    }

    public void setPopupStyle(PopupStyle popupStyle) {
        this.setPainter(PopupManager.getPopupPainter(popupStyle));
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean bl) {
        this.closeOnFocusLoss = bl;
    }

    public boolean isRequestFocusOnShow() {
        return this.requestFocusOnShow;
    }

    public void setRequestFocusOnShow(boolean bl) {
        this.requestFocusOnShow = bl;
    }

    public Component getDefaultFocusComponent() {
        return this.defaultFocusComponent;
    }

    public void setDefaultFocusComponent(Component component) {
        this.defaultFocusComponent = component;
    }

    @Override
    public boolean isTrackingEnabled() {
        return this.isShowing();
    }

    @Override
    public Component getTrackedComponent() {
        return this;
    }

    @Override
    public boolean isUniteWithChilds() {
        return true;
    }

    @Override
    public boolean isListenGlobalChange() {
        return true;
    }

    @Override
    public void focusChanged(boolean bl) {
        this.focused = bl;
        if (this.isShowing() && !bl && !this.isChildFocused() && this.closeOnFocusLoss) {
            this.hidePopup();
        }
    }

    public List<Component> getFocusableChilds() {
        return this.focusableChilds;
    }

    public void addFocusableChild(Component component) {
        this.focusableChilds.add(component);
    }

    public void removeFocusableChild(Component component) {
        this.focusableChilds.remove(component);
    }

    public boolean isChildFocused() {
        for (Component component : this.focusableChilds) {
            if (!SwingUtils.hasFocusOwner(component)) continue;
            return true;
        }
        return false;
    }

    public void showPopup(Component component) {
        Rectangle rectangle = SwingUtils.getBoundsInWindow(component);
        Dimension dimension = SwingUtils.getRootPaneAncestor(component).getSize();
        Dimension dimension2 = this.getPreferredSize();
        int n = rectangle.x + dimension2.width < dimension.width || dimension.width - rectangle.x - dimension2.width > rectangle.x ? 0 : rectangle.width - dimension2.width;
        int n2 = rectangle.y + rectangle.height + dimension2.height < dimension.height || dimension.height - rectangle.y - rectangle.height - dimension2.height > rectangle.y ? rectangle.height : -dimension2.height;
        this.showPopup(component, n, n2);
    }

    public void showPopup(Component component, Point point) {
        this.showPopup(component, point.x, point.y);
    }

    public void showPopup(Component component, int n, int n2) {
        Dimension dimension = this.getPreferredSize();
        this.showPopup(component, n, n2, dimension.width, dimension.height);
    }

    public void showPopup(Component component, Rectangle rectangle) {
        this.showPopup(component, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void showPopup(Component component, int n, int n2, int n3, int n4) {
        this.updatePopupBounds(component, n, n2, n3, n4);
        PopupManager.showPopup(component, this, this.requestFocusOnShow);
        this.updateComponentAncestorListener(component, n, n2, n3, n4);
    }

    private void updatePopupBounds(Component component, int n, int n2, int n3, int n4) {
        if (component.isShowing()) {
            Rectangle rectangle = SwingUtils.getBoundsInWindow(component);
            this.setBounds(rectangle.x + n, rectangle.y + n2, n3, n4);
        }
    }

    private void updateComponentAncestorListener(final Component component, final int n, final int n2, final int n3, final int n4) {
        if (this.lastComponent != null && this.lastListener != null && this.lastComponent instanceof JComponent) {
            ((JComponent)this.lastComponent).removeAncestorListener(this.lastListener);
        }
        this.lastComponent = component;
        if (component instanceof JComponent) {
            this.lastListener = new AncestorAdapter(){

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                    WebPopup.this.updatePopupBounds(component, n, n2, n3, n4);
                }
            };
            ((JComponent)this.lastComponent).addAncestorListener(this.lastListener);
        }
    }

    public void showPopupAsModal(Component component) {
        this.showPopupAsModal(component, false, false);
    }

    public void showPopupAsModal(Component component, boolean bl, boolean bl2) {
        PopupManager.showModalPopup(component, this, bl, bl2);
    }

    public void hidePopup() {
        PopupLayer popupLayer = (PopupLayer)this.getParent();
        if (popupLayer != null) {
            popupLayer.hidePopup(this);
        }
    }

    public void packPopup() {
        this.setSize(this.getPreferredSize());
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.provideShape().contains(n, n2);
    }

    public void addPopupListener(PopupListener popupListener) {
        this.popupListeners.add(popupListener);
    }

    public void removePopupListener(PopupListener popupListener) {
        this.popupListeners.remove(popupListener);
    }

    public void firePopupWillBeOpened() {
        for (PopupListener popupListener : CollectionUtils.copy(this.popupListeners)) {
            popupListener.popupWillBeOpened();
        }
    }

    public void firePopupOpened() {
        for (PopupListener popupListener : CollectionUtils.copy(this.popupListeners)) {
            popupListener.popupOpened();
        }
    }

    public void firePopupWillBeClosed() {
        for (PopupListener popupListener : CollectionUtils.copy(this.popupListeners)) {
            popupListener.popupWillBeClosed();
        }
    }

    public void firePopupClosed() {
        for (PopupListener popupListener : CollectionUtils.copy(this.popupListeners)) {
            popupListener.popupClosed();
        }
    }
}

