/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.proxy;

import com.alee.extended.optionpane.DialogType;
import com.alee.extended.optionpane.WebExtendedOptionPane;
import com.alee.extended.panel.GroupPanel;
import com.alee.laf.checkbox.WebCheckBox;
import com.alee.laf.label.WebLabel;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.text.WebPasswordField;
import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.proxy.ProxyManager;
import com.alee.managers.proxy.ProxySettings;
import com.alee.managers.settings.SettingsManager;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;

public class WebProxyAuthenticator
extends Authenticator {
    public static final ImageIcon AUTH_ICON = new ImageIcon(WebProxyAuthenticator.class.getResource("icons/auth.png"));
    private AuthDialog authDialog = null;

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return this.getProxyAuthentification();
    }

    private PasswordAuthentication getProxyAuthentification() {
        PasswordAuthentication passwordAuthentication;
        ProxySettings proxySettings = ProxyManager.getProxySettings().clone();
        if (this.authDialog != null) {
            passwordAuthentication = null;
        } else if (proxySettings.isUseProxyAuthentification()) {
            passwordAuthentication = this.createAuthentification(proxySettings);
        } else {
            this.authDialog = new AuthDialog(proxySettings);
            this.authDialog.setVisible(true);
            if (this.authDialog.getResult() == 0) {
                proxySettings.setUseProxyAuthentification(true);
                proxySettings.setProxyLogin(this.authDialog.getLogin());
                proxySettings.setProxyPassword(new String(this.authDialog.getPassword()));
                ProxyManager.setProxySettings(proxySettings, this.authDialog.isSaveSettings());
                passwordAuthentication = this.createAuthentification(proxySettings);
            } else {
                ProxySettings proxySettings2 = ProxyManager.getProxySettings();
                passwordAuthentication = proxySettings2.isUseProxyAuthentification() ? this.createAuthentification(proxySettings2) : null;
            }
            this.authDialog = null;
        }
        return passwordAuthentication;
    }

    private PasswordAuthentication createAuthentification(ProxySettings proxySettings) {
        return new PasswordAuthentication(proxySettings.getProxyLogin(), proxySettings.getProxyPassword().toCharArray());
    }

    private class AuthDialog
    extends WebExtendedOptionPane {
        private WebTextField loginField;
        private WebPasswordField passwordField;
        private WebCheckBox saveSettings;

        public AuthDialog(ProxySettings proxySettings) {
            super(DialogType.confirm, SwingUtils.getActiveWindow(), null, null, LanguageManager.get("weblaf.proxy.auth.title"), 2, -1);
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            TableLayout tableLayout = new TableLayout(new double[][]{{-2.0, -1.0}, {-2.0, -2.0, -2.0, -2.0}});
            tableLayout.setHGap(4);
            tableLayout.setVGap(4);
            jPanel.setLayout(tableLayout);
            WebLabel webLabel = new WebLabel();
            webLabel.setLanguage("weblaf.proxy.auth.host", new Object[0]);
            webLabel.setHorizontalAlignment(4);
            webLabel.setEnabled(false);
            jPanel.add((Component)webLabel, "0,0");
            WebTextField webTextField = new WebTextField(proxySettings.getProxyHost(), 10);
            webTextField.setEnabled(false);
            webTextField.putClientProperty("fill.component.cell", true);
            WebLabel webLabel2 = new WebLabel();
            webLabel2.setLanguage("weblaf.proxy.auth.port", new Object[0]);
            webLabel2.setHorizontalAlignment(4);
            webLabel2.setEnabled(false);
            WebTextField webTextField2 = new WebTextField(proxySettings.getProxyPort());
            webTextField2.setEnabled(false);
            jPanel.add((Component)new GroupPanel(2, webTextField, webLabel2, webTextField2), "1,0");
            jPanel.add((Component)new WebSeparator(0), "0,1,1,1");
            WebLabel webLabel3 = new WebLabel();
            webLabel3.setLanguage("weblaf.proxy.auth.login", new Object[0]);
            webLabel3.setHorizontalAlignment(4);
            jPanel.add((Component)webLabel3, "0,2");
            this.loginField = new WebTextField(12);
            this.loginField.addAncestorListener(new AncestorAdapter(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    AuthDialog.this.loginField.requestFocusInWindow();
                }
            });
            jPanel.add((Component)this.loginField, "1,2");
            WebLabel webLabel4 = new WebLabel();
            webLabel4.setLanguage("weblaf.proxy.auth.pass", new Object[0]);
            webLabel4.setHorizontalAlignment(4);
            jPanel.add((Component)webLabel4, "0,3");
            this.passwordField = new WebPasswordField(12);
            jPanel.add((Component)this.passwordField, "1,3");
            HotkeyManager.registerHotkey((Component)jPanel, jPanel, Hotkey.ENTER, new HotkeyRunnable(){

                @Override
                public void run(KeyEvent keyEvent) {
                    AuthDialog.this.clickOk();
                }
            });
            HotkeyManager.registerHotkey((Component)jPanel, jPanel, Hotkey.ESCAPE, new HotkeyRunnable(){

                @Override
                public void run(KeyEvent keyEvent) {
                    AuthDialog.this.clickCancel();
                }
            });
            SwingUtils.equalizeComponentsHeights(webTextField, this.loginField, this.passwordField);
            this.setContent(jPanel);
            this.saveSettings = new WebCheckBox("Save proxy settings");
            SettingsManager.registerComponent((Component)this.saveSettings, ProxyManager.SETTINGS_GROUP, ProxyManager.SAVE_SETTINGS, (Object)true);
            this.setSpecialComponent(this.saveSettings);
        }

        public String getLogin() {
            return this.loginField.getText();
        }

        public char[] getPassword() {
            return this.passwordField.getPassword();
        }

        public boolean isSaveSettings() {
            return this.saveSettings.isSelected();
        }

        @Override
        protected ImageIcon getLargeIcon(int n) {
            return AUTH_ICON;
        }
    }
}

