/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ConditionalVisibilityListener
implements FocusListener,
MouseListener {
    private Boolean focusedVisible;
    private Boolean mouseoverVisible;
    private Component component;
    private boolean focused = false;
    private boolean mouseover = false;

    public static void install(Component component, Component component2, Boolean bl, Boolean bl2) {
        ConditionalVisibilityListener conditionalVisibilityListener = new ConditionalVisibilityListener(component2, bl, bl2);
        if (bl != null) {
            component.addFocusListener(conditionalVisibilityListener);
        }
        if (bl2 != null) {
            component.addMouseListener(conditionalVisibilityListener);
        }
    }

    public ConditionalVisibilityListener(Component component) {
        this(component, null, null);
    }

    public ConditionalVisibilityListener(Component component, Boolean bl, Boolean bl2) {
        this.setComponent(component);
        this.setFocusedVisible(bl);
        this.setMouseoverVisible(bl2);
    }

    public Boolean getFocusedVisible() {
        return this.focusedVisible;
    }

    public void setFocusedVisible(Boolean bl) {
        this.focusedVisible = bl;
    }

    public Boolean getMouseoverVisible() {
        return this.mouseoverVisible;
    }

    public void setMouseoverVisible(Boolean bl) {
        this.mouseoverVisible = bl;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.focusedVisible != null) {
            this.focused = true;
            this.updateVisibility();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.focusedVisible != null) {
            this.focused = false;
            this.updateVisibility();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mouseoverVisible != null) {
            this.mouseover = true;
            this.updateVisibility();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseoverVisible != null) {
            this.mouseover = false;
            this.updateVisibility();
        }
    }

    public void updateVisibility() {
        this.component.setVisible(this.isVisible());
    }

    public boolean isVisible() {
        boolean bl = this.focusedVisible == null || this.focusedVisible == this.focused;
        boolean bl2 = this.mouseoverVisible == null || this.mouseoverVisible == this.mouseover;
        return bl && bl2;
    }
}

