/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.InvalidParameterException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EmulatorConsole {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final int WAIT_TIME = 5;
    private static final int STD_TIMEOUT = 5000;
    private static final String HOST = "127.0.0.1";
    private static final String COMMAND_PING = "help\r\n";
    private static final String COMMAND_AVD_NAME = "avd name\r\n";
    private static final String COMMAND_KILL = "kill\r\n";
    private static final String COMMAND_GSM_STATUS = "gsm status\r\n";
    private static final String COMMAND_GSM_CALL = "gsm call %1$s\r\n";
    private static final String COMMAND_GSM_CANCEL_CALL = "gsm cancel %1$s\r\n";
    private static final String COMMAND_GSM_DATA = "gsm data %1$s\r\n";
    private static final String COMMAND_GSM_VOICE = "gsm voice %1$s\r\n";
    private static final String COMMAND_SMS_SEND = "sms send %1$s %2$s\r\n";
    private static final String COMMAND_NETWORK_STATUS = "network status\r\n";
    private static final String COMMAND_NETWORK_SPEED = "network speed %1$s\r\n";
    private static final String COMMAND_NETWORK_LATENCY = "network delay %1$s\r\n";
    private static final String COMMAND_GPS = "geo nmea $GPGGA,%1$02d%2$02d%3$02d.%4$03d,%5$03d%6$09.6f,%7$c,%8$03d%9$09.6f,%10$c,1,10,0.0,0.0,0,0.0,0,0.0,0000\r\n";
    private static final Pattern RE_KO = Pattern.compile("KO:\\s+(.*)");
    public static final int[] MIN_LATENCIES;
    public final int[] DOWNLOAD_SPEEDS;
    public static final String[] NETWORK_SPEEDS;
    public static final String[] NETWORK_LATENCIES;
    public static final String RESULT_OK;
    private static final Pattern sEmulatorRegexp;
    private static final Pattern sVoiceStatusRegexp;
    private static final Pattern sDataStatusRegexp;
    private static final Pattern sDownloadSpeedRegexp;
    private static final Pattern sMinLatencyRegexp;
    private static final HashMap<Integer, EmulatorConsole> sEmulators;
    private int mPort;
    private SocketChannel mSocketChannel;
    private byte[] mBuffer;

    static {
        int[] nArray = new int[4];
        nArray[1] = 150;
        nArray[2] = 80;
        nArray[3] = 35;
        MIN_LATENCIES = nArray;
        NETWORK_SPEEDS = new String[]{"full", "gsm", "hscsd", "gprs", "edge", "umts", "hsdpa"};
        NETWORK_LATENCIES = new String[]{"none", "gprs", "edge", "umts"};
        RESULT_OK = null;
        sEmulatorRegexp = Pattern.compile("emulator-(\\d+)");
        sVoiceStatusRegexp = Pattern.compile("gsm\\s+voice\\s+state:\\s*([a-z]+)", 2);
        sDataStatusRegexp = Pattern.compile("gsm\\s+data\\s+state:\\s*([a-z]+)", 2);
        sDownloadSpeedRegexp = Pattern.compile("\\s+download\\s+speed:\\s+(\\d+)\\s+bits.*", 2);
        sMinLatencyRegexp = Pattern.compile("\\s+minimum\\s+latency:\\s+(\\d+)\\s+ms", 2);
        sEmulators = new HashMap();
    }

    public static synchronized EmulatorConsole getConsole(IDevice d) {
        Matcher m = sEmulatorRegexp.matcher(d.getSerialNumber());
        if (m.matches()) {
            int port;
            try {
                port = Integer.parseInt(m.group(1));
                if (port <= 0) {
                    return null;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            EmulatorConsole console = sEmulators.get(port);
            if (console != null && !console.ping()) {
                EmulatorConsole.RemoveConsole(console.mPort);
                console = null;
            }
            if (console == null) {
                console = new EmulatorConsole(port);
                if (console.start()) {
                    sEmulators.put(port, console);
                } else {
                    console = null;
                }
            }
            return console;
        }
        return null;
    }

    private static synchronized void RemoveConsole(int port) {
        sEmulators.remove(port);
    }

    private EmulatorConsole(int port) {
        int[] nArray = new int[7];
        nArray[1] = 14400;
        nArray[2] = 43200;
        nArray[3] = 80000;
        nArray[4] = 236800;
        nArray[5] = 1920000;
        nArray[6] = 14400000;
        this.DOWNLOAD_SPEEDS = nArray;
        this.mBuffer = new byte[1024];
        this.mPort = port;
    }

    private boolean start() {
        InetSocketAddress socketAddr;
        try {
            InetAddress hostAddr = InetAddress.getByName(HOST);
            socketAddr = new InetSocketAddress(hostAddr, this.mPort);
        }
        catch (UnknownHostException e) {
            return false;
        }
        try {
            this.mSocketChannel = SocketChannel.open(socketAddr);
        }
        catch (IOException e1) {
            return false;
        }
        this.readLines();
        return true;
    }

    private synchronized boolean ping() {
        if (this.sendCommand(COMMAND_PING)) {
            return this.readLines() != null;
        }
        return false;
    }

    public synchronized void kill() {
        if (this.sendCommand(COMMAND_KILL)) {
            EmulatorConsole.RemoveConsole(this.mPort);
        }
    }

    public synchronized String getAvdName() {
        if (this.sendCommand(COMMAND_AVD_NAME)) {
            String[] result = this.readLines();
            if (result != null && result.length == 2) {
                return result[0];
            }
            Matcher m = RE_KO.matcher(result[result.length - 1]);
            if (m.matches()) {
                return m.group(1);
            }
        }
        return null;
    }

    public synchronized NetworkStatus getNetworkStatus() {
        String[] result;
        if (this.sendCommand(COMMAND_NETWORK_STATUS) && this.isValid(result = this.readLines())) {
            NetworkStatus status = new NetworkStatus();
            String[] stringArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String line = stringArray[n2];
                Matcher m = sDownloadSpeedRegexp.matcher(line);
                if (m.matches()) {
                    value = m.group(1);
                    status.speed = this.getSpeedIndex(value);
                } else {
                    m = sMinLatencyRegexp.matcher(line);
                    if (m.matches()) {
                        value = m.group(1);
                        status.latency = this.getLatencyIndex(value);
                    }
                }
                ++n2;
            }
            return status;
        }
        return null;
    }

    public synchronized GsmStatus getGsmStatus() {
        String[] result;
        if (this.sendCommand(COMMAND_GSM_STATUS) && this.isValid(result = this.readLines())) {
            GsmStatus status = new GsmStatus();
            String[] stringArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String line = stringArray[n2];
                Matcher m = sVoiceStatusRegexp.matcher(line);
                if (m.matches()) {
                    value = m.group(1);
                    status.voice = GsmMode.getEnum(value.toLowerCase());
                } else {
                    m = sDataStatusRegexp.matcher(line);
                    if (m.matches()) {
                        value = m.group(1);
                        status.data = GsmMode.getEnum(value.toLowerCase());
                    }
                }
                ++n2;
            }
            return status;
        }
        return null;
    }

    public synchronized String setGsmVoiceMode(GsmMode mode) throws InvalidParameterException {
        if (mode == GsmMode.UNKNOWN) {
            throw new InvalidParameterException();
        }
        String command = String.format(COMMAND_GSM_VOICE, mode.getTag());
        return this.processCommand(command);
    }

    public synchronized String setGsmDataMode(GsmMode mode) throws InvalidParameterException {
        if (mode == GsmMode.UNKNOWN) {
            throw new InvalidParameterException();
        }
        String command = String.format(COMMAND_GSM_DATA, mode.getTag());
        return this.processCommand(command);
    }

    public synchronized String call(String number) {
        String command = String.format(COMMAND_GSM_CALL, number);
        return this.processCommand(command);
    }

    public synchronized String cancelCall(String number) {
        String command = String.format(COMMAND_GSM_CANCEL_CALL, number);
        return this.processCommand(command);
    }

    public synchronized String sendSms(String number, String message) {
        String command = String.format(COMMAND_SMS_SEND, number, message);
        return this.processCommand(command);
    }

    public synchronized String setNetworkSpeed(int selectionIndex) {
        String command = String.format(COMMAND_NETWORK_SPEED, NETWORK_SPEEDS[selectionIndex]);
        return this.processCommand(command);
    }

    public synchronized String setNetworkLatency(int selectionIndex) {
        String command = String.format(COMMAND_NETWORK_LATENCY, NETWORK_LATENCIES[selectionIndex]);
        return this.processCommand(command);
    }

    public synchronized String sendLocation(double longitude, double latitude, double elevation) {
        Calendar c = Calendar.getInstance();
        double absLong = Math.abs(longitude);
        int longDegree = (int)Math.floor(absLong);
        char longDirection = 'E';
        if (longitude < 0.0) {
            longDirection = 'W';
        }
        double longMinute = (absLong - Math.floor(absLong)) * 60.0;
        double absLat = Math.abs(latitude);
        int latDegree = (int)Math.floor(absLat);
        char latDirection = 'N';
        if (latitude < 0.0) {
            latDirection = 'S';
        }
        double latMinute = (absLat - Math.floor(absLat)) * 60.0;
        String command = String.format(COMMAND_GPS, c.get(11), c.get(12), c.get(13), c.get(14), latDegree, latMinute, Character.valueOf(latDirection), longDegree, longMinute, Character.valueOf(longDirection));
        return this.processCommand(command);
    }

    private boolean sendCommand(String command) {
        boolean result = false;
        try {
            byte[] bCommand;
            try {
                bCommand = command.getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                boolean bl = result;
                if (!result) {
                    EmulatorConsole.RemoveConsole(this.mPort);
                }
                return bl;
            }
            try {
                AdbHelper.write(this.mSocketChannel, bCommand, bCommand.length, DdmPreferences.getTimeOut());
                result = true;
            }
            catch (IOException e) {
                return false;
            }
        }
        finally {
            if (!result) {
                EmulatorConsole.RemoveConsole(this.mPort);
            }
        }
        return result;
    }

    private String processCommand(String command) {
        if (this.sendCommand(command)) {
            String[] result = this.readLines();
            if (result != null && result.length > 0) {
                Matcher m = RE_KO.matcher(result[result.length - 1]);
                if (m.matches()) {
                    return m.group(1);
                }
                return RESULT_OK;
            }
            return "Unable to communicate with the emulator";
        }
        return "Unable to send command to the emulator";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] readLines() {
        try {
            ByteBuffer buf = ByteBuffer.wrap(this.mBuffer, 0, this.mBuffer.length);
            int numWaits = 0;
            boolean stop = false;
            while (true) {
                int pos;
                if (buf.position() == buf.limit() || stop) {
                    String msg = new String(this.mBuffer, 0, buf.position(), DEFAULT_ENCODING);
                    return msg.split("\r\n");
                }
                int count = this.mSocketChannel.read(buf);
                if (count < 0) {
                    return null;
                }
                if (count == 0) {
                    if (numWaits * 5 > 5000) {
                        return null;
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++numWaits;
                } else {
                    numWaits = 0;
                }
                if (buf.position() < 4 || !this.endsWithOK(pos = buf.position()) && !this.lastLineIsKO(pos)) continue;
                stop = true;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean endsWithOK(int currentPosition) {
        return this.mBuffer[currentPosition - 1] == 10 && this.mBuffer[currentPosition - 2] == 13 && this.mBuffer[currentPosition - 3] == 75 && this.mBuffer[currentPosition - 4] == 79;
    }

    private boolean lastLineIsKO(int currentPosition) {
        if (this.mBuffer[currentPosition - 1] != 10 || this.mBuffer[currentPosition - 2] != 13) {
            return false;
        }
        int i = 0;
        i = currentPosition - 3;
        while (i >= 0) {
            if (this.mBuffer[i] == 10 && i > 0 && this.mBuffer[i - 1] == 13) break;
            --i;
        }
        return this.mBuffer[i + 1] == 75 && this.mBuffer[i + 2] == 79;
    }

    private boolean isValid(String[] result) {
        if (result != null && result.length > 0) {
            return !RE_KO.matcher(result[result.length - 1]).matches();
        }
        return false;
    }

    private int getLatencyIndex(String value) {
        try {
            int latency = Integer.parseInt(value);
            int i = 0;
            while (i < MIN_LATENCIES.length) {
                if (MIN_LATENCIES[i] == latency) {
                    return i;
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private int getSpeedIndex(String value) {
        try {
            int speed = Integer.parseInt(value);
            int i = 0;
            while (i < this.DOWNLOAD_SPEEDS.length) {
                if (this.DOWNLOAD_SPEEDS[i] == speed) {
                    return i;
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static enum GsmMode {
        UNKNOWN(null),
        UNREGISTERED(new String[]{"unregistered", "off"}),
        HOME(new String[]{"home", "on"}),
        ROAMING("roaming"),
        SEARCHING("searching"),
        DENIED("denied");

        private final String[] tags;

        private GsmMode(String tag) {
            this.tags = tag != null ? new String[]{tag} : new String[0];
        }

        private GsmMode(String[] tags) {
            this.tags = tags;
        }

        public static GsmMode getEnum(String tag) {
            GsmMode[] gsmModeArray = GsmMode.values();
            int n = gsmModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GsmMode mode = gsmModeArray[n2];
                String[] stringArray = mode.tags;
                int n3 = mode.tags.length;
                int n4 = 0;
                while (n4 < n3) {
                    String t = stringArray[n4];
                    if (t.equals(tag)) {
                        return mode;
                    }
                    ++n4;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        public String getTag() {
            if (this.tags.length > 0) {
                return this.tags[0];
            }
            return null;
        }
    }

    public static class GsmStatus {
        public GsmMode voice = GsmMode.UNKNOWN;
        public GsmMode data = GsmMode.UNKNOWN;
    }

    public static class NetworkStatus {
        public int speed = -1;
        public int latency = -1;
    }
}

