/*
 * Decompiled with CFR 0.152.
 */
package com.miui.home.launcher.upsidescene.data;

import android.content.ComponentName;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.miui.home.launcher.upsidescene.data.ToggleManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Function {
    private static final String TAG = "FreeStyle.Function";
    public static final int NONE = 0;
    public static final int APP = 1;
    public static final int FOLDER = 2;
    public static final int DRAWER = 3;
    public static final int SYSTEM_GADGET = 4;
    public static final int WIDGET = 5;
    public static final int MTZ_GADGET = 6;
    public static final int TOGGLE = 7;
    public static final String SCHEME_APP = "app:";
    public static final String SCHEME_FOLDER = "folder:";
    public static final String SCHEME_DRAWER = "drawer:";
    public static final String SCHEME_SYSTEM_GADGET = "system_gadget:";
    public static final String SCHEME_WIDGET = "widget:";
    public static final String SCHEME_MTZ_GADGET = "mtz_gadget:";
    public static final String SCHEME_TOGGLE = "toggle:";
    private static final String PARAM_NAME_IS_SHOW_ICON = "is_show_icon";
    private static final String PARAM_NAME_IS_SHOW_TITLE = "is_show_title";
    private static final String PARAM_NAME_ID = "_id";
    UrlData mUrlData;
    int mType;

    protected Function(UrlData urlData, int type) {
        this.mUrlData = urlData;
        this.mType = type;
    }

    public static Function parse(String url) {
        UrlData urlData = UrlData.parse(url);
        if (urlData == null || TextUtils.isEmpty(urlData.scheme)) {
            return new Function(urlData, 0);
        }
        if (SCHEME_APP.equals(urlData.scheme)) {
            return new AppFunction(urlData);
        }
        if (SCHEME_FOLDER.equals(urlData.scheme)) {
            return new FolderFunction(urlData);
        }
        if (SCHEME_DRAWER.equals(urlData.scheme)) {
            return new Function(urlData, 3);
        }
        if (SCHEME_SYSTEM_GADGET.equals(urlData.scheme)) {
            return new SystemGadgetFunction(urlData);
        }
        if (SCHEME_WIDGET.equals(urlData.scheme)) {
            return new WidgetFunction(urlData);
        }
        if (SCHEME_MTZ_GADGET.equals(urlData.scheme)) {
            return new MtzGadgetFunction(urlData);
        }
        if (SCHEME_TOGGLE.equals(urlData.scheme)) {
            return new ToggleFunction(urlData);
        }
        Log.w(TAG, "unknown function type:" + urlData.scheme);
        return new Function(urlData, 0);
    }

    public static Function createFunction(int type) {
        switch (type) {
            case 0: {
                return new Function(null, 0);
            }
            case 1: {
                return new AppFunction(new UrlData(SCHEME_APP));
            }
            case 2: {
                return new FolderFunction(new UrlData(SCHEME_FOLDER));
            }
            case 3: {
                return new Function(new UrlData(SCHEME_DRAWER), 3);
            }
            case 4: {
                return new SystemGadgetFunction(new UrlData(SCHEME_SYSTEM_GADGET));
            }
            case 5: {
                return new WidgetFunction(new UrlData(SCHEME_WIDGET));
            }
            case 6: {
                return new MtzGadgetFunction(new UrlData(SCHEME_MTZ_GADGET));
            }
            case 7: {
                return new ToggleFunction(new UrlData(SCHEME_TOGGLE));
            }
        }
        throw new RuntimeException("unknown function type:" + type);
    }

    public int getType() {
        return this.mType;
    }

    public String toString() {
        return this.mUrlData == null ? "" : this.mUrlData.toString();
    }

    private static String encode(String input) {
        return Base64.encodeToString(input.getBytes(), 11);
    }

    private static String decode(String input) {
        return new String(Base64.decode(input, 8));
    }

    private static boolean getBooleanFromParams(String paramName, UrlData urlData, boolean defaultValue) {
        String strValue = urlData.params.get(paramName);
        if (TextUtils.isEmpty(strValue)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(strValue);
    }

    private static int getIntFromParams(String paramName, UrlData urlData, int defaultValue) {
        String strValue = urlData.params.get(paramName);
        if (TextUtils.isEmpty(strValue)) {
            return defaultValue;
        }
        return Integer.parseInt(strValue);
    }

    public static class AppFunction
    extends Function {
        protected AppFunction(UrlData urlData) {
            super(urlData, 1);
        }

        public ComponentName getComponentName() {
            if (TextUtils.isEmpty(this.mUrlData.data)) {
                return null;
            }
            return ComponentName.unflattenFromString(this.mUrlData.data);
        }

        public void setComponentName(ComponentName componentName) {
            this.mUrlData.data = componentName.flattenToString();
        }

        public void setShowIcon(boolean isShow) {
            this.mUrlData.params.put(Function.PARAM_NAME_IS_SHOW_ICON, Boolean.toString(isShow));
        }

        public void setShowTitle(boolean isShow) {
            this.mUrlData.params.put(Function.PARAM_NAME_IS_SHOW_TITLE, Boolean.toString(isShow));
        }

        public boolean isShowIcon() {
            return Function.getBooleanFromParams(Function.PARAM_NAME_IS_SHOW_ICON, this.mUrlData, true);
        }

        public boolean isShowTitle() {
            return Function.getBooleanFromParams(Function.PARAM_NAME_IS_SHOW_TITLE, this.mUrlData, true);
        }
    }

    public static class FolderFunction
    extends Function {
        private static final String PARAM_NAME_FOLDER_NAME = "folder_name";
        private static final String COMPONENT_NAMES_SEPARATOR = ";";

        public FolderFunction(UrlData urlData) {
            super(urlData, 2);
        }

        public String getFolderName() {
            String codedfolderName = this.mUrlData.params.get(PARAM_NAME_FOLDER_NAME);
            if (TextUtils.isEmpty(codedfolderName)) {
                return null;
            }
            return Function.decode(codedfolderName);
        }

        public void setFolderName(String folderName) {
            this.mUrlData.params.put(PARAM_NAME_FOLDER_NAME, Function.encode(folderName));
        }

        public List<ComponentName> getComponentNames() {
            String[] strComponentNames;
            ArrayList<ComponentName> list = new ArrayList<ComponentName>();
            if (TextUtils.isEmpty(this.mUrlData.data)) {
                return list;
            }
            String[] stringArray = strComponentNames = this.mUrlData.data.split("\\;");
            int n = strComponentNames.length;
            int n2 = 0;
            while (n2 < n) {
                String strComponentName = stringArray[n2];
                list.add(ComponentName.unflattenFromString(strComponentName));
                ++n2;
            }
            return list;
        }

        public void setComponentNames(List<ComponentName> list) {
            StringBuilder sb = new StringBuilder();
            for (ComponentName componentName : list) {
                sb.append(componentName.flattenToShortString()).append(COMPONENT_NAMES_SEPARATOR);
            }
            if (list.size() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this.mUrlData.data = sb.toString();
        }
    }

    public static class MtzGadgetFunction
    extends Function {
        protected MtzGadgetFunction(UrlData urlData) {
            super(urlData, 6);
        }

        public String getMtzRelativePath() {
            return this.mUrlData.data;
        }

        public void setMtzRelativePath(String relativePath) {
            this.mUrlData.data = relativePath;
        }
    }

    public static class SystemGadgetFunction
    extends Function {
        private static final String PARAM_NAME_RESOURCE_PATH = "resource_path";
        private static final String GADGET_NAME_CLEAR_BUTTON = "clear_button";
        private static final String GADGET_NAME_CLOCK_12 = "clock_1x2";
        private static final String GADGET_NAME_CLOCK_22 = "clock_2x2";
        private static final String GADGET_NAME_CLOCK_24 = "clock_2x4";
        private static final String GADGET_NAME_GLOBAL_SEARCH = "global_search";
        private static final String GADGET_NAME_PHOTO_22 = "photo_2x2";
        private static final String GADGET_NAME_PHOTO_24 = "photo_2x4";
        private static final String GADGET_NAME_PHOTO_44 = "photo_4x4";
        private static final String GADGET_NAME_PLAYER = "player";
        private static final String GADGET_NAME_WEATHER_14 = "weather_1x4";
        private static final String GADGET_NAME_WEATHER_24_NEW = "weather_4x4";

        protected SystemGadgetFunction(UrlData urlData) {
            super(urlData, 4);
        }

        public int getGadgetId() {
            if (GADGET_NAME_CLEAR_BUTTON.equals(this.mUrlData.data)) {
                return 12;
            }
            if (GADGET_NAME_CLOCK_12.equals(this.mUrlData.data)) {
                return 4;
            }
            if (GADGET_NAME_CLOCK_22.equals(this.mUrlData.data)) {
                return 5;
            }
            if (GADGET_NAME_CLOCK_24.equals(this.mUrlData.data)) {
                return 6;
            }
            if (GADGET_NAME_GLOBAL_SEARCH.equals(this.mUrlData.data)) {
                return 3;
            }
            if (GADGET_NAME_PHOTO_22.equals(this.mUrlData.data)) {
                return 7;
            }
            if (GADGET_NAME_PHOTO_24.equals(this.mUrlData.data)) {
                return 8;
            }
            if (GADGET_NAME_PHOTO_44.equals(this.mUrlData.data)) {
                return 9;
            }
            if (GADGET_NAME_PLAYER.equals(this.mUrlData.data)) {
                return 2;
            }
            if (GADGET_NAME_WEATHER_14.equals(this.mUrlData.data)) {
                return 10;
            }
            if (GADGET_NAME_WEATHER_24_NEW.equals(this.mUrlData.data)) {
                return 11;
            }
            return -1;
        }

        public int getId() {
            return Function.getIntFromParams(Function.PARAM_NAME_ID, this.mUrlData, 0);
        }

        public String getResourcePath() {
            String path = this.mUrlData.params.get(PARAM_NAME_RESOURCE_PATH);
            if (TextUtils.isEmpty(path)) {
                return null;
            }
            return Function.decode(path);
        }

        public void setResourcePath(String path) {
            path = path == null ? "" : path;
            this.mUrlData.params.put(PARAM_NAME_RESOURCE_PATH, Function.encode(path));
        }

        public void setGadgetInfo(int gadgetId, int id) {
            switch (gadgetId) {
                case 12: {
                    this.mUrlData.data = GADGET_NAME_CLEAR_BUTTON;
                    break;
                }
                case 4: {
                    this.mUrlData.data = GADGET_NAME_CLOCK_12;
                    break;
                }
                case 5: {
                    this.mUrlData.data = GADGET_NAME_CLOCK_22;
                    break;
                }
                case 6: {
                    this.mUrlData.data = GADGET_NAME_CLOCK_24;
                    break;
                }
                case 3: {
                    this.mUrlData.data = GADGET_NAME_GLOBAL_SEARCH;
                    break;
                }
                case 7: {
                    this.mUrlData.data = GADGET_NAME_PHOTO_22;
                    break;
                }
                case 8: {
                    this.mUrlData.data = GADGET_NAME_PHOTO_24;
                    break;
                }
                case 9: {
                    this.mUrlData.data = GADGET_NAME_PHOTO_44;
                    break;
                }
                case 2: {
                    this.mUrlData.data = GADGET_NAME_PLAYER;
                    break;
                }
                case 10: {
                    this.mUrlData.data = GADGET_NAME_WEATHER_14;
                    break;
                }
                case 11: {
                    this.mUrlData.data = GADGET_NAME_WEATHER_24_NEW;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown gadgetId:" + gadgetId);
                }
            }
            this.mUrlData.params.put(Function.PARAM_NAME_ID, Integer.toString(id));
        }
    }

    public static class ToggleFunction
    extends Function {
        protected ToggleFunction(UrlData urlData) {
            super(urlData, 7);
        }

        public String getToggleShortcutName() {
            return ToggleManager.getToggleNameFromString(this.mUrlData.data);
        }

        public String getToggleString() {
            return this.mUrlData.data;
        }

        public boolean isShowIcon() {
            return Function.getBooleanFromParams(Function.PARAM_NAME_IS_SHOW_ICON, this.mUrlData, true);
        }

        public boolean isShowTitle() {
            return Function.getBooleanFromParams(Function.PARAM_NAME_IS_SHOW_TITLE, this.mUrlData, true);
        }
    }

    static class UrlData {
        String scheme;
        String data;
        HashMap<String, String> params = new HashMap();

        public UrlData() {
        }

        public UrlData(String scheme) {
            this.scheme = scheme;
        }

        public String toString() {
            if (TextUtils.isEmpty(this.scheme)) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.scheme);
            if (this.data != null) {
                sb.append(this.data);
            }
            if (this.params.size() > 0) {
                sb.append('?');
                for (Map.Entry<String, String> keyValue : this.params.entrySet()) {
                    sb.append(keyValue.getKey()).append('=').append(keyValue.getValue()).append('|');
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }

        public static UrlData parse(String url) {
            String[] arrParams;
            if (TextUtils.isEmpty(url)) {
                return null;
            }
            int colonIndex = url.indexOf(":");
            if (colonIndex == -1) {
                Log.e(Function.TAG, "parse url failed. not found :. url:" + url);
                return null;
            }
            int questionMarkIndex = url.indexOf("?");
            UrlData urlData = new UrlData();
            urlData.scheme = url.substring(0, colonIndex + 1);
            if (colonIndex >= url.length() - 1) {
                urlData.data = "";
                return urlData;
            }
            int dataEnd = questionMarkIndex == -1 ? url.length() : questionMarkIndex;
            urlData.data = url.substring(colonIndex + 1, dataEnd);
            if (questionMarkIndex == -1 || questionMarkIndex == url.length() - 1) {
                return urlData;
            }
            String strParams = url.substring(questionMarkIndex + 1);
            String[] stringArray = arrParams = strParams.split("\\|");
            int n = arrParams.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] keyValue = param.split("\\=");
                if (keyValue.length == 1) {
                    urlData.params.put(keyValue[0], "");
                } else if (keyValue.length == 2) {
                    urlData.params.put(keyValue[0], keyValue[1]);
                }
                ++n2;
            }
            return urlData;
        }
    }

    public static class WidgetFunction
    extends Function {
        protected WidgetFunction(UrlData urlData) {
            super(urlData, 5);
        }

        public ComponentName getProviderComponent() {
            return ComponentName.unflattenFromString(this.mUrlData.data);
        }

        public int getId() {
            return Function.getIntFromParams(Function.PARAM_NAME_ID, this.mUrlData, 0);
        }

        public void setId(int id) {
            this.mUrlData.params.put(Function.PARAM_NAME_ID, Integer.toString(id));
        }
    }
}

