/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icons;

import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.gui.SetListableJList;
import com.miui.theme.tool.icons.SelectFilter;
import com.miui.theme.tool.icons.TFilter;
import com.miui.theme.tool.icons.TransformFilter;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IconsTransformDialog
extends JDialog
implements ActionListener {
    public static final int DIALOG_WIDTH = 900;
    public static final int DIALOG_HEIGHT = 700;
    private JTabbedPane mTab;
    private FilterPanel mFilterPanel;
    private TransformPanel mTransformPanel;
    private PreviewPanel mPreviewPanel;
    private JButton mSaveButton;
    private JButton mCancelButton;
    private TransformFilter mTransformFilter;
    private JCheckBox mUseModIconCheckBox;

    public IconsTransformDialog() {
        this.setModal(true);
        MainFrame mainFrame = MainFrame.getInstance();
        this.setTitle(ResourceFactory.getString("icon_transform"));
        this.setBounds(mainFrame.getX() + (mainFrame.getWidth() - 900) / 2, mainFrame.getY() + (mainFrame.getHeight() - 700) / 2, 900, 700);
        this.getContentPane().setLayout(new GridBagLayout());
        String path = String.valueOf(ThemeHelper.getS_themeFolderPath()) + File.separator + "icons" + File.separator + "transform_config.xml";
        this.mTransformFilter = new TransformFilter(new File(path));
        this.mTransformFilter.load();
        this.mFilterPanel = new FilterPanel();
        this.mPreviewPanel = new PreviewPanel();
        this.mTransformPanel = new TransformPanel(this.mTransformFilter.mPointsMappingFrom, this.mTransformFilter.mPointsMappingTo);
        this.mTab = new JTabbedPane();
        this.mTab.add(ResourceFactory.getString("icon_transform"), this.mTransformPanel);
        this.mTab.add(ResourceFactory.getString("icon_filter"), this.mFilterPanel);
        this.mUseModIconCheckBox = new JCheckBox();
        this.mUseModIconCheckBox.setSelected(this.mTransformFilter.mUseModIcon);
        this.mUseModIconCheckBox.setHorizontalTextPosition(2);
        this.mUseModIconCheckBox.setText(ResourceFactory.getString("use_mod_icon"));
        this.mUseModIconCheckBox.setHorizontalAlignment(0);
        this.mUseModIconCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mUseModIcon = IconsTransformDialog.this.mUseModIconCheckBox.isSelected();
            }
        });
        this.mSaveButton = new JButton(ResourceFactory.getString("global_save"));
        this.mCancelButton = new JButton(ResourceFactory.getString("global_cancel"));
        this.mSaveButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        int x = 0;
        int y = 0;
        int gap = 0;
        int len = 2;
        GridBagHelper.addComponent(this.getContentPane(), this.mPreviewPanel, x, y, len, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mTab, x, ++y, len, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mUseModIconCheckBox, x, ++y, len, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mSaveButton, x, ++y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.getContentPane(), this.mCancelButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mCancelButton)) {
            this.dispose();
        } else if (e.getSource().equals(this.mSaveButton)) {
            this.mTransformFilter.save();
            this.dispose();
        }
    }

    abstract class FilterEditPanel
    extends JPanel
    implements KeyListener {
        protected TFilter mTFilter;
        protected HashMap<String, JLabel> mLabelMap;
        protected HashMap<String, JTextField> mTextField;
        public ArrayList<String> mKeyList;

        public FilterEditPanel(TFilter tFilter) {
            this.mTFilter = tFilter;
            this.initKeyList();
            this.init();
        }

        abstract void initKeyList();

        public void init() {
            this.mLabelMap = new HashMap();
            this.mTextField = new HashMap();
            for (String key : this.mKeyList) {
                this.mLabelMap.put(key, new JLabel(ResourceFactory.getString("filter." + key)));
            }
            for (String key : this.mKeyList) {
                this.mTextField.put(key, new JTextField());
                this.mTextField.get(key).addKeyListener(this);
            }
            if (this.mTFilter.mParamEntrys != null) {
                int i = 0;
                while (i < this.mTFilter.mParamEntrys.size()) {
                    Map.Entry<String, String> entry = this.mTFilter.mParamEntrys.get(i);
                    for (String key : this.mKeyList) {
                        if (!entry.getKey().equals(key)) continue;
                        this.mTextField.get(key).setText(entry.getValue());
                    }
                    ++i;
                }
            }
            this.setLayout(new GridBagLayout());
            int x = 0;
            int y = 0;
            int gap = 2;
            for (String key : this.mKeyList) {
                GridBagHelper.addComponent(this, this.mLabelMap.get(key), x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
                GridBagHelper.addComponent(this, this.mTextField.get(key), ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
                x = 0;
                ++y;
            }
        }

        public void refresh() {
            ArrayList<Map.Entry<String, String>> paramEntrys = new ArrayList<Map.Entry<String, String>>();
            for (String key : this.mKeyList) {
                String text = this.mTextField.get(key).getText();
                if (text.isEmpty()) continue;
                AbstractMap.SimpleEntry<String, String> paramEntry = new AbstractMap.SimpleEntry<String, String>(key, text);
                paramEntrys.add(paramEntry);
            }
            this.mTFilter.mParamEntrys = paramEntrys;
            IconsTransformDialog.this.mPreviewPanel.refresh();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.refresh();
        }
    }

    class FilterPanel
    extends JPanel
    implements ListSelectionListener,
    ActionListener {
        private SetListableJList mFilterSelectList;
        private JPanel mLeftPanel = new JPanel();
        private JPanel mRightPanel = new JPanel();
        private TFilter mCurrentFilter;
        private JButton mCreateButton;
        private JButton mDeleteButton;
        private JButton mUpButton;
        private JButton mDownButton;

        public FilterPanel() {
            this.setLayout(new GridBagLayout());
            int x = 0;
            int y = 0;
            int gap = 5;
            GridBagHelper.addComponent(this, this.mLeftPanel, x, y, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
            GridBagHelper.addComponent(this, this.mRightPanel, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
            this.initLeftPanel();
        }

        private void initLeftPanel() {
            int x = 0;
            int y = 0;
            int gap = 5;
            this.mLeftPanel.setLayout(new GridBagLayout());
            this.mFilterSelectList = new SetListableJList();
            this.mFilterSelectList.getSelectionModel().setSelectionMode(0);
            this.mFilterSelectList.setList(((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters);
            this.mFilterSelectList.addListSelectionListener(this);
            this.mCreateButton = new JButton(ResourceFactory.getString("create"));
            this.mCreateButton.addActionListener(this);
            this.mDeleteButton = new JButton(ResourceFactory.getString("delete"));
            this.mDeleteButton.addActionListener(this);
            this.mDeleteButton.setEnabled(false);
            this.mUpButton = new JButton(ResourceFactory.getString("up"));
            this.mUpButton.addActionListener(this);
            this.mUpButton.setEnabled(false);
            this.mDownButton = new JButton(ResourceFactory.getString("down"));
            this.mDownButton.addActionListener(this);
            this.mDownButton.setEnabled(false);
            GridBagHelper.addComponent(this.mLeftPanel, this.mCreateButton, x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
            GridBagHelper.addComponent(this.mLeftPanel, this.mDeleteButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
            x = 0;
            GridBagHelper.addComponent(this.mLeftPanel, this.mFilterSelectList, x, ++y, 2, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
            x = 0;
            GridBagHelper.addComponent(this.mLeftPanel, this.mUpButton, x, ++y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
            GridBagHelper.addComponent(this.mLeftPanel, this.mDownButton, ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (-1 == this.mFilterSelectList.getSelectedIndex()) {
                this.mDeleteButton.setEnabled(false);
                this.mUpButton.setEnabled(false);
                this.mDownButton.setEnabled(false);
                return;
            }
            if (this.mFilterSelectList.getSelectedIndex() == 0) {
                this.mDeleteButton.setEnabled(true);
                this.mUpButton.setEnabled(false);
                this.mDownButton.setEnabled(true);
            } else if (this.mFilterSelectList.getSelectedIndex() == ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.size() - 1) {
                this.mDeleteButton.setEnabled(true);
                this.mUpButton.setEnabled(true);
                this.mDownButton.setEnabled(false);
            } else {
                this.mDeleteButton.setEnabled(true);
                this.mUpButton.setEnabled(true);
                this.mDownButton.setEnabled(true);
            }
            this.initRightPanel();
        }

        private void initRightPanel() {
            this.mCurrentFilter = ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.size() == 0 ? null : (TFilter)this.mFilterSelectList.getSelectedValue();
            this.mRightPanel.removeAll();
            this.mRightPanel.setLayout(new BorderLayout());
            if (this.mCurrentFilter == null) {
                return;
            }
            if (this.mCurrentFilter.mName.equals("Hsl")) {
                this.mRightPanel.add((Component)new HSLEditPanel(this.mCurrentFilter), "Center");
            }
            this.mCurrentFilter.mName.equals("Edges");
            if (this.mCurrentFilter.mName.equals("Levels")) {
                this.mRightPanel.add((Component)new LevelsEditPanel(this.mCurrentFilter), "Center");
            }
            if (this.mCurrentFilter.mName.equals("GrayScale")) {
                this.mRightPanel.add((Component)new GrayScaleEditPanel(this.mCurrentFilter), "Center");
            }
            this.mRightPanel.invalidate();
            this.mRightPanel.validate();
            this.mRightPanel.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TFilter t;
            int index = this.mFilterSelectList.getSelectedIndex();
            if (e.getSource().equals(this.mCreateButton)) {
                SelectFilter sf = new SelectFilter();
                sf.setVisible(true);
                if (sf.mFilterResult != null) {
                    ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.add(sf.mFilterResult);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FilterPanel.this.mFilterSelectList.setSelectedIndex(FilterPanel.this.mFilterSelectList.getModel().getSize() - 1);
                            FilterPanel.this.initRightPanel();
                        }
                    });
                }
            }
            if (e.getSource().equals(this.mDeleteButton)) {
                if (index == -1) {
                    return;
                }
                ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.remove(index);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FilterPanel.this.mFilterSelectList.getModel().getSize() <= 0) {
                            FilterPanel.this.mFilterSelectList.setSelectedIndex(-1);
                        } else {
                            FilterPanel.this.mFilterSelectList.setSelectedIndex(0);
                        }
                        FilterPanel.this.initRightPanel();
                    }
                });
            }
            if (e.getSource().equals(this.mUpButton)) {
                if (index <= 0) {
                    return;
                }
                t = ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.get(index);
                ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.set(index, ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.get(index - 1));
                ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.set(index - 1, t);
                this.mFilterSelectList.setSelectedIndex(index - 1);
            }
            if (e.getSource().equals(this.mDownButton)) {
                if (index >= ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.size() - 1) {
                    return;
                }
                t = ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.get(index);
                ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.set(index, ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.get(index + 1));
                ((IconsTransformDialog)IconsTransformDialog.this).mTransformFilter.mFilters.set(index + 1, t);
                this.mFilterSelectList.setSelectedIndex(index + 1);
            }
            IconsTransformDialog.this.mPreviewPanel.refresh();
            this.mFilterSelectList.updateUI();
        }
    }

    class GrayScaleEditPanel
    extends FilterEditPanel {
        public GrayScaleEditPanel(TFilter tFilter) {
            super(tFilter);
        }

        @Override
        void initKeyList() {
            this.mKeyList = new ArrayList();
            this.mKeyList.add("BlackColor");
            this.mKeyList.add("WhiteColor");
        }
    }

    class HSLEditPanel
    extends FilterEditPanel {
        public HSLEditPanel(TFilter tFilter) {
            super(tFilter);
        }

        @Override
        void initKeyList() {
            this.mKeyList = new ArrayList();
            this.mKeyList.add("HueModify");
            this.mKeyList.add("HueAdjust");
            this.mKeyList.add("SaturationModify");
            this.mKeyList.add("SaturationAdjust");
            this.mKeyList.add("LightnessModify");
            this.mKeyList.add("LightnessAdjust");
        }
    }

    class IconCell
    extends JPanel {
        private Image mIcon;
        private JLabel mLabel;

        public IconCell(Image icon) {
            this.mIcon = icon;
            this.mLabel = new JLabel(GUIUtil.getIcon(icon, GUIUtil.HDPI_SIZE, 4));
            this.add(this.mLabel);
        }
    }

    class LevelsEditPanel
    extends FilterEditPanel {
        public LevelsEditPanel(TFilter tFilter) {
            super(tFilter);
        }

        @Override
        void initKeyList() {
            this.mKeyList = new ArrayList();
            this.mKeyList.add("InputMin");
            this.mKeyList.add("InputMiddle");
            this.mKeyList.add("InputMax");
            this.mKeyList.add("OutputMin");
            this.mKeyList.add("OutputMax");
        }
    }

    class PreviewPanel
    extends JPanel {
        public static final int PREVIEW_SIZE = 8;
        BufferedImage[] icons = new BufferedImage[8];

        public PreviewPanel() {
            String iconsPath = String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + "defaulticons";
            File[] files = new File(iconsPath).listFiles();
            int i = 0;
            while (i < 8 && i < files.length) {
                this.icons[i] = GUIUtil.getImage(files[i]);
                ++i;
            }
            this.setLayout(new GridBagLayout());
            this.refresh();
        }

        public void refresh() {
            int x = 0;
            int y = 0;
            int gap = 0;
            this.removeAll();
            int i = 0;
            while (i < this.icons.length) {
                if (this.icons[i] != null) {
                    Image bi = IconsTransformDialog.this.mTransformFilter.render(this.icons[i]);
                    GridBagHelper.addComponent(this, new IconCell(bi), x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
                    ++x;
                }
                ++i;
            }
            this.validate();
            this.repaint();
        }
    }

    class TransformPanel
    extends JPanel
    implements KeyListener {
        private List<Float> mPointsMappingFrom;
        private List<Float> mPointsMappingTo;
        private ArrayList<JTextField> mPointsFromList;
        private ArrayList<JTextField> mPointsToList;
        private JButton mResetButton;

        public TransformPanel(List<Float> pointsMappingFrom, List<Float> pointsMappingTo) {
            this.mPointsMappingFrom = pointsMappingFrom;
            this.mPointsMappingTo = pointsMappingTo;
            if (this.mPointsMappingFrom.size() != 8) {
                this.mPointsMappingFrom.clear();
                this.mPointsMappingTo.clear();
                this.mPointsMappingFrom.add(Float.valueOf(0.0f));
                this.mPointsMappingFrom.add(Float.valueOf(0.0f));
                this.mPointsMappingFrom.add(Float.valueOf(0.0f));
                this.mPointsMappingFrom.add(Float.valueOf(90.0f));
                this.mPointsMappingFrom.add(Float.valueOf(90.0f));
                this.mPointsMappingFrom.add(Float.valueOf(90.0f));
                this.mPointsMappingFrom.add(Float.valueOf(90.0f));
                this.mPointsMappingFrom.add(Float.valueOf(0.0f));
                int i = 0;
                while (i < this.mPointsMappingFrom.size()) {
                    this.mPointsMappingTo.add(this.mPointsMappingFrom.get(i));
                    ++i;
                }
            }
            this.init();
        }

        private void init() {
            this.mPointsFromList = new ArrayList();
            this.mPointsToList = new ArrayList();
            this.setLayout(new GridBagLayout());
            int x = 0;
            int y = 0;
            int gap = 10;
            int len = 10;
            GridBagHelper.addComponent(this, new JLabel(ResourceFactory.getString("size_adjust")), x, y, len, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
            int i = 0;
            while (i < this.mPointsMappingFrom.size() / 2) {
                this.mPointsFromList.add(2 * i, new JTextField("" + this.mPointsMappingFrom.get(2 * i)));
                this.mPointsFromList.get(2 * i).setEnabled(false);
                this.mPointsFromList.add(2 * i + 1, new JTextField("" + this.mPointsMappingFrom.get(2 * i + 1)));
                this.mPointsFromList.get(2 * i + 1).setEnabled(false);
                this.mPointsToList.add(2 * i, new JTextField("" + this.mPointsMappingTo.get(2 * i)));
                this.mPointsToList.add(2 * i + 1, new JTextField("" + this.mPointsMappingTo.get(2 * i + 1)));
                x = 0;
                GridBagHelper.addComponent(this, new JLabel(ResourceFactory.getString("resource.x")), x, ++y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
                GridBagHelper.addComponent(this, this.mPointsFromList.get(2 * i), ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
                GridBagHelper.addComponent(this, new JLabel(ResourceFactory.getString("resource.y")), ++x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
                GridBagHelper.addComponent(this, this.mPointsFromList.get(2 * i + 1), ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
                GridBagHelper.addComponent(this, new JLabel(ResourceFactory.getString("mapping_to")), ++x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
                GridBagHelper.addComponent(this, new JLabel(ResourceFactory.getString("resource.x")), ++x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
                GridBagHelper.addComponent(this, this.mPointsToList.get(2 * i), ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
                GridBagHelper.addComponent(this, new JLabel(ResourceFactory.getString("resource.y")), ++x, y, 1, 1, 0, 0, gap, gap, 0.0, 0.0, 1, 10);
                GridBagHelper.addComponent(this, this.mPointsToList.get(2 * i + 1), ++x, y, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 10);
                ++i;
            }
            x = 0;
            this.mResetButton = new JButton(ResourceFactory.getString("reset"));
            GridBagHelper.addComponent(this, this.mResetButton, x, ++y, len, 1, 0, 0, gap, gap, 1.0, 0.0, 0, 10);
            this.mResetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformPanel.this.mPointsMappingTo.clear();
                    int i = 0;
                    while (i < TransformPanel.this.mPointsMappingFrom.size()) {
                        TransformPanel.this.mPointsMappingTo.add(i, (Float)TransformPanel.this.mPointsMappingFrom.get(i));
                        ((JTextField)TransformPanel.this.mPointsToList.get(i)).setText("" + TransformPanel.this.mPointsMappingTo.get(i));
                        ++i;
                    }
                    TransformPanel.this.refresh();
                }
            });
            i = 0;
            while (i < this.mPointsToList.size()) {
                this.mPointsToList.get(i).addKeyListener(this);
                ++i;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.refresh();
        }

        public void refresh() {
            this.mPointsMappingFrom.clear();
            this.mPointsMappingTo.clear();
            int i = 0;
            while (i < this.mPointsFromList.size()) {
                this.mPointsMappingFrom.add(Float.valueOf(Float.parseFloat(this.mPointsFromList.get(i).getText())));
                this.mPointsMappingTo.add(Float.valueOf(Float.parseFloat(this.mPointsToList.get(i).getText())));
                ++i;
            }
            IconsTransformDialog.this.mPreviewPanel.refresh();
        }
    }
}

