/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.ninepatch;

import com.miui.theme.tool.ninepatch.NinePatchChunk;
import com.miui.theme.tool.ninepatch.NinePatchPngFormatException;
import com.miui.theme.tool.ninepatch.NinePatchUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class NinePatchEncoder {
    public ByteArrayInputStream encode(InputStream in) throws IOException, NinePatchPngFormatException {
        byte[] destData = this.getEncodedByteData(in);
        if (destData == null) {
            return null;
        }
        return new ByteArrayInputStream(destData);
    }

    public boolean encode(InputStream in, OutputStream out2) throws IOException, NinePatchPngFormatException {
        byte[] destData = this.getEncodedByteData(in);
        if (destData == null) {
            return false;
        }
        IOUtils.write(destData, out2);
        return true;
    }

    public void encode(String inputFileName, String outputFileName) throws IOException, NinePatchPngFormatException {
        FileInputStream in = new FileInputStream(new File(inputFileName));
        FileOutputStream out = new FileOutputStream(outputFileName);
        this.encode(in, out);
        in.close();
        out.close();
    }

    private byte[] getEncodedByteData(InputStream in) throws IOException, NinePatchPngFormatException {
        byte[] data = IOUtils.toByteArray(in);
        in.close();
        NinePatchChunk np = new NinePatchChunk();
        boolean has9PitchChunk = np.set9PatchChunkFromImageData(data);
        if (!has9PitchChunk) {
            return null;
        }
        BufferedImage im = ImageIO.read(new ByteArrayInputStream(data));
        int w = im.getWidth();
        int h = im.getHeight();
        if (w <= 2 || h <= 2) {
            return null;
        }
        BufferedImage im2 = im.getSubimage(1, 1, w -= 2, h -= 2);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)im2, "png", bout);
        bout.flush();
        byte[] data2 = bout.toByteArray();
        bout.close();
        byte[] destData = new byte[data2.length + 12 + np.da.length];
        this.addNinePatchChunk(data2, destData, np);
        return destData;
    }

    private void addNinePatchChunk(byte[] srcData, byte[] destData, NinePatchChunk np) throws IOException {
        int i = 0;
        while (i < 33) {
            destData[i] = srcData[i];
            ++i;
        }
        int k = 33;
        NinePatchUtils.getBytesFromInt(destData, i, np.size);
        NinePatchUtils.getBytesFromInt(destData, i += 4, np.TYPE);
        i += 4;
        int j = 0;
        while (j < np.da.length) {
            destData[i] = np.da[j];
            ++j;
            ++i;
        }
        NinePatchUtils.getBytesFromInt(destData, i, np.crcValue);
        i += 4;
        while (k < srcData.length && i < destData.length) {
            destData[i] = srcData[k];
            ++i;
            ++k;
        }
    }
}

