/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.xml;

import com.miui.theme.tool.apk.Activity;
import com.miui.theme.tool.apk.ApkInfo;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AndroidManifestParser {
    public ApkInfo parserXml(String fileName) {
        Element manifest;
        block19: {
            SAXReader saxReader;
            File inputXml;
            block18: {
                inputXml = new File(fileName);
                saxReader = new SAXReader();
                File f = new File(fileName);
                if (f.exists()) break block18;
                return null;
            }
            Document document = saxReader.read(inputXml);
            manifest = document.getRootElement();
            if (manifest != null && manifest.getNodeType() == 1 && manifest.getName().equals("manifest")) break block19;
            return null;
        }
        try {
            String pkg = manifest.attribute("package").getText();
            ApkInfo apkInfo = new ApkInfo();
            Iterator i = manifest.elementIterator();
            while (i.hasNext()) {
                Element item = (Element)i.next();
                if (item.getNodeType() != 1 || !item.getName().equals("application")) continue;
                String icon = item.attribute("icon").getText();
                if (icon.startsWith("@") && icon.contains("/")) {
                    icon = icon.substring(icon.lastIndexOf(47) + 1, icon.length());
                }
                if (!icon.endsWith(".png")) {
                    icon = String.valueOf(icon) + ".png";
                }
                apkInfo.setAppIcon(icon);
                Iterator it = item.elementIterator();
                while (it.hasNext()) {
                    Element activity = (Element)it.next();
                    if (activity.getNodeType() != 1 || !activity.getName().equals("activity")) continue;
                    String className = activity.attribute("name").getText();
                    if (!(className.startsWith(".") || className.startsWith(pkg) || ThemeHelper.startWidthNetName(className))) {
                        className = "." + className;
                    }
                    boolean isMainAction = false;
                    boolean isLauncher = false;
                    boolean isDefault = false;
                    Iterator intentIt = activity.elementIterator();
                    while (intentIt.hasNext()) {
                        Element intent = (Element)intentIt.next();
                        if (intent.getNodeType() != 1 || !intent.getName().equals("intent-filter")) continue;
                        Iterator actionIt = intent.elementIterator();
                        while (actionIt.hasNext()) {
                            Element action = (Element)actionIt.next();
                            if (action.getNodeType() != 1) continue;
                            if (action.getName().equals("action")) {
                                String actionName = action.attribute("name").getText();
                                if (!actionName.equals("android.intent.action.MAIN")) continue;
                                isMainAction = true;
                                continue;
                            }
                            if (!action.getName().equals("category")) continue;
                            String categoryName = action.attribute("name").getText();
                            if (categoryName.equals("android.intent.category.DEFAULT")) {
                                isDefault = true;
                            }
                            if (!categoryName.equals("android.intent.category.LAUNCHER")) continue;
                            isLauncher = true;
                        }
                        if (isMainAction && isLauncher) break;
                    }
                    if (!isMainAction || !isLauncher) continue;
                    String iconName = "";
                    if (activity.attribute("icon") != null) {
                        iconName = activity.attribute("icon").getText();
                    }
                    if (iconName.startsWith("@") && iconName.contains("/")) {
                        iconName = iconName.substring(iconName.lastIndexOf(47) + 1, iconName.length());
                    }
                    Activity ac = new Activity(pkg, className, isDefault);
                    if (iconName.equals("")) {
                        iconName = icon;
                        ac.setSameWithPackageIcon(true);
                    }
                    if (!iconName.endsWith(".png")) {
                        iconName = String.valueOf(iconName) + ".png";
                    }
                    ac.setIcon(iconName);
                    apkInfo.addActivity(ac);
                }
            }
            apkInfo.refresh();
            return apkInfo;
        }
        catch (DocumentException e) {
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

