/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class EdgesFilter
implements IImageFilter {
    private static float[] sTempHsl = new float[3];

    @Override
    public void process(ImageData imgData) {
        int width = imgData.width;
        int height = imgData.height;
        int[] pixels = imgData.pixels;
        int[][] luminance = new int[width][height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int color = pixels[y * width + x];
                luminance[x][y] = ImageFilterUtils.convertColorToGrayscale(color);
                ++x;
            }
            ++y;
        }
        int y2 = 1;
        while (y2 < height - 1) {
            int x = 1;
            while (x < width - 1) {
                int colorIndex = y2 * width + x;
                int grayX = -luminance[x - 1][y2 - 1] + luminance[x - 1][y2 - 1 + 2] - 2 * luminance[x - 1 + 1][y2 - 1] + 2 * luminance[x - 1 + 1][y2 - 1 + 2] - luminance[x - 1 + 2][y2 - 1] + luminance[x - 1 + 2][y2 - 1 + 2];
                int grayY = luminance[x - 1][y2 - 1] + 2 * luminance[x - 1][y2 - 1 + 1] + luminance[x - 1][y2 - 1 + 2] - luminance[x - 1 + 2][y2 - 1] - 2 * luminance[x - 1 + 2][y2 - 1 + 1] - luminance[x - 1 + 2][y2 - 1 + 2];
                int magnitude = 255 - ImageFilterUtils.clamp(0, Math.abs(grayX) + Math.abs(grayY), 255);
                ImageFilterUtils.RgbToHsl(pixels[colorIndex], sTempHsl);
                EdgesFilter.sTempHsl[2] = (float)magnitude / 255.0f;
                int newRgb = ImageFilterUtils.HslToRgb(sTempHsl);
                pixels[colorIndex] = newRgb & 0xFFFFFF | pixels[colorIndex] & 0xFF000000;
                ++x;
            }
            ++y2;
        }
    }
}

